/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.curios.sets.alchemical;

import com.sammy.malum.common.capability.MalumPlayerDataCapability;
import com.sammy.malum.common.item.IMalumEventResponderItem;
import com.sammy.malum.common.item.curiosities.curios.AbstractMalumCurioItem;
import com.sammy.malum.common.item.curiosities.curios.MalumCurioItem;
import com.sammy.malum.compability.irons_spellbooks.IronsSpellsCompat;
import com.sammy.malum.core.handlers.SoulWardHandler;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class CurioManaweavingRing
extends MalumCurioItem
implements IMalumEventResponderItem {
    public CurioManaweavingRing(Item.Properties builder) {
        super(builder, AbstractMalumCurioItem.MalumTrinketType.ALCHEMICAL);
    }

    @Override
    public void addExtraTooltipLines(Consumer<Component> consumer) {
        consumer.accept(CurioManaweavingRing.positiveEffect("spirits_weave_mana", new Object[0]));
        if (IronsSpellsCompat.LOADED) {
            consumer.accept(CurioManaweavingRing.positiveEffect("spirits_weave_mana_irons_spellbooks", new Object[0]));
        }
    }

    @Override
    public void pickupSpirit(LivingEntity collector, double arcaneResonance) {
        if (collector instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)collector;
            SoulWardHandler handler = MalumPlayerDataCapability.getCapability((Player)player).soulWardHandler;
            handler.soulWardProgress -= (double)(2.0f * SoulWardHandler.getSoulWardCooldown((Player)player)) * arcaneResonance;
            IronsSpellsCompat.generateMana(player, 10.0 * arcaneResonance);
            MalumPlayerDataCapability.syncTrackingAndSelf((Player)player);
        }
    }
}

