/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.curios.sets.misc;

import com.google.common.collect.Multimap;
import com.sammy.malum.common.item.IMalumEventResponderItem;
import com.sammy.malum.common.item.curiosities.curios.AbstractMalumCurioItem;
import com.sammy.malum.common.item.curiosities.curios.MalumCurioItem;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import top.theillusivec4.curios.api.SlotContext;

public class CurioWaterNecklace
extends MalumCurioItem
implements IMalumEventResponderItem {
    public CurioWaterNecklace(Item.Properties builder) {
        super(builder, AbstractMalumCurioItem.MalumTrinketType.GILDED);
    }

    @Override
    public void addExtraTooltipLines(Consumer<Component> consumer) {
        consumer.accept(CurioWaterNecklace.positiveEffect("better_conduit_power", new Object[0]));
    }

    @Override
    public void addAttributeModifiers(Multimap<Attribute, AttributeModifier> map, final SlotContext slotContext, ItemStack stack) {
        this.addAttributeModifier(map, (Attribute)ForgeMod.SWIM_SPEED.get(), uuid -> new AttributeModifier((UUID)uuid, "Curio Swim Speed", 0.15f, AttributeModifier.Operation.ADDITION){

            public double m_22218_() {
                double amount = super.m_22218_();
                if (slotContext.entity() != null && slotContext.entity().m_21023_(MobEffects.f_19592_)) {
                    return amount * 3.0;
                }
                return amount;
            }
        });
        super.addAttributeModifiers(map, slotContext, stack);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        AttributeInstance attribute;
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity.m_9236_().m_46467_() % 40L == 0L && livingEntity.m_6069_() && (attribute = livingEntity.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get())) != null) {
            attribute.m_22129_();
        }
        if (livingEntity.m_9236_().m_46467_() % 20L == 0L && livingEntity.m_21023_(MobEffects.f_19592_)) {
            livingEntity.m_5634_(2.0f);
        }
    }

    public void takeDamageEvent(LivingHurtEvent event, LivingEntity attacker, LivingEntity attacked, ItemStack stack) {
        if (attacked.m_21023_(MobEffects.f_19592_)) {
            event.setAmount(event.getAmount() * 0.5f);
        }
    }
}

