/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.curios.sets.prospector;

import com.sammy.malum.common.item.curiosities.curios.AbstractMalumCurioItem;
import com.sammy.malum.common.item.curiosities.curios.MalumCurioItem;
import com.sammy.malum.registry.common.item.ItemRegistry;
import com.sammy.malum.registry.common.item.ItemTagRegistry;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.event.level.ExplosionEvent;
import team.lodestar.lodestone.helpers.CurioHelper;
import top.theillusivec4.curios.api.CuriosApi;

public class CurioProspectorBelt
extends MalumCurioItem {
    public CurioProspectorBelt(Item.Properties builder) {
        super(builder, AbstractMalumCurioItem.MalumTrinketType.METALLIC);
    }

    @Override
    public void addExtraTooltipLines(Consumer<Component> consumer) {
        consumer.accept(CurioProspectorBelt.positiveEffect("enchanted_explosions", Enchantments.f_44987_.m_44700_(3).m_6881_().m_130940_(ChatFormatting.BLUE)));
        consumer.accept(CurioProspectorBelt.positiveEffect("explosions_spare_valuables", new Object[0]));
    }

    public static void processExplosion(ExplosionEvent.Detonate event) {
        LivingEntity exploder = event.getExplosion().m_252906_();
        if (exploder != null && CurioHelper.hasCurioEquipped((LivingEntity)exploder, (Item)((Item)ItemRegistry.BELT_OF_THE_PROSPECTOR.get()))) {
            event.getAffectedEntities().removeIf(e -> {
                ItemEntity itemEntity;
                return e instanceof ItemEntity && (itemEntity = (ItemEntity)e).m_32055_().m_204117_(ItemTagRegistry.PROSPECTORS_TREASURE);
            });
        }
    }

    public static LootParams.Builder applyFortune(Entity source, LootParams.Builder builder) {
        LivingEntity livingEntity;
        if (source instanceof LivingEntity && CurioHelper.hasCurioEquipped((LivingEntity)(livingEntity = (LivingEntity)source), (Item)((Item)ItemRegistry.BELT_OF_THE_PROSPECTOR.get()))) {
            int fortuneBonus = 3 + CuriosApi.getCuriosInventory((LivingEntity)livingEntity).map(h -> h.getFortuneLevel(null)).orElse(0);
            ItemStack diamondPickaxe = new ItemStack((ItemLike)Items.f_42390_);
            diamondPickaxe.m_41663_(Enchantments.f_44987_, fortuneBonus);
            return builder.m_287286_(LootContextParams.f_81463_, (Object)diamondPickaxe);
        }
        return builder;
    }
}

