/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.weapons.scythe;

import com.sammy.malum.common.item.curiosities.weapons.scythe.MalumScytheItem;
import com.sammy.malum.core.helpers.ParticleHelper;
import com.sammy.malum.registry.common.DamageTypeRegistry;
import com.sammy.malum.registry.common.DamageTypeTagRegistry;
import com.sammy.malum.registry.common.MobEffectRegistry;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import team.lodestar.lodestone.helpers.SoundHelper;

public class EdgeOfDeliveranceItem
extends MalumScytheItem {
    public EdgeOfDeliveranceItem(Tier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builderIn) {
        super(tier, attackDamageIn, attackSpeedIn, builderIn);
    }

    @Override
    public void hurtEvent(LivingHurtEvent event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        super.hurtEvent(event, attacker, target, stack);
        Level level = attacker.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        DamageSource source = event.getSource();
        if (source.m_269533_(DamageTypeTagRegistry.IS_SCYTHE)) {
            MobEffect effect = (MobEffect)MobEffectRegistry.IMMINENT_DELIVERANCE.get();
            if (target.m_21023_(effect)) {
                event.setAmount(event.getAmount() * 2.0f);
                SoundHelper.playSound((Entity)target, (SoundEvent)((SoundEvent)SoundRegistry.MALIGNANT_METAL_MOTIF.get()), (float)2.0f, (float)1.25f);
                SoundHelper.playSound((Entity)target, (SoundEvent)((SoundEvent)SoundRegistry.MALIGNANT_METAL_MOTIF.get()), (float)3.0f, (float)1.75f);
                ParticleHelper.SlashParticleEffectBuilder particle = ParticleHelper.createSlashingEffect(ParticleEffectTypeRegistry.EDGE_OF_DELIVERANCE_CRIT);
                if (!EdgeOfDeliveranceItem.canSweep(attacker)) {
                    particle.setVertical();
                }
                particle.spawnTargetBoundSlashingParticle((Entity)attacker, target);
                target.m_21195_(effect);
            } else {
                event.setAmount(event.getAmount() * 0.5f);
                if (source.m_276093_(DamageTypeRegistry.HIDDEN_BLADE_COUNTER) && attacker.m_217043_().m_188501_() >= 0.4f) {
                    return;
                }
                target.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.IMMINENT_DELIVERANCE.get(), 60));
            }
        }
    }

    @Override
    public SoundEvent getScytheSound(boolean canSweep) {
        return canSweep ? (SoundEvent)SoundRegistry.EDGE_OF_DELIVERANCE_SWEEP.get() : (SoundEvent)SoundRegistry.EDGE_OF_DELIVERANCE_CUT.get();
    }
}

