/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.weapons.staff;

import com.sammy.malum.common.entity.bolt.AbstractBoltProjectileEntity;
import com.sammy.malum.common.entity.bolt.AuricFlameBoltEntity;
import com.sammy.malum.common.entity.nitrate.EthericNitrateEntity;
import com.sammy.malum.common.item.curiosities.weapons.staff.AbstractStaffItem;
import com.sammy.malum.registry.client.ParticleRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.registry.common.LodestoneAttributeRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.DirectionalBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.LodestoneBehaviorComponent;

public class AuricFlameStaffItem
extends AbstractStaffItem {
    public static final ColorParticleData AURIC_COLOR_DATA = EthericNitrateEntity.AURIC_COLOR_DATA;

    public AuricFlameStaffItem(Tier tier, float magicDamage, Item.Properties builderIn) {
        super(tier, -0.2f, 30, magicDamage, builderIn);
    }

    @Override
    public void hurtEvent(LivingHurtEvent event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        if (!(event.getSource().m_7640_() instanceof AbstractBoltProjectileEntity)) {
            target.m_20254_(4);
            SoundHelper.playSound((Entity)target, (SoundEvent)((SoundEvent)SoundRegistry.AURIC_FLAME_MOTIF.get()), (SoundSource)attacker.m_5720_(), (float)1.0f, (float)1.25f);
        }
        super.hurtEvent(event, attacker, target, stack);
    }

    @Override
    public int getCooldownDuration(Level level, LivingEntity livingEntity) {
        return 160;
    }

    @Override
    public int getProjectileCount(Level level, LivingEntity livingEntity, float pct) {
        return pct == 1.0f ? 5 : 0;
    }

    @Override
    public void fireProjectile(LivingEntity player, ItemStack stack, Level level, InteractionHand hand, float chargePercentage, int count) {
        float ceil = (float)Math.ceil((float)count / 2.0f);
        float spread = count > 0 ? ceil * 0.05f * (float)((long)count % 2L == 0L ? 1 : -1) : 0.0f;
        float pitchOffset = count > 0 ? 4.0f + (2.0f - ceil * 4.0f) : -2.5f;
        int spawnDelay = 1 + count * 2;
        float velocity = 2.0f;
        float magicDamage = (float)player.m_21204_().m_22181_((Attribute)LodestoneAttributeRegistry.MAGIC_DAMAGE.get()) - 2.0f;
        Vec3 pos = this.getProjectileSpawnPos(player, hand, 0.5f, 0.5f);
        AuricFlameBoltEntity entity = new AuricFlameBoltEntity(level, pos.f_82479_, pos.f_82480_, pos.f_82481_);
        entity.setData((Entity)player, magicDamage, spawnDelay);
        entity.m_37446_(stack);
        entity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), -pitchOffset, velocity, 0.0f);
        Vec3 projectileDirection = entity.m_20184_();
        float yRot = (float)(Mth.m_14136_((double)projectileDirection.f_82479_, (double)projectileDirection.f_82481_) * 57.2957763671875);
        float yaw = (float)Math.toRadians(yRot);
        Vec3 left = new Vec3(-Math.cos(yaw), 0.0, Math.sin(yaw));
        entity.m_20256_(entity.m_20184_().m_82549_(left.m_82490_((double)spread)));
        level.m_7967_((Entity)entity);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void spawnChargeParticles(Level pLevel, LivingEntity pLivingEntity, Vec3 pos, ItemStack pStack, float pct) {
        RandomSource random = pLevel.f_46441_;
        SpinParticleData spinData = SpinParticleData.createRandomDirection((RandomSource)random, (float)0.25f, (float)0.5f).setSpinOffset(RandomHelper.randomBetween((RandomSource)random, (float)0.0f, (float)6.28f)).build();
        WorldParticleBuilder.create(ParticleRegistry.HEXAGON, (LodestoneBehaviorComponent)new DirectionalBehaviorComponent(pLivingEntity.m_20154_().m_82541_())).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).setTransparencyData(GenericParticleData.create((float)(0.5f * pct), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setScaleData(GenericParticleData.create((float)(0.35f * pct), (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setSpinData(spinData).setColorData(AURIC_COLOR_DATA).setLifetime(5).setMotion(pLivingEntity.m_20154_().m_82541_().m_82490_((double)0.05f)).enableNoClip().enableForcedSpawn().setLifeDelay(2).spawn(pLevel, pos.f_82479_, pos.f_82480_, pos.f_82481_).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).spawn(pLevel, pos.f_82479_, pos.f_82480_, pos.f_82481_);
    }
}

