/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.weapons.staff;

import com.sammy.malum.common.entity.bolt.HexBoltEntity;
import com.sammy.malum.common.item.curiosities.weapons.staff.AbstractStaffItem;
import com.sammy.malum.registry.client.ParticleRegistry;
import com.sammy.malum.registry.common.SpiritTypeRegistry;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.registry.common.LodestoneAttributeRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.DirectionalBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.LodestoneBehaviorComponent;

public class HexStaffItem
extends AbstractStaffItem {
    public HexStaffItem(Tier tier, float magicDamage, Item.Properties builderIn) {
        super(tier, 15, magicDamage, builderIn);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void spawnChargeParticles(Level pLevel, LivingEntity pLivingEntity, Vec3 pos, ItemStack pStack, float pct) {
        RandomSource random = pLevel.f_46441_;
        SpinParticleData spinData = SpinParticleData.createRandomDirection((RandomSource)random, (float)0.25f, (float)0.5f).setSpinOffset(RandomHelper.randomBetween((RandomSource)random, (float)0.0f, (float)6.28f)).build();
        WorldParticleBuilder.create(ParticleRegistry.HEXAGON, (LodestoneBehaviorComponent)new DirectionalBehaviorComponent(pLivingEntity.m_20154_().m_82541_())).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).setTransparencyData(GenericParticleData.create((float)(0.6f * pct), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setSpinData(spinData).setScaleData(GenericParticleData.create((float)(0.3f * pct), (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setColorData(SpiritTypeRegistry.WICKED_SPIRIT.createColorData().build()).setLifetime(5).setLifeDelay(2).setMotion(pLivingEntity.m_20154_().m_82541_().m_82490_((double)0.05f)).enableNoClip().enableForcedSpawn().spawn(pLevel, pos.f_82479_, pos.f_82480_, pos.f_82481_).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).spawn(pLevel, pos.f_82479_, pos.f_82480_, pos.f_82481_);
    }

    @Override
    public int getCooldownDuration(Level level, LivingEntity livingEntity) {
        return 80;
    }

    @Override
    public int getProjectileCount(Level level, LivingEntity livingEntity, float pct) {
        return pct == 1.0f ? 3 : 0;
    }

    @Override
    public void fireProjectile(LivingEntity player, ItemStack stack, Level level, InteractionHand hand, float chargePercentage, int count) {
        float pitchOffset = 3.0f + (float)count;
        int spawnDelay = count * 3;
        float velocity = 3.0f + 0.5f * (float)count;
        float magicDamage = (float)player.m_21204_().m_22181_((Attribute)LodestoneAttributeRegistry.MAGIC_DAMAGE.get());
        Vec3 pos = this.getProjectileSpawnPos(player, hand, 0.5f, 0.5f);
        HexBoltEntity entity = new HexBoltEntity(level, pos.f_82479_, pos.f_82480_, pos.f_82481_);
        entity.setData((Entity)player, magicDamage, spawnDelay);
        entity.m_37446_(stack);
        entity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), -pitchOffset, velocity, 0.0f);
        level.m_7967_((Entity)entity);
    }
}

