/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.ether;

import com.sammy.malum.common.item.ether.AbstractEtherItem;
import java.awt.Color;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import team.lodestar.lodestone.registry.common.particle.LodestoneScreenParticleRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.builder.ScreenParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleDataBuilder;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleHolder;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleType;

public class EtherItem
extends AbstractEtherItem {
    public EtherItem(Block blockIn, Item.Properties builder, boolean iridescent) {
        super(blockIn, builder, iridescent);
    }

    public void spawnLateParticles(ScreenParticleHolder target, Level level, float partialTick, ItemStack stack, float x, float y) {
        float time = (float)level.m_46467_() + partialTick;
        AbstractEtherItem etherItem = (AbstractEtherItem)stack.m_41720_();
        Color firstColor = new Color(etherItem.getFirstColor(stack));
        Color secondColor = new Color(etherItem.getSecondColor(stack));
        float alphaMultiplier = etherItem.iridescent ? 0.75f : 0.5f;
        int yOffset = etherItem.iridescent ? 3 : 4;
        int xOffset = etherItem.iridescent ? -1 : 0;
        SpinParticleDataBuilder spinDataBuilder = SpinParticleData.create((float)0.0f, (float)1.0f).setSpinOffset(0.025f * time % 6.28f).setEasing(Easing.EXPO_IN_OUT);
        ScreenParticleBuilder.create((ScreenParticleType)LodestoneScreenParticleRegistry.STAR, (ScreenParticleHolder)target).setTransparencyData(GenericParticleData.create((float)(0.09f * alphaMultiplier), (float)0.0f).setEasing(Easing.QUINTIC_IN).build()).setScaleData(GenericParticleData.create((float)((float)(1.5 + Math.sin(time * 0.1f) * 0.125)), (float)0.0f).build()).setColorData(ColorParticleData.create((Color)firstColor, (Color)secondColor).setCoefficient(1.25f).build()).setLifetime(6).setRandomOffset((double)0.05f).setSpinData(spinDataBuilder.build()).spawnOnStack((double)xOffset, (double)yOffset).setScaleData(GenericParticleData.create((float)((float)((double)1.4f - Math.sin(time * 0.075f) * 0.125)), (float)0.0f).build()).setColorData(ColorParticleData.create((Color)secondColor, (Color)firstColor).build()).setSpinData(spinDataBuilder.setSpinOffset(0.785f - 0.01f * time % 6.28f).build()).spawnOnStack((double)xOffset, (double)yOffset);
    }
}

