/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.ether;

import com.sammy.malum.common.item.ether.AbstractEtherItem;
import java.awt.Color;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import team.lodestar.lodestone.registry.common.particle.LodestoneScreenParticleRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.builder.ScreenParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleDataBuilder;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleHolder;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleType;

public class EtherTorchItem
extends AbstractEtherItem {
    protected final Block wallBlock;

    public EtherTorchItem(Block floorBlock, Block wallBlockIn, Item.Properties builder, boolean iridescent) {
        super(floorBlock, builder, iridescent);
        this.wallBlock = wallBlockIn;
    }

    public void spawnLateParticles(ScreenParticleHolder target, Level level, float partialTick, ItemStack stack, float x, float y) {
        float gameTime = (float)level.m_46467_() + partialTick;
        AbstractEtherItem etherItem = (AbstractEtherItem)stack.m_41720_();
        Color firstColor = new Color(etherItem.getFirstColor(stack));
        Color secondColor = new Color(etherItem.getSecondColor(stack));
        float alphaMultiplier = etherItem.iridescent ? 0.75f : 0.5f;
        SpinParticleDataBuilder spinDataBuilder = SpinParticleData.create((float)0.0f, (float)1.0f).setSpinOffset(0.025f * gameTime % 6.28f).setEasing(Easing.EXPO_IN_OUT);
        ScreenParticleBuilder.create((ScreenParticleType)LodestoneScreenParticleRegistry.STAR, (ScreenParticleHolder)target).setTransparencyData(GenericParticleData.create((float)(0.11f * alphaMultiplier), (float)0.0f).setEasing(Easing.QUINTIC_IN).build()).setScaleData(GenericParticleData.create((float)((float)(0.75 + Math.sin(gameTime * 0.05f) * 0.125)), (float)0.0f).build()).setColorData(ColorParticleData.create((Color)firstColor, (Color)secondColor).setCoefficient(1.25f).build()).setSpinData(spinDataBuilder.build()).setLifetime(7).setRandomOffset((double)0.05f).spawnOnStack(0.0, -2.0).setScaleData(GenericParticleData.create((float)((float)(0.75 - Math.sin(gameTime * 0.075f) * 0.125)), (float)0.0f).build()).setColorData(ColorParticleData.create((Color)secondColor, (Color)firstColor).build()).setSpinData(spinDataBuilder.setSpinOffset(0.785f - 0.01f * gameTime % 6.28f).build()).spawnOnStack(0.0, -2.0);
    }

    @Nullable
    protected BlockState m_5965_(BlockPlaceContext context) {
        BlockState blockstate = this.wallBlock.m_5573_(context);
        BlockState blockstate1 = null;
        Level level = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        for (Direction direction : context.m_6232_()) {
            BlockState blockstate2;
            if (direction == Direction.UP) continue;
            BlockState blockState = blockstate2 = direction == Direction.DOWN ? this.m_40614_().m_5573_(context) : blockstate;
            if (blockstate2 == null || !blockstate2.m_60710_((LevelReader)level, blockpos)) continue;
            blockstate1 = blockstate2;
            break;
        }
        return blockstate1 != null && level.m_45752_(blockstate1, blockpos, CollisionContext.m_82749_()) ? blockstate1 : null;
    }

    public void m_6192_(Map<Block, Item> blockToItemMap, Item itemIn) {
        super.m_6192_(blockToItemMap, itemIn);
        blockToItemMap.put(this.wallBlock, itemIn);
    }

    public void removeFromBlockToItemMap(Map<Block, Item> blockToItemMap, Item itemIn) {
        super.removeFromBlockToItemMap(blockToItemMap, itemIn);
        blockToItemMap.remove(this.wallBlock);
    }
}

