/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.food;

import com.sammy.malum.common.item.food.BottledDrinkItem;
import com.sammy.malum.registry.common.MobEffectRegistry;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.item.ItemRegistry;
import com.sammy.malum.visual_effects.networked.data.PositionEffectData;
import com.sammy.malum.visual_effects.networked.gluttony.AbsorbGluttonyParticleEffect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;
import team.lodestar.lodestone.helpers.CurioHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;

public class ConcentratedGluttonyItem
extends BottledDrinkItem {
    public static final Collection<Supplier<Item>> ROTTEN_TRINKETS = new ArrayList<RegistryObject<Item>>(List.of(ItemRegistry.RING_OF_DESPERATE_VORACITY, ItemRegistry.GLUTTONOUS_BROOCH, ItemRegistry.BELT_OF_THE_STARVED));

    public ConcentratedGluttonyItem(Item.Properties builder) {
        super(builder);
    }

    @Override
    public ItemStack m_5922_(ItemStack pStack, Level pLevel, LivingEntity pEntityLiving) {
        MobEffectInstance gluttonyEffect = ConcentratedGluttonyItem.createGluttonyEffect((Entity)pEntityLiving);
        pEntityLiving.m_7292_(gluttonyEffect);
        SoundHelper.playSound((Entity)pEntityLiving, (SoundEvent)((SoundEvent)SoundRegistry.CONCENTRATED_GLUTTONY_DRINK.get()), (float)1.0f, (float)RandomHelper.randomBetween((RandomSource)pLevel.f_46441_, (float)1.5f, (float)2.0f));
        if (!pLevel.f_46443_) {
            ConcentratedGluttonyItem.createGluttonyVFX(pEntityLiving, gluttonyEffect.f_19504_);
        }
        return super.m_5922_(pStack, pLevel, pEntityLiving);
    }

    public static MobEffectInstance createGluttonyEffect(@Nullable Entity source) {
        return ConcentratedGluttonyItem.createGluttonyEffect(source, 1.0f);
    }

    public static MobEffectInstance createGluttonyEffect(@Nullable Entity source, float durationScalar) {
        int amplifier = 3;
        int duration = 20;
        if (source instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)source;
            if (CurioHelper.hasCurioEquipped((LivingEntity)livingEntity, (Item)((Item)ItemRegistry.RING_OF_GRUESOME_CONCENTRATION.get()))) {
                ++amplifier;
                duration += 40;
            }
            for (Supplier<Item> rottenTrinket : ROTTEN_TRINKETS) {
                if (!CurioHelper.hasCurioEquipped((LivingEntity)livingEntity, (Item)rottenTrinket.get())) continue;
                ++amplifier;
                duration += 10;
            }
        }
        return new MobEffectInstance((MobEffect)MobEffectRegistry.GLUTTONY.get(), (int)((float)(duration * 20) * durationScalar), amplifier);
    }

    public static void createGluttonyVFX(LivingEntity target, int amplifier) {
        ConcentratedGluttonyItem.createGluttonyVFX(target, 1.0f + (float)amplifier * 0.05f);
    }

    public static void createGluttonyVFX(LivingEntity target, float potency) {
        Vec3 position = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0);
        ParticleEffectTypeRegistry.GLUTTONY_ABSORB.createPositionedEffect(target.m_9236_(), new PositionEffectData(position), AbsorbGluttonyParticleEffect.createData(potency));
    }
}

