/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.spirit;

import com.sammy.malum.core.systems.ritual.MalumRitualTier;
import com.sammy.malum.core.systems.ritual.MalumRitualType;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.RitualRegistry;
import com.sammy.malum.visual_effects.ScreenParticleEffects;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import team.lodestar.lodestone.handlers.screenparticle.ParticleEmitterHandler;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.registry.common.particle.LodestoneScreenParticleRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.builder.ScreenParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleHolder;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleType;

public class RitualShardItem
extends Item
implements ParticleEmitterHandler.ItemParticleSupplier {
    public static final String RITUAL_TYPE = "stored_ritual";
    public static final String STORED_SPIRITS = "stored_spirits";

    public RitualShardItem(Item.Properties properties) {
        super(properties);
    }

    public Rarity m_41460_(ItemStack pStack) {
        MalumRitualType ritualType = RitualShardItem.getRitualType(pStack);
        if (ritualType != null) {
            return ritualType.spirit.getItemRarity();
        }
        return super.m_41460_(pStack);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        MalumRitualType ritualType = RitualShardItem.getRitualType(pStack);
        MalumRitualTier ritualTier = RitualShardItem.getRitualTier(pStack);
        if (ritualType != null && ritualTier != null) {
            pTooltip.addAll(ritualType.makeRitualShardDescriptor(ritualTier));
        }
    }

    public void spawnLateParticles(ScreenParticleHolder target, Level level, float partialTick, ItemStack stack, float x, float y) {
        MalumRitualType ritualType = RitualShardItem.getRitualType(stack);
        MalumRitualTier ritualTier = RitualShardItem.getRitualTier(stack);
        if (ritualType != null && ritualTier != null) {
            MalumSpiritType type = ritualType.spirit;
            ScreenParticleEffects.spawnSpiritShardScreenParticles(target, type);
            if (ritualTier.isGreaterThan(MalumRitualTier.DIM)) {
                float distance = 2.0f + (float)ritualTier.potency;
                RandomSource rand = Minecraft.m_91087_().f_91073_.m_213780_();
                for (int i = 0; i < 2; ++i) {
                    float time = ((i == 1 ? 3.14f : 0.0f) + ((float)level.m_46467_() + partialTick) * 0.05f) % 6.28f;
                    float scalar = 0.4f + 0.15f * (float)ritualTier.potency;
                    if (time > 1.57f && time < 4.71f) {
                        scalar *= Easing.QUAD_IN.ease(Math.abs(3.14f - time) / 1.57f, 0.0f, 1.0f, 1.0f);
                    }
                    double xOffset = Math.sin(time) * (double)distance;
                    double yOffset = Math.cos(time) * (double)distance * 0.5;
                    ScreenParticleBuilder.create((ScreenParticleType)LodestoneScreenParticleRegistry.WISP, (ScreenParticleHolder)target).setTransparencyData(GenericParticleData.create((float)0.2f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setSpinData(SpinParticleData.create((float)RandomHelper.randomBetween((RandomSource)rand, (float)0.2f, (float)0.4f)).setEasing(Easing.EXPO_OUT).build()).setScaleData(GenericParticleData.create((float)(RandomHelper.randomBetween((RandomSource)rand, (float)0.2f, (float)0.3f) * scalar), (float)0.0f).setEasing(Easing.EXPO_OUT).build()).setColorData(type.createColorData().build()).setLifetime(RandomHelper.randomBetween((RandomSource)rand, (int)80, (int)120)).setRandomOffset((double)0.1f).spawnOnStack(xOffset, yOffset);
                    if (!ritualTier.isGreaterThan(MalumRitualTier.BRIGHT)) break;
                }
            }
        }
    }

    public static MalumRitualType getRitualType(ItemStack stack) {
        return stack.m_41782_() ? RitualRegistry.get(new ResourceLocation(stack.m_41783_().m_128461_(RITUAL_TYPE))) : null;
    }

    public static MalumRitualTier getRitualTier(ItemStack stack) {
        return stack.m_41782_() ? MalumRitualTier.figureOutTier(stack.m_41783_().m_128451_(STORED_SPIRITS)) : null;
    }
}

