/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.packets.particle.base.color;

import com.sammy.malum.common.packets.particle.base.BlockBasedParticleEffectPacket;
import java.awt.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;

public abstract class ColorBasedBlockParticleEffectPacket
extends BlockBasedParticleEffectPacket {
    protected final Color color;

    public ColorBasedBlockParticleEffectPacket(Color color, BlockPos pos) {
        super(pos);
        this.color = color;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.color.getRed());
        buf.writeInt(this.color.getGreen());
        buf.writeInt(this.color.getBlue());
        super.encode(buf);
    }

    public static <T extends ColorBasedBlockParticleEffectPacket> T decode(PacketProvider<T> provider, FriendlyByteBuf buf) {
        Color color = new Color(buf.readInt(), buf.readInt(), buf.readInt());
        int posX = buf.readInt();
        int posY = buf.readInt();
        int posZ = buf.readInt();
        return provider.getPacket(color, new BlockPos(posX, posY, posZ));
    }

    public static interface PacketProvider<T extends ColorBasedBlockParticleEffectPacket> {
        public T getPacket(Color var1, BlockPos var2);
    }
}

