/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.recipe;

import com.sammy.malum.common.recipe.AbstractMalumRecipe;
import com.sammy.malum.core.systems.recipe.SpiritWithCount;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;

public abstract class AbstractSpiritListMalumRecipe
extends AbstractMalumRecipe {
    public final List<SpiritWithCount> spirits;

    protected AbstractSpiritListMalumRecipe(ResourceLocation id, RecipeSerializer<?> recipeSerializer, RecipeType<?> recipeType, List<SpiritWithCount> spirits) {
        super(id, recipeSerializer, recipeType);
        this.spirits = spirits;
    }

    public List<ItemStack> getSortedSpirits(List<ItemStack> stacks) {
        ArrayList<ItemStack> sortedStacks = new ArrayList<ItemStack>();
        block0: for (SpiritWithCount item : this.spirits) {
            for (ItemStack stack : stacks) {
                if (!item.matches(stack)) continue;
                sortedStacks.add(stack);
                continue block0;
            }
        }
        return sortedStacks;
    }

    public boolean doSpiritsMatch(List<ItemStack> spirits) {
        if (this.spirits.size() == 0) {
            return true;
        }
        if (this.spirits.size() != spirits.size()) {
            return false;
        }
        List<ItemStack> sortedStacks = this.getSortedSpirits(spirits);
        if (sortedStacks.size() < this.spirits.size()) {
            return false;
        }
        for (int i = 0; i < this.spirits.size(); ++i) {
            ItemStack stack;
            SpiritWithCount item = this.spirits.get(i);
            if (item.matches(stack = sortedStacks.get(i))) continue;
            return false;
        }
        return true;
    }
}

