/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.recipe;

import com.google.gson.JsonObject;
import com.sammy.malum.common.recipe.AbstractMalumRecipe;
import com.sammy.malum.registry.common.recipe.RecipeSerializerRegistry;
import com.sammy.malum.registry.common.recipe.RecipeTypeRegistry;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import team.lodestar.lodestone.systems.recipe.IngredientWithCount;

public class RunicWorkbenchRecipe
extends AbstractMalumRecipe {
    public static final String NAME = "runeworking";
    public final IngredientWithCount primaryInput;
    public final IngredientWithCount secondaryInput;
    public final ItemStack output;

    public RunicWorkbenchRecipe(ResourceLocation id, IngredientWithCount primaryInput, IngredientWithCount secondaryInput, ItemStack output) {
        super(id, (RecipeSerializer)RecipeSerializerRegistry.RUNEWORKING_RECIPE_SERIALIZER.get(), (RecipeType)RecipeTypeRegistry.RUNEWORKING.get());
        this.primaryInput = primaryInput;
        this.secondaryInput = secondaryInput;
        this.output = output;
    }

    public boolean doesPrimaryInputMatch(ItemStack input) {
        return this.primaryInput.matches(input);
    }

    public boolean doesSecondaryInputMatch(ItemStack input) {
        return this.secondaryInput.matches(input);
    }

    public boolean doesOutputMatch(ItemStack output) {
        return output.m_41720_().equals(this.output.m_41720_());
    }

    public static RunicWorkbenchRecipe getRecipe(Level level, ItemStack primaryStack, ItemStack secondaryStack) {
        return RunicWorkbenchRecipe.getRecipe(level, c -> c.doesPrimaryInputMatch(primaryStack) && c.doesSecondaryInputMatch(secondaryStack));
    }

    public static RunicWorkbenchRecipe getRecipe(Level level, Predicate<RunicWorkbenchRecipe> predicate) {
        return RunicWorkbenchRecipe.getRecipe(level, (RecipeType)RecipeTypeRegistry.RUNEWORKING.get(), predicate);
    }

    public static List<RunicWorkbenchRecipe> getRecipes(Level level) {
        return RunicWorkbenchRecipe.getRecipes(level, (RecipeType)RecipeTypeRegistry.RUNEWORKING.get());
    }

    public static class Serializer
    implements RecipeSerializer<RunicWorkbenchRecipe> {
        public RunicWorkbenchRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            IngredientWithCount primaryInput = IngredientWithCount.deserialize((JsonObject)json.getAsJsonObject("primaryInput"));
            IngredientWithCount secondaryInput = IngredientWithCount.deserialize((JsonObject)json.getAsJsonObject("secondaryInput"));
            JsonObject outputObject = json.getAsJsonObject("output");
            ItemStack output = CraftingHelper.getItemStack((JsonObject)outputObject, (boolean)true);
            return new RunicWorkbenchRecipe(recipeId, primaryInput, secondaryInput, output);
        }

        @Nullable
        public RunicWorkbenchRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            IngredientWithCount primaryInput = IngredientWithCount.read((FriendlyByteBuf)buffer);
            IngredientWithCount secondaryInput = IngredientWithCount.read((FriendlyByteBuf)buffer);
            ItemStack output = buffer.m_130267_();
            return new RunicWorkbenchRecipe(recipeId, primaryInput, secondaryInput, output);
        }

        public void toNetwork(FriendlyByteBuf buffer, RunicWorkbenchRecipe recipe) {
            recipe.primaryInput.write(buffer);
            recipe.secondaryInput.write(buffer);
            buffer.m_130055_(recipe.output);
        }
    }
}

