/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sammy.malum.common.recipe.AbstractSpiritListMalumRecipe;
import com.sammy.malum.core.systems.recipe.SpiritWithCount;
import com.sammy.malum.registry.common.recipe.RecipeSerializerRegistry;
import com.sammy.malum.registry.common.recipe.RecipeTypeRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import team.lodestar.lodestone.systems.recipe.IngredientWithCount;

public class SpiritRepairRecipe
extends AbstractSpiritListMalumRecipe {
    public static final String NAME = "spirit_repair";
    public final float durabilityPercentage;
    public final List<Item> inputs;
    public final IngredientWithCount repairMaterial;

    public SpiritRepairRecipe(ResourceLocation id, float durabilityPercentage, List<Item> inputs, IngredientWithCount repairMaterial, List<SpiritWithCount> spirits) {
        super(id, (RecipeSerializer)RecipeSerializerRegistry.REPAIR_RECIPE_SERIALIZER.get(), (RecipeType)RecipeTypeRegistry.SPIRIT_REPAIR.get(), spirits);
        this.durabilityPercentage = durabilityPercentage;
        this.repairMaterial = repairMaterial;
        this.inputs = inputs;
    }

    public boolean doesInputMatch(ItemStack input) {
        return this.inputs.stream().anyMatch(i -> i.equals(input.m_41720_()));
    }

    public boolean doesRepairMatch(ItemStack input) {
        return this.repairMaterial.matches(input);
    }

    public static SpiritRepairRecipe getRecipe(Level level, ItemStack stack, ItemStack repairStack, List<ItemStack> spirits) {
        if (stack.isRepairable() && !stack.m_41768_()) {
            return null;
        }
        return SpiritRepairRecipe.getRecipe(level, c -> c.doesInputMatch(stack) && c.doesRepairMatch(repairStack) && c.doSpiritsMatch(spirits));
    }

    public static SpiritRepairRecipe getRecipe(Level level, Predicate<SpiritRepairRecipe> predicate) {
        return SpiritRepairRecipe.getRecipe(level, (RecipeType)RecipeTypeRegistry.SPIRIT_REPAIR.get(), predicate);
    }

    public static List<SpiritRepairRecipe> getRecipes(Level level) {
        return SpiritRepairRecipe.getRecipes(level, (RecipeType)RecipeTypeRegistry.SPIRIT_REPAIR.get());
    }

    public static ItemStack getRepairRecipeOutput(ItemStack input) {
        return input.m_41720_() instanceof IRepairOutputOverride ? new ItemStack((ItemLike)((IRepairOutputOverride)input.m_41720_()).overrideRepairResult(), input.m_41613_(), input.m_41783_()) : input;
    }

    public static interface IRepairOutputOverride {
        default public Item overrideRepairResult() {
            return Items.f_41852_;
        }

        default public boolean ignoreDuringLookup() {
            return false;
        }
    }

    public static class Serializer
    implements RecipeSerializer<SpiritRepairRecipe> {
        public static List<Item> REPAIRABLE;

        public SpiritRepairRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            if (REPAIRABLE == null) {
                REPAIRABLE = ForgeRegistries.ITEMS.getEntries().stream().map(Map.Entry::getValue).filter(Item::m_41465_).collect(Collectors.toList());
            }
            float durabilityPercentage = json.getAsJsonPrimitive("durabilityPercentage").getAsFloat();
            String itemIdRegex = json.get("itemIdRegex").getAsString();
            String modIdRegex = json.get("modIdRegex").getAsString();
            JsonArray inputsArray = json.getAsJsonArray("inputs");
            ArrayList<Item> inputs = new ArrayList<Item>();
            for (JsonElement jsonElement : inputsArray) {
                Item input = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(jsonElement.getAsString()));
                if (input == null) continue;
                inputs.add(input);
            }
            for (Item item : REPAIRABLE) {
                IRepairOutputOverride repairOutputOverride;
                if (!ForgeRegistries.ITEMS.getKey((Object)item).m_135815_().matches(itemIdRegex) || !modIdRegex.equals("") && !ForgeRegistries.ITEMS.getKey((Object)item).m_135827_().matches(modIdRegex) || item instanceof IRepairOutputOverride && (repairOutputOverride = (IRepairOutputOverride)item).ignoreDuringLookup() || inputs.contains(item)) continue;
                inputs.add(item);
            }
            if (inputs.isEmpty()) {
                return null;
            }
            JsonObject repairObject = json.getAsJsonObject("repairMaterial");
            IngredientWithCount repair = IngredientWithCount.deserialize((JsonObject)repairObject);
            JsonArray spiritsArray = json.getAsJsonArray("spirits");
            ArrayList<SpiritWithCount> spirits = new ArrayList<SpiritWithCount>();
            for (int i = 0; i < spiritsArray.size(); ++i) {
                JsonObject spiritObject = spiritsArray.get(i).getAsJsonObject();
                spirits.add(SpiritWithCount.deserialize(spiritObject));
            }
            return new SpiritRepairRecipe(recipeId, durabilityPercentage, inputs, repair, spirits);
        }

        @Nullable
        public SpiritRepairRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            float durabilityPercentage = buffer.readFloat();
            int inputCount = buffer.readInt();
            ArrayList<Item> inputs = new ArrayList<Item>();
            for (int i = 0; i < inputCount; ++i) {
                inputs.add(buffer.m_130267_().m_41720_());
            }
            IngredientWithCount repair = IngredientWithCount.read((FriendlyByteBuf)buffer);
            int spiritCount = buffer.readInt();
            ArrayList<SpiritWithCount> spirits = new ArrayList<SpiritWithCount>();
            for (int i = 0; i < spiritCount; ++i) {
                spirits.add(new SpiritWithCount(buffer.m_130267_()));
            }
            return new SpiritRepairRecipe(recipeId, durabilityPercentage, inputs, repair, spirits);
        }

        public void toNetwork(FriendlyByteBuf buffer, SpiritRepairRecipe recipe) {
            buffer.writeFloat(recipe.durabilityPercentage);
            buffer.writeInt(recipe.inputs.size());
            for (Item item : recipe.inputs) {
                buffer.m_130055_(item.m_7968_());
            }
            recipe.repairMaterial.write(buffer);
            buffer.writeInt(recipe.spirits.size());
            for (SpiritWithCount spiritWithCount : recipe.spirits) {
                buffer.m_130055_(spiritWithCount.getStack());
            }
        }
    }
}

