/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.recipe.vanilla;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sammy.malum.common.recipe.vanilla.INodeSmeltingRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import team.lodestar.lodestone.systems.recipe.IngredientWithCount;

public class NodeCookingSerializer<T extends AbstractCookingRecipe>
implements RecipeSerializer<T> {
    public final int defaultCookingTime;
    public final NodeBaker<T> factory;

    public NodeCookingSerializer(NodeBaker<T> pFactory, int pDefaultCookingTime) {
        this.defaultCookingTime = pDefaultCookingTime;
        this.factory = pFactory;
    }

    public T fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
        String s = GsonHelper.m_13851_((JsonObject)pJson, (String)"group", (String)"");
        JsonArray jsonelement = GsonHelper.m_13885_((JsonObject)pJson, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)pJson, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)pJson, (String)"ingredient");
        Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonelement);
        IngredientWithCount result = IngredientWithCount.deserialize((JsonObject)pJson.getAsJsonObject("result"));
        float f = GsonHelper.m_13820_((JsonObject)pJson, (String)"experience", (float)0.0f);
        int i = GsonHelper.m_13824_((JsonObject)pJson, (String)"cookingtime", (int)this.defaultCookingTime);
        return this.factory.create(pRecipeId, s, ingredient, result, f, i);
    }

    public T fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
        String s = pBuffer.m_130277_();
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
        IngredientWithCount result = IngredientWithCount.read((FriendlyByteBuf)pBuffer);
        float f = pBuffer.readFloat();
        int i = pBuffer.readInt();
        return this.factory.create(pRecipeId, s, ingredient, result, f, i);
    }

    public void toNetwork(FriendlyByteBuf pBuffer, T pRecipe) {
        pBuffer.m_130070_(pRecipe.m_6076_());
        ((Ingredient)pRecipe.m_7527_().get(0)).m_43923_(pBuffer);
        ((INodeSmeltingRecipe)pRecipe).getOutput().write(pBuffer);
        pBuffer.writeFloat(pRecipe.m_43750_());
        pBuffer.writeInt(pRecipe.m_43753_());
    }

    public static interface NodeBaker<T extends AbstractCookingRecipe> {
        public T create(ResourceLocation var1, String var2, Ingredient var3, IngredientWithCount var4, float var5, int var6);
    }
}

