/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite.eldritch;

import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.common.packets.particle.curiosities.rite.SacredMistRiteEffectPacket;
import com.sammy.malum.common.packets.particle.curiosities.rite.generic.MajorEntityEffectParticlePacket;
import com.sammy.malum.common.spiritrite.TotemicRiteEffect;
import com.sammy.malum.common.spiritrite.TotemicRiteType;
import com.sammy.malum.registry.common.PacketRegistry;
import com.sammy.malum.registry.common.SpiritTypeRegistry;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;

public class EldritchSacredRiteType
extends TotemicRiteType {
    public EldritchSacredRiteType() {
        super("greater_sacred_rite", SpiritTypeRegistry.ELDRITCH_SPIRIT, SpiritTypeRegistry.ARCANE_SPIRIT, SpiritTypeRegistry.SACRED_SPIRIT, SpiritTypeRegistry.SACRED_SPIRIT);
    }

    @Override
    public TotemicRiteEffect getNaturalRiteEffect() {
        return new TotemicRiteEffect(TotemicRiteEffect.MalumRiteEffectCategory.RADIAL_BLOCK_EFFECT){

            @Override
            public int getRiteEffectHorizontalRadius() {
                return 4;
            }

            @Override
            public int getRiteEffectVerticalRadius() {
                return 2;
            }

            @Override
            public void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                BlockPos pos = totemBase.m_58899_();
                this.getNearbyBlocks(totemBase, BonemealableBlock.class).forEach(p -> {
                    if (level.f_46441_.m_188501_() <= 0.06f) {
                        BonemealableBlock bonemealableBlock;
                        BlockState state = level.m_8055_(p);
                        Block block = state.m_60734_();
                        if (block instanceof CropBlock) {
                            for (int i = 0; i < 5 + level.f_46441_.m_188503_(3); ++i) {
                                state.m_222972_(level, p, level.f_46441_);
                            }
                        } else if (block instanceof BonemealableBlock && (bonemealableBlock = (BonemealableBlock)block).m_7370_((LevelReader)level, p, state, false) && bonemealableBlock.m_214167_((Level)level, level.f_46441_, p, state)) {
                            bonemealableBlock.m_214148_(level, level.f_46441_, p, state);
                        }
                        BlockPos particlePos = state.m_60815_() ? p : p.m_7495_();
                        PacketRegistry.MALUM_CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(pos)), (Object)new SacredMistRiteEffectPacket(List.of(SpiritTypeRegistry.SACRED_SPIRIT.identifier), particlePos));
                    }
                });
            }
        };
    }

    @Override
    public TotemicRiteEffect getCorruptedEffect() {
        return new TotemicRiteEffect(TotemicRiteEffect.MalumRiteEffectCategory.LIVING_ENTITY_EFFECT){

            @Override
            public void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                Map<Class, List<Animal>> animalMap = this.getNearbyEntities(totemBase, Animal.class).collect(Collectors.groupingBy(Object::getClass));
                for (List<Animal> animals : animalMap.values()) {
                    if (animals.size() > 20) continue;
                    animals.forEach(e -> {
                        if (e.m_5957_() && e.m_146764_() == 0 && level.f_46441_.m_188501_() <= 0.2f) {
                            e.m_27601_(600);
                            PacketRegistry.MALUM_CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> e), (Object)new MajorEntityEffectParticlePacket(SpiritTypeRegistry.SACRED_SPIRIT.getPrimaryColor(), e.m_20185_(), e.m_20186_() + (double)(e.m_20206_() / 2.0f), e.m_20189_()));
                        }
                    });
                }
            }
        };
    }
}

