/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite.eldritch;

import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.common.packets.particle.curiosities.rite.generic.MajorEntityEffectParticlePacket;
import com.sammy.malum.common.spiritrite.TotemicRiteEffect;
import com.sammy.malum.common.spiritrite.TotemicRiteType;
import com.sammy.malum.registry.common.DamageTypeRegistry;
import com.sammy.malum.registry.common.PacketRegistry;
import com.sammy.malum.registry.common.SpiritTypeRegistry;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import team.lodestar.lodestone.helpers.DamageTypeHelper;

public class EldritchWickedRiteType
extends TotemicRiteType {
    public EldritchWickedRiteType() {
        super("greater_wicked_rite", SpiritTypeRegistry.ELDRITCH_SPIRIT, SpiritTypeRegistry.ARCANE_SPIRIT, SpiritTypeRegistry.WICKED_SPIRIT, SpiritTypeRegistry.WICKED_SPIRIT);
    }

    @Override
    public TotemicRiteEffect getNaturalRiteEffect() {
        return new TotemicRiteEffect(TotemicRiteEffect.MalumRiteEffectCategory.LIVING_ENTITY_EFFECT){

            @Override
            public void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                this.getNearbyEntities(totemBase, LivingEntity.class, e -> !(e instanceof Player)).forEach(e -> {
                    if (e.m_21223_() <= 2.5f && !e.m_6673_(DamageTypeHelper.create((Level)e.m_9236_(), DamageTypeRegistry.VOODOO_PLAYERLESS))) {
                        PacketRegistry.MALUM_CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> e), (Object)new MajorEntityEffectParticlePacket(EldritchWickedRiteType.this.getIdentifyingSpirit().getPrimaryColor(), e.m_20185_(), e.m_20186_() + (double)(e.m_20206_() / 2.0f), e.m_20189_()));
                        e.m_6469_(DamageTypeHelper.create((Level)e.m_9236_(), DamageTypeRegistry.VOODOO_PLAYERLESS), 10.0f);
                    }
                });
            }
        };
    }

    @Override
    public TotemicRiteEffect getCorruptedEffect() {
        return new TotemicRiteEffect(TotemicRiteEffect.MalumRiteEffectCategory.LIVING_ENTITY_EFFECT){

            @Override
            public void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                Map<Class, List<Animal>> animalMap = this.getNearbyEntities(totemBase, Animal.class, e -> e.m_146764_() > 0 && !e.m_6673_(DamageTypeHelper.create((Level)e.m_9236_(), DamageTypeRegistry.VOODOO_PLAYERLESS))).collect(Collectors.groupingBy(Object::getClass));
                for (List<Animal> animals : animalMap.values()) {
                    if (animals.size() < 20) {
                        return;
                    }
                    int maxKills = animals.size() - 20;
                    animals.removeIf(Animal::m_27593_);
                    for (Animal entity : animals) {
                        entity.m_6469_(DamageTypeHelper.create((Level)entity.m_9236_(), DamageTypeRegistry.VOODOO_PLAYERLESS), entity.m_21233_());
                        PacketRegistry.MALUM_CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new MajorEntityEffectParticlePacket(SpiritTypeRegistry.WICKED_SPIRIT.getPrimaryColor(), entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_()));
                        if (maxKills-- > 0) continue;
                        return;
                    }
                }
            }
        };
    }
}

