/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.worldevent;

import com.sammy.malum.common.block.blight.BlightedSoilBlock;
import com.sammy.malum.common.worldgen.tree.SoulwoodTreeFeature;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.WorldEventTypes;
import com.sammy.malum.visual_effects.networked.data.PositionEffectData;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;
import team.lodestar.lodestone.systems.worldgen.LodestoneBlockFiller;

public class ActiveBlightEvent
extends WorldEventInstance {
    public int blightTimer;
    public int intensity;
    public int rate;
    public int times;
    public BlockPos sourcePos;
    public Map<Integer, Double> noiseValues;

    public ActiveBlightEvent() {
        super(WorldEventTypes.ACTIVE_BLIGHT);
    }

    public ActiveBlightEvent setBlightData(int intensity, int rate, int times) {
        this.intensity = intensity;
        this.rate = rate;
        this.times = times;
        return this;
    }

    public ActiveBlightEvent setPosition(BlockPos sourcePos) {
        this.sourcePos = sourcePos;
        return this;
    }

    public void tick(Level level) {
        if (this.times == 0) {
            this.end(level);
            return;
        }
        if (this.blightTimer == 0) {
            this.blightTimer = this.rate;
            --this.times;
            this.createBlight((ServerLevel)level);
            this.intensity += 2;
        } else {
            --this.blightTimer;
        }
    }

    public void createBlight(ServerLevel level) {
        LodestoneBlockFiller filler = new LodestoneBlockFiller(new LodestoneBlockFiller.LodestoneBlockFillerLayer[]{new LodestoneBlockFiller.LodestoneBlockFillerLayer(SoulwoodTreeFeature.BLIGHT)});
        if (this.noiseValues == null) {
            this.noiseValues = SoulwoodTreeFeature.generateBlight((ServerLevelAccessor)level, filler, this.sourcePos, this.intensity);
        } else {
            SoulwoodTreeFeature.generateBlight((ServerLevelAccessor)level, filler, this.noiseValues, this.sourcePos, this.intensity);
        }
        ActiveBlightEvent.createBlightVFX(level, filler);
        level.m_5594_(null, this.sourcePos, (SoundEvent)SoundRegistry.MAJOR_BLIGHT_MOTIF.get(), SoundSource.BLOCKS, 1.0f, 1.8f);
    }

    public static void createBlightVFX(ServerLevel level, LodestoneBlockFiller filler) {
        filler.getLayer(SoulwoodTreeFeature.BLIGHT).entrySet().stream().filter(e -> ((LodestoneBlockFiller.BlockStateEntry)e.getValue()).getState().m_60734_() instanceof BlightedSoilBlock).map(Map.Entry::getKey).forEach(p -> ParticleEffectTypeRegistry.BLIGHTING_MIST.createPositionedEffect((Level)level, new PositionEffectData((BlockPos)p)));
    }
}

