/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.worldgen.tree;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.sammy.malum.common.block.blight.ClingingBlightBlock;
import com.sammy.malum.common.block.nature.MalumLeavesBlock;
import com.sammy.malum.common.worldgen.WorldgenHelper;
import com.sammy.malum.common.worldgen.tree.RunewoodTreeFeature;
import com.sammy.malum.registry.common.block.BlockRegistry;
import com.sammy.malum.registry.common.block.BlockTagRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.BlockHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.worldgen.LodestoneBlockFiller;

public class SoulwoodTreeFeature
extends Feature<NoneFeatureConfiguration> {
    public static final LodestoneBlockFiller.LodestoneLayerToken LOGS = new LodestoneBlockFiller.LodestoneLayerToken();
    public static final LodestoneBlockFiller.LodestoneLayerToken LEAVES = new LodestoneBlockFiller.LodestoneLayerToken();
    public static final LodestoneBlockFiller.LodestoneLayerToken HANGING_LEAVES = new LodestoneBlockFiller.LodestoneLayerToken();
    public static final LodestoneBlockFiller.LodestoneLayerToken BLIGHT = new LodestoneBlockFiller.LodestoneLayerToken();
    private static final PerlinSimplexNoise BLIGHT_NOISE = new PerlinSimplexNoise((RandomSource)new WorldgenRandom((RandomSource)new LegacyRandomSource(1234L)), (List)ImmutableList.of((Object)0));

    public SoulwoodTreeFeature() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    private static BlockState makeClingingBlight(ClingingBlightBlock.BlightType blightType, Direction direction) {
        return (BlockState)((BlockState)((Block)BlockRegistry.CLINGING_BLIGHT.get()).m_49966_().m_61124_(ClingingBlightBlock.BLIGHT_TYPE, (Comparable)((Object)blightType))).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)direction);
    }

    private int getSapBlockCount(RandomSource random) {
        return Mth.m_216271_((RandomSource)random, (int)5, (int)7);
    }

    private int getTrunkHeight(RandomSource random) {
        return Mth.m_216271_((RandomSource)random, (int)10, (int)15);
    }

    private int getTwistCooldown(RandomSource random) {
        return Mth.m_216271_((RandomSource)random, (int)3, (int)5);
    }

    private int getTrunkTwistAmount(RandomSource random) {
        return Mth.m_216271_((RandomSource)random, (int)2, (int)6);
    }

    private int getSideTrunkHeight(RandomSource random) {
        return Mth.m_216271_((RandomSource)random, (int)1, (int)3);
    }

    private int getDownwardsBranchOffset(RandomSource random) {
        return Mth.m_216271_((RandomSource)random, (int)2, (int)4);
    }

    private int getBranchLength(RandomSource random) {
        return Mth.m_216271_((RandomSource)random, (int)3, (int)5);
    }

    private int getBranchTwistAmount(RandomSource random) {
        return Mth.m_216271_((RandomSource)random, (int)0, (int)2);
    }

    private int getBranchHeight(RandomSource random) {
        return Mth.m_216271_((RandomSource)random, (int)5, (int)6);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        int i;
        Object direction;
        BlockPos pos;
        WorldGenLevel level = context.m_159774_();
        if (level.m_46859_((pos = context.m_159777_()).m_7495_()) || !((Block)BlockRegistry.SOULWOOD_GROWTH.get()).m_49966_().m_60710_((LevelReader)level, pos)) {
            return false;
        }
        RandomSource rand = context.m_225041_();
        ArrayList<Pair> validSoulwoodSpikePositions = new ArrayList<Pair>();
        BlockState logState = ((Block)BlockRegistry.SOULWOOD_LOG.get()).m_49966_();
        BlockState blightedLogState = ((Block)BlockRegistry.BLIGHTED_SOULWOOD.get()).m_49966_();
        LodestoneBlockFiller filler = new LodestoneBlockFiller().addLayers(new LodestoneBlockFiller.LodestoneLayerToken[]{LOGS, LEAVES, HANGING_LEAVES, BLIGHT});
        int sapBlockCount = this.getSapBlockCount(rand);
        int trunkHeight = this.getTrunkHeight(rand);
        int twistCooldown = this.getTwistCooldown(rand);
        int twistDirectionIndex = rand.m_188503_(WorldgenHelper.DIRECTIONS.length);
        int remainingTwists = this.getTrunkTwistAmount(rand);
        int twistCutoffPoint = trunkHeight - 5;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        for (int i2 = 0; i2 <= trunkHeight; ++i2) {
            int j;
            if (i2 < twistCutoffPoint) {
                for (j = 0; j < 4; ++j) {
                    direction = Direction.m_122407_((int)j);
                    validSoulwoodSpikePositions.add(Pair.of((Object)direction.m_122424_(), (Object)mutable.m_121945_((Direction)direction)));
                }
                if (twistCooldown == 0 && remainingTwists != 0) {
                    Direction twistDirection = Direction.m_122407_((int)(twistDirectionIndex % 4));
                    if (rand.m_188501_() < 0.75f) {
                        ++twistDirectionIndex;
                    }
                    if (!RunewoodTreeFeature.canPlace(level, (BlockPos)mutable)) {
                        return false;
                    }
                    filler.getLayer(LOGS).put(mutable.m_7949_(), LodestoneBlockFiller.create((BlockState)logState));
                    filler.getLayer(BLIGHT).put(mutable.m_7494_(), LodestoneBlockFiller.create((BlockState)SoulwoodTreeFeature.makeClingingBlight(ClingingBlightBlock.BlightType.ROOTED_BLIGHT, twistDirection)));
                    mutable.m_122173_(twistDirection);
                    twistCooldown = this.getTwistCooldown(rand);
                    --remainingTwists;
                }
            }
            if (!RunewoodTreeFeature.canPlace(level, (BlockPos)mutable)) {
                return false;
            }
            for (j = 0; j < 4; ++j) {
                direction = Direction.m_122407_((int)j);
                validSoulwoodSpikePositions.add(Pair.of((Object)direction.m_122424_(), (Object)mutable.m_121945_((Direction)direction)));
            }
            filler.getLayer(LOGS).put(mutable.m_7949_(), LodestoneBlockFiller.create((BlockState)(i2 == 0 ? blightedLogState : logState)));
            mutable.m_122173_(Direction.UP);
            --twistCooldown;
        }
        BlockPos trunkTop = mutable.m_7949_();
        for (i = 0; i < 4; ++i) {
            direction = Direction.m_122407_((int)i);
            int sideTrunkHeight = this.getSideTrunkHeight(rand);
            mutable.m_122190_((Vec3i)pos).m_122173_((Direction)direction);
            BlockPos trunkBottom = this.addDownwardsTrunkConnections(logState, level, filler, (BlockPos)mutable);
            for (int j = 0; j < sideTrunkHeight; ++j) {
                if (!RunewoodTreeFeature.canPlace(level, (BlockPos)mutable)) {
                    return false;
                }
                filler.getLayer(LOGS).put(mutable.m_7949_(), LodestoneBlockFiller.create((BlockState)logState));
                mutable.m_122173_(Direction.UP);
            }
            filler.getLayer(LOGS).put(trunkBottom, LodestoneBlockFiller.create((BlockState)blightedLogState));
            filler.getLayer(BLIGHT).put(trunkBottom.m_121945_((Direction)direction), LodestoneBlockFiller.create((BlockState)SoulwoodTreeFeature.makeClingingBlight(ClingingBlightBlock.BlightType.ROOTED_BLIGHT, direction.m_122424_())));
        }
        for (i = 0; i < 4; ++i) {
            int j;
            direction = Direction.m_122407_((int)i);
            int downwardsBranchOffset = this.getDownwardsBranchOffset(rand);
            int branchLength = this.getBranchLength(rand);
            int branchHeight = this.getBranchHeight(rand);
            remainingTwists = this.getBranchTwistAmount(rand);
            twistCooldown = 1;
            mutable.m_122190_((Vec3i)trunkTop);
            mutable.m_122175_(Direction.DOWN, downwardsBranchOffset);
            for (j = 1; j < branchLength; ++j) {
                mutable.m_122173_((Direction)direction);
                if (!RunewoodTreeFeature.canPlace(level, (BlockPos)mutable)) {
                    return false;
                }
                Direction.Axis axis = direction.m_122434_();
                if (twistCooldown <= 0) {
                    filler.getLayer(LOGS).put(mutable.m_7949_(), LodestoneBlockFiller.create((BlockState)((BlockState)logState.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)axis))));
                    mutable.m_122173_(Direction.UP);
                    twistCooldown = this.getTwistCooldown(rand);
                    --remainingTwists;
                }
                boolean start = j == 1;
                Direction opposite = direction.m_122424_();
                filler.getLayer(LOGS).put(mutable.m_7949_(), LodestoneBlockFiller.create((BlockState)((BlockState)logState.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)axis))));
                filler.getLayer(BLIGHT).put(mutable.m_7495_(), LodestoneBlockFiller.create((BlockState)SoulwoodTreeFeature.makeClingingBlight(start ? ClingingBlightBlock.BlightType.HANGING_BLIGHT : ClingingBlightBlock.BlightType.HANGING_ROOTS, opposite)));
                if (start) {
                    filler.getLayer(BLIGHT).put(mutable.m_6625_(2), LodestoneBlockFiller.create((BlockState)SoulwoodTreeFeature.makeClingingBlight(ClingingBlightBlock.BlightType.HANGING_BLIGHT_CONNECTION, opposite)));
                }
                if (remainingTwists <= 0) continue;
                --twistCooldown;
            }
            for (j = 0; j < branchHeight; ++j) {
                if (!RunewoodTreeFeature.canPlace(level, (BlockPos)mutable)) {
                    return false;
                }
                filler.getLayer(LOGS).put(mutable.m_7949_(), LodestoneBlockFiller.create((BlockState)logState));
                mutable.m_122173_(Direction.UP);
            }
            SoulwoodTreeFeature.makeLeafBlob(filler, rand, (BlockPos)mutable.m_122175_(Direction.DOWN, branchHeight - 1));
        }
        SoulwoodTreeFeature.makeLeafBlob(filler, rand, (BlockPos)mutable.m_122190_((Vec3i)trunkTop));
        SoulwoodTreeFeature.generateBlight((ServerLevelAccessor)level, filler, pos.m_7495_(), 8);
        ArrayList sapBlockPositions = new ArrayList(filler.getLayer(LOGS).keySet());
        Collections.shuffle(sapBlockPositions);
        for (BlockPos blockPos : sapBlockPositions.subList(0, sapBlockCount)) {
            LodestoneBlockFiller.BlockStateEntry entry = (LodestoneBlockFiller.BlockStateEntry)filler.getLayer(LOGS).get((Object)blockPos);
            if (entry.getState().m_60734_().equals(BlockRegistry.BLIGHTED_SOULWOOD.get())) continue;
            filler.getLayer(LOGS).replace(blockPos, e -> LodestoneBlockFiller.create((BlockState)BlockHelper.getBlockStateWithExistingProperties((BlockState)e.getState(), (BlockState)((Block)BlockRegistry.EXPOSED_SOULWOOD_LOG.get()).m_49966_())).build());
        }
        int spikeCount = 6;
        Collections.shuffle(validSoulwoodSpikePositions);
        for (Pair entry : validSoulwoodSpikePositions) {
            BlockPos entryPos = (BlockPos)entry.getSecond();
            if (filler.getLayer(BLIGHT).containsKey((Object)entryPos)) continue;
            filler.getLayer(BLIGHT).put(entryPos, LodestoneBlockFiller.create((BlockState)SoulwoodTreeFeature.makeClingingBlight(ClingingBlightBlock.BlightType.SOULWOOD_SPIKE, (Direction)entry.getFirst())));
            if (spikeCount == 0) break;
            --spikeCount;
        }
        filler.fill((LevelAccessor)level);
        WorldgenHelper.updateLeaves((LevelAccessor)level, filler.getLayer(LOGS).keySet());
        return true;
    }

    public BlockPos addDownwardsTrunkConnections(BlockState logState, WorldGenLevel level, LodestoneBlockFiller filler, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        while (true) {
            mutable.m_122173_(Direction.DOWN);
            if (!RunewoodTreeFeature.canPlace(level, (BlockPos)mutable)) {
                return mutable.m_7494_();
            }
            filler.getLayer(LOGS).put(mutable.m_7949_(), LodestoneBlockFiller.create((BlockState)logState));
        }
    }

    public static void makeLeafBlob(LodestoneBlockFiller filler, RandomSource rand, BlockPos pos) {
        int color;
        int size;
        int i;
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        int[] leafSizes = new int[]{1, 2, 3, 3, 3, 2, 1};
        int[] leafColors = new int[]{4, 3, 2, 1, 2, 3, 4};
        for (i = 0; i < 7; ++i) {
            size = leafSizes[i];
            color = leafColors[i];
            SoulwoodTreeFeature.makeLeafSlice(filler, rand, mutable, size, color, false);
            mutable.m_122173_(Direction.UP);
        }
        mutable.m_122175_(Direction.DOWN, 7);
        for (i = 0; i < 3; ++i) {
            size = leafSizes[i];
            color = leafColors[i];
            SoulwoodTreeFeature.makeLeafSlice(filler, rand, mutable, size, color, true);
            mutable.m_122173_(Direction.UP);
        }
    }

    public static void makeLeafSlice(LodestoneBlockFiller filler, RandomSource rand, BlockPos.MutableBlockPos pos, int leavesSize, int leavesColor, boolean makeHangingLeaves) {
        for (int x = -leavesSize; x <= leavesSize; ++x) {
            int offsetColor = leavesColor + Mth.m_216271_((RandomSource)rand, (int)(leavesColor == 0 ? 0 : -1), (int)(leavesColor == 4 ? 0 : 1));
            for (int z = -leavesSize; z <= leavesSize; ++z) {
                if (Math.abs(x) == leavesSize && Math.abs(z) == leavesSize) continue;
                BlockPos leavesPos = pos.m_7918_(x, 0, z);
                if (makeHangingLeaves && (x != 0 || z != 0)) {
                    if (!(rand.m_188501_() < 0.4f + (float)leavesSize * 0.2f)) continue;
                    int length = leavesSize - 2 + RandomHelper.randomBetween((RandomSource)rand, (int)0, (int)leavesSize);
                    if (length < 2) {
                        length -= 2;
                    }
                    if (length < 2) continue;
                    int spawnHeight = rand.m_188503_(2);
                    BlockPos.MutableBlockPos hangingLeavesPos = leavesPos.m_122032_().m_122175_(Direction.UP, spawnHeight);
                    for (int i = -spawnHeight; i <= length; ++i) {
                        int gradient = Mth.m_14045_((int)(leavesColor + 1 + i), (int)0, (int)4);
                        BlockPos vinePos = hangingLeavesPos.m_122173_(Direction.DOWN).m_7949_();
                        boolean hanging = i == length;
                        Block block = (Block)(hanging ? BlockRegistry.HANGING_SOULWOOD_LEAVES : BlockRegistry.BUDDING_SOULWOOD_LEAVES).get();
                        LodestoneBlockFiller.BlockStateEntryBuilder entry = LodestoneBlockFiller.create((BlockState)((BlockState)block.m_49966_().m_61124_((Property)MalumLeavesBlock.COLOR, (Comparable)Integer.valueOf(gradient))));
                        if (hanging) {
                            entry.setDiscardPredicate((l, p, s) -> !filler.getLayer(LEAVES).containsKey((Object)p.m_7494_()) || filler.getLayer(LOGS).containsKey((Object)p.m_7494_()));
                        }
                        filler.getLayer(hanging ? HANGING_LEAVES : LEAVES).put((Object)vinePos, (Object)entry.build());
                    }
                    continue;
                }
                filler.getLayer(LEAVES).put(leavesPos, LodestoneBlockFiller.create((BlockState)((BlockState)((Block)BlockRegistry.SOULWOOD_LEAVES.get()).m_49966_().m_61124_((Property)MalumLeavesBlock.COLOR, (Comparable)Integer.valueOf(offsetColor)))));
            }
        }
    }

    public static Map<Integer, Double> generateBlight(ServerLevelAccessor level, LodestoneBlockFiller filler, BlockPos pos, int radius) {
        HashMap<Integer, Double> noiseValues = new HashMap<Integer, Double>();
        for (int i = 0; i <= 360; ++i) {
            noiseValues.put(i, BLIGHT_NOISE.m_75449_((double)((float)(pos.m_123341_() + pos.m_123343_()) + (float)i * 0.02f), (double)((float)pos.m_123342_() / 0.05f), true) * 2.5);
        }
        SoulwoodTreeFeature.generateBlight(level, filler, noiseValues, pos, radius);
        return noiseValues;
    }

    public static void generateBlight(ServerLevelAccessor level, LodestoneBlockFiller filler, Map<Integer, Double> noiseValues, BlockPos pos, int radius) {
        SoulwoodTreeFeature.generateBlight(level, filler, pos, radius * 2, radius, noiseValues);
        filler.fill((LevelAccessor)level);
    }

    public static void generateBlight(ServerLevelAccessor level, LodestoneBlockFiller filler, BlockPos center, int coverage, int radius, Map<Integer, Double> noiseValues) {
        int x = center.m_123341_();
        int z = center.m_123343_();
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        int saplingsPlaced = 0;
        Vec3 lastSaplingPos = null;
        for (int i = 0; i < coverage * 2 + 1; ++i) {
            for (int j = 0; j < coverage * 2 + 1; ++j) {
                RandomSource random;
                BlockState plantState;
                int floor;
                int xp = x + i - coverage;
                int zp = z + j - coverage;
                blockPos.m_122178_(xp, center.m_123342_(), zp);
                double theta = 180.0 + 57.29577951308232 * Math.atan2(x - xp, z - zp);
                double naturalNoiseValue = noiseValues.get(Mth.m_14107_((double)theta));
                if (naturalNoiseValue > 1.0) {
                    naturalNoiseValue *= naturalNoiseValue;
                }
                if (!((double)(floor = (int)Math.floor(SoulwoodTreeFeature.pointDistancePlane(xp, zp, x, z))) <= (double)radius + Math.floor(naturalNoiseValue) - 1.0)) continue;
                int verticalRange = 4;
                for (int i1 = 0; level.m_7433_((BlockPos)blockPos, s -> !s.m_60795_()) && i1 < verticalRange; ++i1) {
                    blockPos.m_122173_(Direction.UP);
                }
                for (int k = 0; level.m_7433_((BlockPos)blockPos, BlockBehaviour.BlockStateBase::m_60795_) && k < verticalRange; ++k) {
                    blockPos.m_122173_(Direction.DOWN);
                }
                while (!(plantState = level.m_8055_((BlockPos)blockPos)).m_60795_() && !plantState.m_204336_(BlockTagRegistry.BLIGHTED_PLANTS) && (plantState.m_247087_() || plantState.m_204336_(BlockTags.f_278394_) || plantState.m_204336_(BlockTags.f_13041_))) {
                    BlockPos immutable = blockPos.m_7949_();
                    if (!filler.getLayer(BLIGHT).containsKey((Object)blockPos)) {
                        filler.getLayer(BLIGHT).put(immutable, LodestoneBlockFiller.create((BlockState)Blocks.f_50016_.m_49966_()).setForcePlace());
                    }
                    blockPos.m_122173_(Direction.DOWN);
                }
                if (!level.m_8055_((BlockPos)blockPos).m_204336_(BlockTags.f_144276_)) continue;
                filler.getLayer(BLIGHT).put(blockPos.m_7949_(), LodestoneBlockFiller.create((BlockState)((Block)BlockRegistry.BLIGHTED_SOIL.get()).m_49966_()).setForcePlace());
                if (level.m_8055_((BlockPos)blockPos.m_122184_(0, -1, 0)).m_204336_(BlockTags.f_144274_)) {
                    filler.getLayer(BLIGHT).put(blockPos.m_7949_(), LodestoneBlockFiller.create((BlockState)((Block)BlockRegistry.BLIGHTED_EARTH.get()).m_49966_()).setForcePlace());
                }
                if (!((random = level.m_213780_()).m_188501_() < 0.75f)) continue;
                BlockPos plantPos = blockPos.m_7918_(0, 2, 0);
                BlockState blockState = level.m_8055_(plantPos);
                if (naturalNoiseValue > 2.5 && (lastSaplingPos == null || lastSaplingPos.m_82531_((double)plantPos.m_123341_(), (double)plantPos.m_123342_(), (double)plantPos.m_123343_()) > 5.0) && BlockHelper.fromBlockPos((BlockPos)center).m_82531_((double)plantPos.m_123341_(), (double)plantPos.m_123342_(), (double)plantPos.m_123343_()) > 4.0 && (double)random.m_188501_() < 0.5 / Math.pow(saplingsPlaced + 1, 2.0)) {
                    filler.getLayer(BLIGHT).put(plantPos, LodestoneBlockFiller.create((BlockState)((Block)BlockRegistry.SOULWOOD_GROWTH.get()).m_49966_()));
                    lastSaplingPos = new Vec3((double)plantPos.m_123341_(), (double)plantPos.m_123342_(), (double)plantPos.m_123343_());
                    ++saplingsPlaced;
                }
                if (filler.getLayer(BLIGHT).containsKey((Object)plantPos)) continue;
                BlockState state = ((Block)BlockRegistry.BLIGHTED_GROWTH.get()).m_49966_();
                if (random.m_188501_() < 0.4f) {
                    state = (BlockState)((BlockState)((Block)BlockRegistry.CLINGING_BLIGHT.get()).m_49966_().m_61124_(ClingingBlightBlock.BLIGHT_TYPE, (Comparable)((Object)ClingingBlightBlock.BlightType.GROUNDED_ROOTS))).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)WorldgenHelper.DIRECTIONS[random.m_188503_(4)]);
                }
                if (!blockState.m_60795_() && !blockState.m_247087_() || blockState.m_204336_(BlockTagRegistry.BLIGHTED_PLANTS)) continue;
                filler.getLayer(BLIGHT).put(plantPos, LodestoneBlockFiller.create((BlockState)state));
            }
        }
    }

    public static float pointDistancePlane(double x1, double z1, double x2, double z2) {
        return (float)Math.hypot(x1 - x2, z1 - z2);
    }
}

