/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.compability.irons_spellbooks;

import com.google.common.collect.Multimap;
import com.sammy.malum.common.effect.EchoingArcanaEffect;
import com.sammy.malum.common.effect.GluttonyEffect;
import com.sammy.malum.common.effect.SilencedEffect;
import com.sammy.malum.common.item.curiosities.curios.MalumCurioItem;
import com.sammy.malum.config.CommonConfig;
import com.sammy.malum.core.handlers.SoulDataHandler;
import com.sammy.malum.registry.common.item.EnchantmentRegistry;
import io.redspace.ironsspellbooks.api.events.SpellDamageEvent;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.util.UpdateClient;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerCooldowns;
import io.redspace.ironsspellbooks.item.weapons.StaffItem;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.ModList;

public class IronsSpellsCompat {
    public static boolean LOADED;

    public static void init() {
        LOADED = ModList.get().isLoaded("irons_spellbooks");
        if (LOADED) {
            MinecraftForge.EVENT_BUS.addListener(LoadedOnly::spellDamage);
            MinecraftForge.EVENT_BUS.addListener(LoadedOnly::triggerReplenishing);
        }
    }

    public static boolean isStaff(ItemStack stack) {
        if (LOADED) {
            return LoadedOnly.isStaff(stack);
        }
        return false;
    }

    public static void generateMana(ServerPlayer collector, double amount) {
        IronsSpellsCompat.generateMana(collector, (float)amount);
    }

    public static void generateMana(ServerPlayer collector, float amount) {
        if (LOADED) {
            LoadedOnly.generateMana(collector, amount);
        }
    }

    public static void recoverSpellCooldowns(ServerPlayer serverPlayer, int enchantmentLevel) {
        if (LOADED) {
            LoadedOnly.recoverSpellCooldowns(serverPlayer, enchantmentLevel);
        }
    }

    public static void addSoulHunterSpellPower(Multimap<Attribute, AttributeModifier> attributes, UUID uuid) {
        if (LOADED) {
            LoadedOnly.addSoulHunterSpellPower(attributes, uuid);
        }
    }

    public static void addGluttonySpellPower(GluttonyEffect effect) {
        if (LOADED) {
            LoadedOnly.addGluttonySpellPower(effect);
        }
    }

    public static void addSpellPowerToCurio(MalumCurioItem item, Multimap<Attribute, AttributeModifier> map, float amount) {
        if (LOADED) {
            LoadedOnly.addSpellPowerToCurio(item, map, amount);
        }
    }

    public static void addEchoingArcanaSpellCooldown(EchoingArcanaEffect effect) {
        if (LOADED) {
            LoadedOnly.addEchoingArcanaSpellCooldown(effect);
        }
    }

    public static void addSilencedNegativeAttributeModifiers(SilencedEffect effect) {
        if (LOADED) {
            LoadedOnly.addSilencedNegativeAttributeModifiers(effect);
        }
    }

    public static class LoadedOnly {
        public static void spellDamage(SpellDamageEvent event) {
            boolean canShatter = event.getEntity() instanceof Player ? (Boolean)CommonConfig.IRONS_SPELLBOOKS_SPIRIT_DAMAGE.getConfigValue() : (Boolean)CommonConfig.IRONS_SPELLBOOKS_NON_PLAYER_SPIRIT_DAMAGE.getConfigValue();
            if (canShatter) {
                SoulDataHandler.exposeSoul(event.getEntity());
            }
        }

        public static void triggerReplenishing(LivingHurtEvent event) {
            ServerPlayer serverPlayer;
            DamageSource source = event.getSource();
            Entity directEntity = source.m_7640_();
            if (directEntity instanceof ServerPlayer && (serverPlayer = (ServerPlayer)directEntity).m_36403_(0.0f) > 0.8f) {
                ItemStack stack = serverPlayer.m_21205_();
                int level = stack.getEnchantmentLevel((Enchantment)EnchantmentRegistry.REPLENISHING.get());
                LoadedOnly.recoverSpellCooldowns(serverPlayer, 0.025f * (float)level);
            }
        }

        public static boolean isStaff(ItemStack stack) {
            return stack.m_41720_() instanceof StaffItem;
        }

        public static void generateMana(ServerPlayer collector, float amount) {
            MagicData magicData = MagicData.getPlayerMagicData((LivingEntity)collector);
            magicData.addMana(amount);
            UpdateClient.SendManaUpdate((ServerPlayer)collector, (MagicData)magicData);
        }

        public static void recoverSpellCooldowns(ServerPlayer serverPlayer, float amount) {
            PlayerCooldowns cooldowns = MagicData.getPlayerMagicData((LivingEntity)serverPlayer).getPlayerCooldowns();
            cooldowns.getSpellCooldowns().forEach((key, value) -> cooldowns.decrementCooldown(value, (int)((float)value.getSpellCooldown() * amount)));
            cooldowns.syncToPlayer(serverPlayer);
        }

        public static void addSoulHunterSpellPower(Multimap<Attribute, AttributeModifier> attributes, UUID uuid) {
            attributes.put((Object)((Attribute)AttributeRegistry.SPELL_POWER.get()), (Object)new AttributeModifier(uuid, "Malum Spell Power", (double)0.1f, AttributeModifier.Operation.MULTIPLY_BASE));
        }

        public static void addGluttonySpellPower(GluttonyEffect effect) {
            effect.m_19472_((Attribute)AttributeRegistry.SPELL_POWER.get(), "90523925-900e-49bf-b07d-12e2e7350f2d", 0.1f, AttributeModifier.Operation.MULTIPLY_TOTAL);
        }

        public static void addSpellPowerToCurio(MalumCurioItem item, Multimap<Attribute, AttributeModifier> map, float amount) {
            item.addAttributeModifier(map, (Attribute)AttributeRegistry.SPELL_POWER.get(), uuid -> new AttributeModifier(uuid, "Curio Spell Power", (double)amount, AttributeModifier.Operation.MULTIPLY_BASE));
        }

        public static void addEchoingArcanaSpellCooldown(EchoingArcanaEffect effect) {
            effect.m_19472_((Attribute)AttributeRegistry.COOLDOWN_REDUCTION.get(), "8949b9d4-2505-4248-9667-0ece857af8a4", 0.02f, AttributeModifier.Operation.MULTIPLY_BASE);
        }

        public static void addSilencedNegativeAttributeModifiers(SilencedEffect effect) {
            effect.m_19472_((Attribute)AttributeRegistry.MANA_REGEN.get(), "47bad2ce-0eff-4472-9b97-fd7328eca05d", -0.1f, AttributeModifier.Operation.MULTIPLY_TOTAL);
            effect.m_19472_((Attribute)AttributeRegistry.SPELL_POWER.get(), "dabe8298-d6db-4f8c-8fb4-a6c28a4148cd", -0.1f, AttributeModifier.Operation.MULTIPLY_TOTAL);
        }
    }
}

