/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.compability.tetra;

import com.sammy.malum.registry.common.item.EnchantmentRegistry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.fml.ModList;
import se.mickelus.tetra.aspect.ItemAspect;
import se.mickelus.tetra.aspect.TetraEnchantmentHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.ModularItem;

public class TetraCompat {
    public static boolean LOADED;

    public static void init() {
        LOADED = ModList.get().isLoaded("tetra");
    }

    public static boolean hasSoulStrikeModifier(ItemStack stack) {
        return LOADED && LoadedOnly.hasSoulStrikeModifier(stack);
    }

    public static void onEntityJoin(EntityJoinLevelEvent event) {
        if (LOADED) {
            LoadedOnly.fireArrow(event);
        }
    }

    public static class LoadedOnly {
        private static final ItemEffect SHATTERS_SOULS = ItemEffect.get((String)"malum.shatters_souls");
        public static final ItemAspect SOUL_HUNTER_TOOL = ItemAspect.get((String)"soulStained");

        public static boolean hasSoulStrikeModifier(ItemStack stack) {
            Item item = stack.m_41720_();
            if (item instanceof ModularItem) {
                ModularItem modularItem = (ModularItem)item;
                return modularItem.getEffectLevel(stack, SHATTERS_SOULS) > 0;
            }
            return false;
        }

        public static void fireArrow(EntityJoinLevelEvent event) {
            Player player;
            Arrow arrow;
            Entity entity;
            Entity entity2 = event.getEntity();
            if (entity2 instanceof Arrow && (entity = (arrow = (Arrow)entity2).m_19749_()) instanceof Player && LoadedOnly.hasSoulStrikeModifier((player = (Player)entity).m_21211_())) {
                arrow.m_20049_("malum:can_shatter_souls");
            }
        }

        static {
            TetraEnchantmentHelper.registerMapping((ItemAspect)SOUL_HUNTER_TOOL, (TetraEnchantmentHelper.EnchantmentRules)new TetraEnchantmentHelper.EnchantmentRules("additions/malum_something", "exclusions/malum_something", new EnchantmentCategory[]{EnchantmentRegistry.SOUL_SHATTER_CAPABLE_WEAPON}));
        }
    }
}

