/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.handlers;

import com.sammy.malum.common.capability.MalumItemDataCapability;
import com.sammy.malum.common.capability.MalumLivingEntityDataCapability;
import com.sammy.malum.common.container.SpiritPouchContainer;
import com.sammy.malum.common.entity.spirit.SpiritItemEntity;
import com.sammy.malum.common.item.IMalumEventResponderItem;
import com.sammy.malum.common.item.curiosities.SpiritPouchItem;
import com.sammy.malum.config.CommonConfig;
import com.sammy.malum.core.handlers.SoulDataHandler;
import com.sammy.malum.core.listeners.SpiritDataReloadListener;
import com.sammy.malum.core.systems.recipe.SpiritWithCount;
import com.sammy.malum.core.systems.spirit.EntitySpiritDropData;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.AttributeRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.SpiritTypeRegistry;
import com.sammy.malum.registry.common.item.EnchantmentRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.registries.ForgeRegistries;
import team.lodestar.lodestone.helpers.ItemHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.container.ItemInventory;

public class SpiritHarvestHandler {
    public static void spawnSpiritsOnDeath(LivingDeathEvent event) {
        LivingEntity living;
        LivingEntity attacker;
        if (event.isCanceled()) {
            return;
        }
        LivingEntity target = event.getEntity();
        if (target instanceof Player) {
            return;
        }
        SoulDataHandler soulData = MalumLivingEntityDataCapability.getCapability((LivingEntity)target).soulData;
        if (soulData.soulless) {
            return;
        }
        if (((Boolean)CommonConfig.SOULLESS_SPAWNERS.getConfigValue()).booleanValue() && soulData.spawnerSpawned) {
            return;
        }
        DamageSource source = event.getSource();
        Entity entity = source.m_7639_();
        LivingEntity livingEntity = attacker = entity instanceof LivingEntity ? (living = (LivingEntity)entity) : target.m_21188_();
        if (soulData.exposedSoulDuration > 0.0f) {
            if (attacker == null) {
                SpiritHarvestHandler.spawnSpirits(event.getEntity());
            } else {
                ItemStack stack = SoulDataHandler.getSoulHunterWeapon(source, attacker);
                SpiritHarvestHandler.spawnSpirits(target, attacker, stack);
            }
            soulData.soulless = true;
        }
    }

    public static void primeItemForShatter(LivingDropsEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entityLiving = event.getEntity();
        MalumLivingEntityDataCapability capability = MalumLivingEntityDataCapability.getCapability(entityLiving);
        if (capability.soulsToApplyToDrops != null) {
            SpiritHarvestHandler.getSpiritData(entityLiving).ifPresent(spiritData -> {
                Ingredient spiritItem = spiritData.spiritItem;
                if (spiritItem != null) {
                    for (ItemEntity itemEntity : event.getDrops()) {
                        if (!spiritItem.test(itemEntity.m_32055_())) continue;
                        SpiritHarvestHandler.primeItemForShatter(itemEntity, capability);
                    }
                }
            });
        }
    }

    public static void primeItemForShatter(ItemEntity entity, MalumLivingEntityDataCapability data) {
        MalumItemDataCapability.getCapabilityOptional(entity).ifPresent(e -> {
            e.soulsToDrop = data.soulsToApplyToDrops.stream().map(ItemStack::m_41777_).collect(Collectors.toList());
            e.attackerForSouls = data.killerUUID;
        });
        entity.m_32062_();
        entity.f_31985_ = entity.lifespan - 20;
        entity.m_20242_(true);
        entity.m_20256_(entity.m_20184_().m_82542_(1.0, 0.5, 1.0));
    }

    public static void shatterItem(ItemExpireEvent event) {
        if (event.isCanceled()) {
            return;
        }
        ItemEntity entity = event.getEntity();
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            MalumItemDataCapability.getCapabilityOptional(entity).ifPresent(e -> {
                Entity patt4330$temp;
                LivingEntity attacker = null;
                if (e.attackerForSouls != null && (patt4330$temp = level2.m_8791_(e.attackerForSouls)) instanceof LivingEntity) {
                    LivingEntity living;
                    attacker = living = (LivingEntity)patt4330$temp;
                }
                if (e.soulsToDrop != null) {
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    for (int i = 0; i < entity.m_32055_().m_41613_(); ++i) {
                        e.soulsToDrop.stream().map(ItemStack::m_41777_).forEach(stacks::add);
                    }
                    SpiritHarvestHandler.createSpiritEntities((Level)level2, stacks, entity.m_20182_(), attacker);
                }
            });
        }
    }

    public static void pickupSpirit(LivingEntity collector, ItemStack stack) {
        if (collector instanceof Player) {
            Player player = (Player)collector;
            AttributeInstance instance = player.m_21051_((Attribute)AttributeRegistry.ARCANE_RESONANCE.get());
            ItemHelper.getEventResponders((LivingEntity)collector).forEach(s -> {
                Item patt5235$temp = s.m_41720_();
                if (patt5235$temp instanceof IMalumEventResponderItem) {
                    IMalumEventResponderItem eventItem = (IMalumEventResponderItem)patt5235$temp;
                    eventItem.pickupSpirit(collector, instance != null ? instance.m_22135_() : 0.0);
                }
            });
            for (NonNullList playerInventory : player.m_150109_().f_35979_) {
                for (ItemStack item : playerInventory) {
                    ItemInventory inventory;
                    ItemStack result;
                    if (!(item.m_41720_() instanceof SpiritPouchItem) || !(result = (inventory = SpiritPouchItem.getInventory(item)).m_19173_(stack)).m_41619_()) continue;
                    RandomSource random = collector.m_217043_();
                    float pitch = ((random.m_188501_() - random.m_188501_()) * 0.7f + 1.0f) * 2.0f;
                    player.m_5496_(SoundEvents.f_12019_, 0.2f, pitch);
                    AbstractContainerMenu abstractContainerMenu = player.f_36096_;
                    if (abstractContainerMenu instanceof SpiritPouchContainer) {
                        SpiritPouchContainer pouchMenu = (SpiritPouchContainer)abstractContainerMenu;
                        pouchMenu.update(inventory);
                    }
                    return;
                }
            }
        }
        ItemHelper.giveItemToEntity((LivingEntity)collector, (ItemStack)stack);
    }

    public static void spawnSpirits(LivingEntity target) {
        SpiritHarvestHandler.spawnSpirits(SpiritHarvestHandler.getSpiritDropsRaw(target), target, null);
    }

    public static void spawnSpirits(LivingEntity target, LivingEntity attacker, ItemStack harvestStack) {
        SpiritHarvestHandler.spawnSpirits(SpiritHarvestHandler.getSpawnedSpirits(target, attacker, harvestStack), target, attacker);
    }

    public static void spawnSpirits(List<ItemStack> spirits, LivingEntity target, LivingEntity attacker) {
        if (spirits.isEmpty()) {
            return;
        }
        SpiritHarvestHandler.getSpiritData(target).ifPresent(data -> {
            if (data.spiritItem != null) {
                MalumLivingEntityDataCapability.getCapabilityOptional(target).ifPresent(e -> {
                    e.soulsToApplyToDrops = spirits;
                    if (attacker != null) {
                        e.killerUUID = attacker.m_20148_();
                    }
                });
            } else {
                SpiritHarvestHandler.spawnItemsAsSpirits(spirits, target, attacker);
            }
        });
    }

    public static void spawnItemAsSpirit(ItemStack spirit, LivingEntity target, LivingEntity attacker) {
        SpiritHarvestHandler.spawnItemsAsSpirits(List.of(spirit), target, attacker);
    }

    public static void spawnItemsAsSpirits(Collection<ItemStack> spirits, LivingEntity target, LivingEntity attacker) {
        SpiritHarvestHandler.createSpiritEntities(target.m_9236_(), spirits, target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0), attacker);
    }

    public static void createSpiritEntities(Level level, Collection<ItemStack> spirits, Vec3 position, @Nullable LivingEntity attacker) {
        SpiritHarvestHandler.createSpiritEntities(level, spirits, position, spirits.stream().mapToInt(ItemStack::m_41613_).sum(), attacker);
    }

    private static void createSpiritEntities(Level level, Collection<ItemStack> spirits, Vec3 position, float totalCount, @Nullable LivingEntity attacker) {
        boolean noFancySpirits = (Boolean)CommonConfig.NO_FANCY_SPIRITS.getConfigValue();
        if (attacker == null) {
            noFancySpirits = (Boolean)CommonConfig.NO_FANCY_SPIRITS_FOR_TOTEMS.getConfigValue();
            attacker = level.m_5788_(position.f_82479_, position.f_82480_, position.f_82481_, 8.0, e -> true);
        }
        UUID attackerUUID = attacker == null ? null : attacker.m_20148_();
        float speed = 0.15f + 0.25f / (totalCount + 1.0f);
        RandomSource random = level.f_46441_;
        for (ItemStack stack : spirits) {
            if (stack.m_41619_()) continue;
            for (int j = 0; j < stack.m_41613_(); ++j) {
                if (noFancySpirits) {
                    ItemEntity itemEntity = new ItemEntity(level, position.f_82479_, position.f_82480_, position.f_82481_, stack);
                    itemEntity.m_32060_();
                    itemEntity.m_20334_((double)Mth.m_216267_((RandomSource)random, (float)-0.1f, (float)0.1f), (double)Mth.m_216267_((RandomSource)random, (float)0.25f, (float)0.5f), (double)Mth.m_216267_((RandomSource)random, (float)-0.1f, (float)0.1f));
                    level.m_7967_((Entity)itemEntity);
                    continue;
                }
                SpiritItemEntity entity = new SpiritItemEntity(level, attackerUUID, ItemHelper.copyWithNewCount((ItemStack)stack, (int)1), position.f_82479_, position.f_82480_, position.f_82481_, RandomHelper.randomBetween((RandomSource)random, (float)(-speed), (float)speed), RandomHelper.randomBetween((RandomSource)random, (float)0.05f, (float)0.06f), RandomHelper.randomBetween((RandomSource)random, (float)(-speed), (float)speed));
                level.m_7967_((Entity)entity);
            }
        }
        level.m_6263_(null, position.f_82479_, position.f_82480_, position.f_82481_, (SoundEvent)SoundRegistry.SOUL_SHATTER.get(), SoundSource.PLAYERS, 1.0f, 0.7f + random.m_188501_() * 0.4f);
    }

    public static List<ItemStack> getSpawnedSpirits(LivingEntity entity, LivingEntity attacker, ItemStack harvestStack) {
        return SpiritHarvestHandler.getSpiritData(entity).map(data -> SpiritHarvestHandler.applySpiritLootBonuses(SpiritHarvestHandler.getSpiritDropsRaw(data), attacker, harvestStack)).orElse(Collections.emptyList());
    }

    public static List<ItemStack> applySpiritLootBonuses(List<ItemStack> spirits, LivingEntity attacker, ItemStack weapon) {
        if (spirits.isEmpty()) {
            return spirits;
        }
        int spiritBonus = 0;
        if (attacker.m_21051_((Attribute)AttributeRegistry.SPIRIT_SPOILS.get()) != null) {
            spiritBonus += Mth.m_14165_((double)attacker.m_21133_((Attribute)AttributeRegistry.SPIRIT_SPOILS.get()));
        }
        if (!weapon.m_41619_()) {
            int spiritPlunder = weapon.getEnchantmentLevel((Enchantment)EnchantmentRegistry.SPIRIT_PLUNDER.get());
            if (spiritPlunder > 0) {
                weapon.m_41622_(spiritPlunder, attacker, e -> e.m_21166_(EquipmentSlot.MAINHAND));
            }
            spiritBonus += spiritPlunder;
        }
        for (int i = 0; i < spiritBonus; ++i) {
            int random = attacker.m_217043_().m_188503_(spirits.size());
            spirits.get(random).m_41769_(1);
        }
        return spirits;
    }

    public static List<ItemStack> getSpiritDropsRaw(LivingEntity entity) {
        return SpiritHarvestHandler.getSpiritData(entity).map(SpiritHarvestHandler::getSpiritDropsRaw).orElse(Collections.emptyList());
    }

    public static List<ItemStack> getSpiritDropsRaw(EntitySpiritDropData data) {
        return data != null ? data.droppedSpirits.stream().map(SpiritWithCount::getStack).collect(Collectors.toList()) : Collections.emptyList();
    }

    public static Optional<EntitySpiritDropData> getSpiritData(LivingEntity entity) {
        ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        if (SpiritDataReloadListener.HAS_NO_DATA.contains(key)) {
            return Optional.empty();
        }
        EntitySpiritDropData spiritData = SpiritDataReloadListener.SPIRIT_DATA.get(key);
        if (spiritData != null) {
            return Optional.of(spiritData);
        }
        if (!entity.m_6072_()) {
            return Optional.of(SpiritDataReloadListener.DEFAULT_BOSS_SPIRIT_DATA);
        }
        if (!((Boolean)CommonConfig.USE_DEFAULT_SPIRIT_VALUES.getConfigValue()).booleanValue()) {
            return Optional.empty();
        }
        return switch (entity.m_6095_().m_20674_()) {
            case MobCategory.MONSTER -> Optional.of(SpiritDataReloadListener.DEFAULT_MONSTER_SPIRIT_DATA);
            case MobCategory.CREATURE -> Optional.of(SpiritDataReloadListener.DEFAULT_CREATURE_SPIRIT_DATA);
            case MobCategory.AMBIENT -> Optional.of(SpiritDataReloadListener.DEFAULT_AMBIENT_SPIRIT_DATA);
            case MobCategory.AXOLOTLS -> Optional.of(SpiritDataReloadListener.DEFAULT_AXOLOTL_SPIRIT_DATA);
            case MobCategory.UNDERGROUND_WATER_CREATURE -> Optional.of(SpiritDataReloadListener.DEFAULT_UNDERGROUND_WATER_CREATURE_SPIRIT_DATA);
            case MobCategory.WATER_CREATURE -> Optional.of(SpiritDataReloadListener.DEFAULT_WATER_CREATURE_SPIRIT_DATA);
            case MobCategory.WATER_AMBIENT -> Optional.of(SpiritDataReloadListener.DEFAULT_WATER_AMBIENT_SPIRIT_DATA);
            default -> Optional.empty();
        };
    }

    public static MalumSpiritType getSpiritType(String spirit) {
        return SpiritTypeRegistry.SPIRITS.getOrDefault(spirit, SpiritTypeRegistry.SACRED_SPIRIT);
    }
}

