/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.handlers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.sammy.malum.client.VoidRevelationHandler;
import com.sammy.malum.common.block.curiosities.weeping_well.PrimordialSoupBlock;
import com.sammy.malum.common.block.curiosities.weeping_well.VoidConduitBlock;
import com.sammy.malum.common.block.curiosities.weeping_well.VoidConduitBlockEntity;
import com.sammy.malum.common.capability.MalumLivingEntityDataCapability;
import com.sammy.malum.common.capability.MalumPlayerDataCapability;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.common.packets.VoidRejectionPacket;
import com.sammy.malum.core.handlers.SpiritHarvestHandler;
import com.sammy.malum.registry.client.ShaderRegistry;
import com.sammy.malum.registry.common.DamageTypeRegistry;
import com.sammy.malum.registry.common.MobEffectRegistry;
import com.sammy.malum.registry.common.PacketRegistry;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.item.ItemRegistry;
import com.sammy.malum.visual_effects.networked.data.PositionEffectData;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.network.PacketDistributor;
import team.lodestar.lodestone.helpers.BlockHelper;
import team.lodestar.lodestone.helpers.DamageTypeHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.shader.ExtendedShaderInstance;

public class TouchOfDarknessHandler {
    public static final UUID GRAVITY_MODIFIER_UUID = UUID.fromString("d0aea6b5-f6c5-479d-b70c-455e46a62184");
    public static final float MAX_AFFLICTION = 100.0f;
    public boolean isNearWeepingWell;
    public int weepingWellInfluence;
    public int expectedAffliction;
    public int afflictionDuration;
    public float currentAffliction;
    public int progressToRejection;
    public int rejection;

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("isNearWeepingWell", this.isNearWeepingWell);
        tag.m_128405_("weepingWellInfluence", this.weepingWellInfluence);
        tag.m_128405_("expectedAffliction", this.expectedAffliction);
        tag.m_128405_("afflictionDuration", this.afflictionDuration);
        tag.m_128350_("currentAffliction", this.currentAffliction);
        tag.m_128405_("progressToRejection", this.progressToRejection);
        tag.m_128405_("rejection", this.rejection);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.isNearWeepingWell = tag.m_128471_("isNearWeepingWell");
        this.weepingWellInfluence = tag.m_128451_("weepingWellInfluence");
        this.expectedAffliction = tag.m_128451_("expectedAffliction");
        this.afflictionDuration = tag.m_128451_("afflictionDuration");
        this.currentAffliction = tag.m_128457_("currentAffliction");
        this.progressToRejection = tag.m_128451_("progressToRejection");
        this.rejection = tag.m_128451_("rejection");
    }

    public static void handlePrimordialSoupContact(LivingEntity livingEntity) {
        TouchOfDarknessHandler touchOfDarknessHandler = MalumLivingEntityDataCapability.getCapability((LivingEntity)livingEntity).touchOfDarknessHandler;
        if (touchOfDarknessHandler.rejection > 0) {
            return;
        }
        livingEntity.m_20256_(livingEntity.m_20184_().m_82490_((double)0.4f));
        touchOfDarknessHandler.afflict(100);
    }

    public static Optional<VoidConduitBlockEntity> checkForWeepingWell(LivingEntity livingEntity) {
        return BlockHelper.getBlockEntitiesStream(VoidConduitBlockEntity.class, (Level)livingEntity.m_9236_(), (BlockPos)livingEntity.m_20183_(), (int)8).findFirst();
    }

    public static void entityTick(LivingEvent.LivingTickEvent event) {
        AttributeInstance gravity;
        Block block;
        boolean isInTheGoop;
        LivingEntity livingEntity = event.getEntity();
        Level level = livingEntity.m_9236_();
        TouchOfDarknessHandler handler = MalumLivingEntityDataCapability.getCapability((LivingEntity)livingEntity).touchOfDarknessHandler;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (level.m_46467_() % 20L == 0L) {
                Optional<VoidConduitBlockEntity> voidConduitBlockEntity = TouchOfDarknessHandler.checkForWeepingWell((LivingEntity)player);
                handler.isNearWeepingWell = voidConduitBlockEntity.isPresent();
            }
            if (handler.isNearWeepingWell) {
                ++handler.weepingWellInfluence;
            }
        }
        boolean bl = isInTheGoop = (block = level.m_8055_(livingEntity.m_20183_()).m_60734_()) instanceof PrimordialSoupBlock || block instanceof VoidConduitBlock;
        if (!isInTheGoop) {
            block = level.m_8055_(livingEntity.m_20183_().m_7494_()).m_60734_();
            boolean bl2 = isInTheGoop = block instanceof PrimordialSoupBlock || block instanceof VoidConduitBlock;
        }
        if (handler.afflictionDuration > 0) {
            --handler.afflictionDuration;
            if (handler.afflictionDuration == 0) {
                handler.expectedAffliction = 0;
            }
        }
        if (handler.currentAffliction < (float)handler.expectedAffliction) {
            handler.currentAffliction = Math.min(100.0f, handler.currentAffliction + 1.5f);
        }
        if (handler.currentAffliction > (float)handler.expectedAffliction) {
            handler.currentAffliction = Math.max(handler.currentAffliction - (handler.expectedAffliction == 0 ? 1.5f : 0.75f), (float)handler.expectedAffliction);
        }
        if ((gravity = livingEntity.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get())) != null) {
            boolean hasModifier;
            boolean bl3 = hasModifier = gravity.m_22111_(GRAVITY_MODIFIER_UUID) != null;
            if (handler.progressToRejection > 0) {
                if (!hasModifier) {
                    gravity.m_22118_(TouchOfDarknessHandler.getEntityGravityAttributeModifier(livingEntity));
                }
                gravity.m_22129_();
            } else if (hasModifier) {
                gravity.m_22120_(GRAVITY_MODIFIER_UUID);
            }
        }
        if (isInTheGoop) {
            Player player;
            if (!(livingEntity instanceof Player) || !(player = (Player)livingEntity).m_5833_()) {
                ++handler.progressToRejection;
                if (!level.f_46443_) {
                    if (livingEntity instanceof Player && level.m_46467_() % 6L == 0L) {
                        SoundHelper.playSound((Entity)livingEntity, (SoundEvent)((SoundEvent)SoundRegistry.SONG_OF_THE_VOID.get()), (SoundSource)SoundSource.HOSTILE, (float)(0.5f + (float)handler.progressToRejection * 0.02f), (float)(0.5f + (float)handler.progressToRejection * 0.03f));
                    }
                    if (handler.rejection == 0 && handler.progressToRejection > 60) {
                        handler.reject(livingEntity);
                    }
                }
            }
        } else {
            handler.progressToRejection = 0;
        }
        if (handler.rejection > 0) {
            --handler.rejection;
            float intensity = (float)handler.rejection / 40.0f;
            Vec3 movement = livingEntity.m_20184_();
            livingEntity.m_20334_(movement.f_82479_, Math.pow(intensity, 2.0), movement.f_82481_);
        }
    }

    public void afflict(int expectedAffliction) {
        if (this.expectedAffliction > expectedAffliction) {
            return;
        }
        this.expectedAffliction = expectedAffliction;
        this.afflictionDuration = 60;
    }

    public void reject(LivingEntity livingEntity) {
        if (!(livingEntity instanceof Player)) {
            livingEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        Player player = (Player)livingEntity;
        MalumPlayerDataCapability playerDataCapability = MalumPlayerDataCapability.getCapability(player);
        Level level = livingEntity.m_9236_();
        this.progressToRejection = 0;
        this.rejection = 40;
        if (!level.f_46443_) {
            PacketRegistry.MALUM_CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> livingEntity), (Object)new VoidRejectionPacket(livingEntity.m_19879_()));
            Optional<VoidConduitBlockEntity> voidConduitBlockEntity = TouchOfDarknessHandler.checkForWeepingWell(livingEntity);
            if (voidConduitBlockEntity.isPresent()) {
                VoidConduitBlockEntity weepingWell = voidConduitBlockEntity.get();
                BlockPos worldPosition = weepingWell.m_58899_();
                ParticleEffectTypeRegistry.WEEPING_WELL_REACTS.createPositionedEffect(level, new PositionEffectData((float)worldPosition.m_123341_() + 0.5f, (float)worldPosition.m_123342_() + 0.6f, (float)worldPosition.m_123343_() + 0.5f));
            } else {
                ParticleEffectTypeRegistry.WEEPING_WELL_REACTS.createEntityEffect((Entity)livingEntity);
            }
            if (!player.m_7500_()) {
                livingEntity.m_6469_(DamageTypeHelper.create((Level)level, DamageTypeRegistry.VOODOO_PLAYERLESS), 4.0f);
            }
            if (!playerDataCapability.hasBeenRejected) {
                SpiritHarvestHandler.spawnItemAsSpirit(((SpiritShardItem)((Object)ItemRegistry.UMBRAL_SPIRIT.get())).m_7968_(), (LivingEntity)player, (LivingEntity)player);
            }
            level.m_5594_(null, livingEntity.m_20183_(), (SoundEvent)SoundRegistry.VOID_REJECTION.get(), SoundSource.HOSTILE, 2.0f, Mth.m_216267_((RandomSource)livingEntity.m_217043_(), (float)0.5f, (float)0.8f));
        } else {
            VoidRevelationHandler.seeTheRevelation(VoidRevelationHandler.RevelationType.BLACK_CRYSTAL);
        }
        playerDataCapability.hasBeenRejected = true;
        livingEntity.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.REJECTED.get(), 400, 0));
    }

    public static AttributeModifier getEntityGravityAttributeModifier(final LivingEntity livingEntity) {
        return new AttributeModifier(GRAVITY_MODIFIER_UUID, "Weeping Well Gravity Modifier", 0.0, AttributeModifier.Operation.MULTIPLY_TOTAL){

            public double m_22218_() {
                return TouchOfDarknessHandler.updateEntityGravity(livingEntity);
            }
        };
    }

    public static double updateEntityGravity(LivingEntity livingEntity) {
        TouchOfDarknessHandler handler = MalumLivingEntityDataCapability.getCapability((LivingEntity)livingEntity).touchOfDarknessHandler;
        if (handler.progressToRejection > 0) {
            return (float)(-Math.min(60, handler.progressToRejection)) / 60.0f;
        }
        return 0.0;
    }

    public static class ClientOnly {
        private static final Tesselator INSTANCE = new Tesselator();

        public static void renderDarknessVignette(GuiGraphics guiGraphics) {
            Minecraft minecraft = Minecraft.m_91087_();
            PoseStack poseStack = guiGraphics.m_280168_();
            LocalPlayer player = minecraft.f_91074_;
            TouchOfDarknessHandler darknessHandler = MalumLivingEntityDataCapability.getCapability((LivingEntity)player).touchOfDarknessHandler;
            if (darknessHandler.currentAffliction == 0.0f) {
                return;
            }
            int screenWidth = minecraft.m_91268_().m_85445_();
            int screenHeight = minecraft.m_91268_().m_85446_();
            float effectStrength = Easing.SINE_IN_OUT.ease(darknessHandler.currentAffliction / 100.0f, 0.0f, 1.0f, 1.0f);
            float alpha = Math.min(1.0f, effectStrength * 5.0f);
            float zoom = 0.5f + Math.min(0.35f, effectStrength);
            float intensity = 1.0f + (effectStrength > 0.5f ? (effectStrength - 0.5f) * 2.5f : 0.0f);
            ExtendedShaderInstance shaderInstance = (ExtendedShaderInstance)ShaderRegistry.TOUCH_OF_DARKNESS.getInstance().get();
            shaderInstance.m_173356_("Speed").m_5985_(1000.0f);
            Consumer<Float> setZoom = f -> shaderInstance.m_173356_("Zoom").m_5985_(f.floatValue());
            Consumer<Float> setIntensity = f -> shaderInstance.m_173356_("Intensity").m_5985_(f.floatValue());
            VFXBuilders.ScreenVFXBuilder builder = VFXBuilders.createScreen().setPosColorTexDefaultFormat().setPositionWithWidth(0.0f, 0.0f, (float)screenWidth, (float)screenHeight).overrideBufferBuilder(INSTANCE.m_85915_()).setColor(0.0f, 0.0f, 0.0f).setAlpha(alpha).setShader(ShaderRegistry.TOUCH_OF_DARKNESS.getInstance());
            poseStack.m_85836_();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            setZoom.accept(Float.valueOf(zoom));
            setIntensity.accept(Float.valueOf(intensity));
            builder.draw(poseStack);
            setZoom.accept(Float.valueOf(zoom * 1.25f + 0.15f));
            setIntensity.accept(Float.valueOf(intensity * 0.8f + 0.5f));
            builder.setAlpha(0.5f * alpha).draw(poseStack);
            RenderSystem.disableBlend();
            poseStack.m_85849_();
            shaderInstance.setUniformDefaults();
        }
    }
}

