/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.listeners;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sammy.malum.MalumMod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class ReapingDataReloadListener
extends SimpleJsonResourceReloadListener {
    public static Map<ResourceLocation, List<MalumReapingDropsData>> REAPING_DATA = new HashMap<ResourceLocation, List<MalumReapingDropsData>>();
    private static final Gson GSON = new GsonBuilder().create();

    public ReapingDataReloadListener() {
        super(GSON, "reaping_data");
    }

    public static void register(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new ReapingDataReloadListener());
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        REAPING_DATA.clear();
        for (int i = 0; i < objectIn.size(); ++i) {
            ResourceLocation location = (ResourceLocation)objectIn.keySet().toArray()[i];
            JsonObject object = objectIn.get(location).getAsJsonObject();
            String name = object.getAsJsonPrimitive("registry_name").getAsString();
            ResourceLocation resourceLocation = new ResourceLocation(name);
            if (!ForgeRegistries.ENTITY_TYPES.containsKey(resourceLocation)) continue;
            if (REAPING_DATA.containsKey(resourceLocation)) {
                MalumMod.LOGGER.info("Entity with registry name: " + name + " already has reaping data associated with it. Overwriting.");
            }
            JsonArray drops = object.getAsJsonArray("drops");
            ArrayList<MalumReapingDropsData> dropsList = new ArrayList<MalumReapingDropsData>();
            for (JsonElement drop : drops) {
                JsonObject dropObject = drop.getAsJsonObject();
                if (!dropObject.has("ingredient")) {
                    MalumMod.LOGGER.info("Entity with registry name: " + name + " lacks a reaping ingredient. Skipping drops entry.");
                    continue;
                }
                Ingredient dropIngredient = Ingredient.m_43917_((JsonElement)dropObject.getAsJsonObject("ingredient"));
                float chance = dropObject.getAsJsonPrimitive("chance").getAsFloat();
                int min = dropObject.getAsJsonPrimitive("min").getAsInt();
                int max = dropObject.getAsJsonPrimitive("max").getAsInt();
                dropsList.add(new MalumReapingDropsData(dropIngredient, chance, min, max));
            }
            REAPING_DATA.put(resourceLocation, dropsList);
        }
    }

    public static class MalumReapingDropsData {
        public final Ingredient drop;
        public final float chance;
        public final int min;
        public final int max;

        public MalumReapingDropsData(Ingredient drop, float chance, int min, int max) {
            this.drop = drop;
            this.chance = chance;
            this.min = min;
            this.max = max;
        }
    }
}

