/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.ritual;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.block.curiosities.ritual_plinth.RitualPlinthBlockEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class MalumRitualTier {
    public static final List<MalumRitualTier> TIERS = new ArrayList<MalumRitualTier>();
    public static final MalumRitualTier FADED = MalumRitualTier.create(new MalumRitualTier(MalumMod.malumPath("faded"), 64, 1));
    public static final MalumRitualTier DIM = MalumRitualTier.create(new MalumRitualTier(MalumMod.malumPath("dim"), 256, 2));
    public static final MalumRitualTier VAGUE = MalumRitualTier.create(new MalumRitualTier(MalumMod.malumPath("vague"), 1024, 3));
    public static final MalumRitualTier BRIGHT = MalumRitualTier.create(new MalumRitualTier(MalumMod.malumPath("bright"), 4096, 4));
    public static final MalumRitualTier VIVID = MalumRitualTier.create(new MalumRitualTier(MalumMod.malumPath("vivid"), 16384, 5));
    public static final MalumRitualTier RADIANT = MalumRitualTier.create(new MalumRitualTier(MalumMod.malumPath("radiant"), 65536, 6));
    public final ResourceLocation identifier;
    public final int spiritThreshold;
    public final int potency;

    public MalumRitualTier(ResourceLocation identifier, int spiritThreshold, int potency) {
        this.identifier = identifier;
        this.spiritThreshold = spiritThreshold;
        this.potency = potency;
    }

    public boolean isGreaterThan(MalumRitualTier ritualTier) {
        return this.potency > ritualTier.potency;
    }

    public String translationIdentifier() {
        return this.identifier.m_135827_() + ".gui.ritual.tier." + this.identifier.m_135815_();
    }

    public ResourceLocation getDecorTexture() {
        return new ResourceLocation(this.identifier.m_135827_(), "textures/vfx/ritual/decor_" + this.identifier.m_135815_() + ".png");
    }

    public static MalumRitualTier create(MalumRitualTier tier) {
        TIERS.add(tier);
        return tier;
    }

    public static MalumRitualTier figureOutTier(RitualPlinthBlockEntity plinthBlockEntity) {
        return MalumRitualTier.figureOutTier(plinthBlockEntity.spiritAmount);
    }

    public static MalumRitualTier figureOutTier(int spiritAmount) {
        List<MalumRitualTier> collect = TIERS.stream().filter(t -> spiritAmount >= t.spiritThreshold).toList();
        return collect.isEmpty() ? null : collect.get(collect.size() - 1);
    }
}

