/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.ritual;

import com.sammy.malum.common.block.curiosities.ritual_plinth.RitualPlinthBlockEntity;
import com.sammy.malum.core.systems.ritual.MalumRitualRecipeData;
import com.sammy.malum.core.systems.ritual.MalumRitualTier;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public abstract class MalumRitualType {
    public final MalumSpiritType spirit;
    public final ResourceLocation identifier;
    protected MalumRitualRecipeData recipeData;

    public MalumRitualType(ResourceLocation identifier, MalumSpiritType spirit) {
        this.identifier = identifier;
        this.spirit = spirit;
    }

    public InteractionResult onUsePlinth(RitualPlinthBlockEntity ritualPlinth, Player player, InteractionHand hand) {
        return InteractionResult.PASS;
    }

    public boolean isItemStackValid(RitualPlinthBlockEntity ritualPlinth, ItemStack stack) {
        return false;
    }

    public abstract void triggerRitualEffect(RitualPlinthBlockEntity var1);

    public void setRecipeData(MalumRitualRecipeData recipeData) {
        this.recipeData = recipeData;
    }

    public MalumRitualRecipeData getRecipeData() {
        return this.recipeData;
    }

    public String translationIdentifier() {
        return this.identifier.m_135827_() + ".gui.ritual." + this.identifier.m_135815_();
    }

    public ResourceLocation getIcon() {
        return new ResourceLocation(this.identifier.m_135827_(), "textures/vfx/ritual/" + this.identifier.m_135815_() + ".png");
    }

    public CompoundTag createShardNBT(MalumRitualTier tier) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128359_("stored_ritual", this.identifier.toString());
        compoundTag.m_128405_("stored_spirits", tier.spiritThreshold);
        return compoundTag;
    }

    public List<Component> makeRitualShardDescriptor(MalumRitualTier ritualTier) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        UnaryOperator spiritStyleModifier = this.spirit.getItemRarity().getStyleModifier();
        tooltip.add(this.makeDescriptorComponent("malum.gui.ritual.type", this.translationIdentifier(), spiritStyleModifier));
        tooltip.add(this.makeDescriptorComponent("malum.gui.ritual.tier", ritualTier.translationIdentifier(), spiritStyleModifier));
        return tooltip;
    }

    public List<Component> makeCodexDetailedDescriptor() {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        UnaryOperator spiritStyleModifier = this.spirit.getItemRarity().getStyleModifier();
        tooltip.add((Component)Component.m_237115_((String)this.translationIdentifier()).m_130938_(spiritStyleModifier));
        tooltip.add(this.makeDescriptorComponent("malum.gui.rite.effect", "malum.gui.book.entry.page.text." + this.identifier + ".hover"));
        return tooltip;
    }

    public final Component makeDescriptorComponent(String translationKey1, String translationKey2) {
        return Component.m_237115_((String)translationKey1).m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237115_((String)translationKey2).m_130940_(ChatFormatting.YELLOW));
    }

    public final Component makeDescriptorComponent(String translationKey1, String translationKey2, UnaryOperator<Style> style) {
        return Component.m_237115_((String)translationKey1).m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237115_((String)translationKey2).m_130938_(style));
    }
}

