/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.data.block;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.block.blight.CalcifiedBlightBlock;
import com.sammy.malum.common.block.blight.ClingingBlightBlock;
import com.sammy.malum.common.block.blight.TallCalcifiedBlightBlock;
import com.sammy.malum.common.block.curiosities.repair_pylon.RepairPylonComponentBlock;
import com.sammy.malum.common.block.curiosities.totem.TotemPoleBlock;
import com.sammy.malum.common.block.curiosities.weeping_well.PrimordialSoupBlock;
import com.sammy.malum.common.block.ether.EtherBrazierBlock;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.data.item.MalumItemModelSmithTypes;
import com.sammy.malum.registry.common.SpiritTypeRegistry;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import team.lodestar.lodestone.systems.datagen.ItemModelSmithTypes;
import team.lodestar.lodestone.systems.datagen.itemsmith.ItemModelSmith;
import team.lodestar.lodestone.systems.datagen.statesmith.BlockStateSmith;

public class MalumBlockStateSmithTypes {
    public static BlockStateSmith<TotemPoleBlock> TOTEM_POLE = new BlockStateSmith(TotemPoleBlock.class, ItemModelSmithTypes.NO_MODEL, (block, provider) -> {
        String name = provider.getBlockName(block);
        String woodName = name.substring(0, 8);
        ResourceLocation parent = MalumMod.malumPath("block/templates/template_totem_pole");
        ResourceLocation side = provider.getBlockTexture(woodName + "_log");
        ResourceLocation top = provider.getBlockTexture(woodName + "_log_top");
        provider.getVariantBuilder(block).forAllStates(s -> {
            String type = (String)((Object)s.m_61143_((Property)SpiritTypeRegistry.SPIRIT_TYPE_PROPERTY));
            MalumSpiritType spiritType = SpiritTypeRegistry.SPIRITS.get(type);
            ResourceLocation front = provider.modLoc("block/totem_poles/" + spiritType.identifier + "_" + woodName + "_cutout");
            ModelBuilder pole = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().withExistingParent(name + "_" + spiritType.identifier, parent)).texture("side", side)).texture("top", top)).texture("front", front);
            return ConfiguredModel.builder().modelFile((ModelFile)pole).rotationY(((int)((Direction)s.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180) % 360).build();
        });
    });
    public static BlockStateSmith<RepairPylonComponentBlock> REPAIR_PYLON_COMPONENT = new BlockStateSmith(RepairPylonComponentBlock.class, ItemModelSmithTypes.NO_MODEL, (block, provider) -> {
        ModelFile.ExistingModelFile model = provider.models().getExistingFile(MalumMod.malumPath("block/repair_pylon_component_middle"));
        ModelFile.ExistingModelFile topModel = provider.models().getExistingFile(MalumMod.malumPath("block/repair_pylon_component_top"));
        provider.getVariantBuilder(block).forAllStates(arg_0 -> MalumBlockStateSmithTypes.lambda$static$2((ModelFile)topModel, (ModelFile)model, arg_0));
    });
    public static BlockStateSmith<PrimordialSoupBlock> PRIMORDIAL_SOUP = new BlockStateSmith(PrimordialSoupBlock.class, (ItemModelSmith)ItemModelSmithTypes.AFFIXED_BLOCK_MODEL.apply("_top"), (block, provider) -> {
        String name = provider.getBlockName(block);
        ModelBuilder model = ((BlockModelBuilder)provider.models().withExistingParent(name, new ResourceLocation("block/powder_snow"))).texture("texture", MalumMod.malumPath("block/weeping_well/" + name));
        ModelFile.ExistingModelFile topModel = provider.models().getExistingFile(MalumMod.malumPath("block/" + name + "_top"));
        provider.getVariantBuilder(block).forAllStates(arg_0 -> MalumBlockStateSmithTypes.lambda$static$4((ModelFile)topModel, (ModelFile)model, arg_0));
    });
    public static BlockStateSmith<Block> HANGING_LEAVES = new BlockStateSmith(Block.class, (ItemModelSmith)ItemModelSmithTypes.AFFIXED_BLOCK_TEXTURE_MODEL.apply("_0"), (block, provider) -> {
        String name = provider.getBlockName(block);
        Function<Integer, ModelFile> modelProvider = i -> ((BlockModelBuilder)((BlockModelBuilder)provider.models().withExistingParent(name + "_" + i, MalumMod.malumPath("block/templates/template_hanging_leaves"))).texture("hanging_leaves", provider.getBlockTexture(name + "_" + i))).texture("particle", provider.getBlockTexture(name + "_" + i));
        ConfiguredModel.Builder builder = provider.getVariantBuilder(block).partialState().modelForState();
        for (int i2 = 0; i2 < 3; ++i2) {
            ModelFile model = modelProvider.apply(i2);
            builder = builder.modelFile(model).nextModel().modelFile(model).rotationY(90).nextModel().modelFile(model).rotationY(180).nextModel().modelFile(model).rotationY(270);
            if (i2 == 2) continue;
            builder = builder.nextModel();
        }
        builder.addModel();
    });
    public static BlockStateSmith<ClingingBlightBlock> CLINGING_BLIGHT = new BlockStateSmith(ClingingBlightBlock.class, ItemModelSmithTypes.GENERATED_ITEM, (block, provider) -> {
        String name = provider.getBlockName(block);
        ResourceLocation creeping = MalumMod.malumPath("block/templates/template_creeping_blight");
        ResourceLocation creepingWall = MalumMod.malumPath("block/templates/template_creeping_blight_wall");
        ResourceLocation creepingCeiling = MalumMod.malumPath("block/templates/template_creeping_blight_ceiling");
        provider.getVariantBuilder(block).forAllStates(s -> {
            ClingingBlightBlock.BlightType value = (ClingingBlightBlock.BlightType)((Object)((Object)((Object)s.m_61143_(ClingingBlightBlock.BLIGHT_TYPE))));
            String valueName = value.m_7912_();
            ResourceLocation parent = creepingWall;
            if (value.equals((Object)ClingingBlightBlock.BlightType.HANGING_ROOTS) || value.equals((Object)ClingingBlightBlock.BlightType.GROUNDED_ROOTS) || value.equals((Object)ClingingBlightBlock.BlightType.HANGING_BLIGHT_CONNECTION)) {
                parent = creeping;
            }
            if (value.equals((Object)ClingingBlightBlock.BlightType.HANGING_BLIGHT)) {
                parent = creepingCeiling;
            }
            ResourceLocation texture = provider.getBlockTexture(valueName);
            ResourceLocation smallTexture = provider.getBlockTexture(valueName + "_small");
            ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().withExistingParent(name + "_" + valueName, parent)).texture("big", texture)).texture("small", smallTexture)).texture("particle", texture);
            if (!parent.equals((Object)creeping)) {
                ResourceLocation bracingTexture = provider.getBlockTexture(valueName + "_bracing");
                model.texture("bracing", bracingTexture);
            }
            return ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(((int)((Direction)s.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180) % 360).build();
        });
    });
    public static BlockStateSmith<Block> BLIGHTED_BLOCK = new BlockStateSmith(Block.class, (block, provider) -> {
        String name = provider.getBlockName(block);
        ModelBuilder soil0 = provider.models().cubeAll(name, MalumMod.malumPath("block/" + name + "_0"));
        ModelBuilder soil1 = provider.models().cubeAll(name + "_1", MalumMod.malumPath("block/" + name + "_1"));
        provider.getVariantBuilder(block).partialState().modelForState().modelFile((ModelFile)soil0).nextModel().modelFile((ModelFile)soil0).rotationY(90).nextModel().modelFile((ModelFile)soil0).rotationY(180).nextModel().modelFile((ModelFile)soil0).rotationY(270).nextModel().modelFile((ModelFile)soil1).nextModel().modelFile((ModelFile)soil1).rotationY(90).nextModel().modelFile((ModelFile)soil1).rotationY(180).nextModel().modelFile((ModelFile)soil1).rotationY(270).addModel();
    });
    public static BlockStateSmith<Block> BLIGHTED_GROWTH = new BlockStateSmith(Block.class, ItemModelSmithTypes.NO_MODEL, (block, provider) -> {
        String name = provider.getBlockName(block);
        Function<Integer, ModelFile> tumorFunction = i -> ((BlockModelBuilder)provider.models().withExistingParent(name + "_" + i, new ResourceLocation("block/cross"))).texture("cross", MalumMod.malumPath("block/" + name + "_" + i));
        ConfiguredModel.Builder builder = provider.getVariantBuilder(block).partialState().modelForState();
        for (int i2 = 0; i2 < 10; ++i2) {
            builder = builder.modelFile(tumorFunction.apply(i2));
            if (i2 == 9) continue;
            builder = builder.nextModel();
        }
        builder.addModel();
    });
    public static BlockStateSmith<Block> CALCIFIED_BLIGHT = new BlockStateSmith(Block.class, ItemModelSmithTypes.GENERATED_ITEM, (block, provider) -> {
        String name = provider.getBlockName(block);
        Function<Integer, ModelFile> modelFunction = s -> ((BlockModelBuilder)provider.models().withExistingParent(name + "_" + s, new ResourceLocation("block/cross"))).texture("cross", MalumMod.malumPath("block/" + name + "_" + s));
        provider.getVariantBuilder(block).forAllStates(s -> {
            int value = (Integer)s.m_61143_((Property)CalcifiedBlightBlock.STAGE);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunction.apply(value)).build();
        });
    });
    public static BlockStateSmith<Block> TALL_CALCIFIED_BLIGHT = new BlockStateSmith(Block.class, ItemModelSmithTypes.NO_MODEL, (block, provider) -> {
        String name = provider.getBlockName(block);
        Function<String, ModelFile> modelFunction = s -> ((BlockModelBuilder)provider.models().withExistingParent(name + "_" + s, new ResourceLocation("block/cross"))).texture("cross", MalumMod.malumPath("block/" + name + "_" + s));
        provider.getVariantBuilder(block).forAllStates(s -> {
            int value = (Integer)s.m_61143_((Property)CalcifiedBlightBlock.STAGE);
            String prefix = "";
            if (s.m_61138_((Property)TallCalcifiedBlightBlock.f_52858_) && ((DoubleBlockHalf)s.m_61143_((Property)TallCalcifiedBlightBlock.f_52858_)).equals((Object)DoubleBlockHalf.UPPER)) {
                prefix = "top_";
            }
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunction.apply(prefix + value)).build();
        });
    });
    public static BlockStateSmith<EtherBrazierBlock> BRAZIER_BLOCK = new BlockStateSmith(EtherBrazierBlock.class, MalumItemModelSmithTypes.ETHER_BRAZIER_ITEM, (block, provider) -> {
        String name = provider.getBlockName(block);
        String textureName = name.replaceFirst("_iridescent", "");
        String particleName = textureName.replaceFirst("_ether_brazier", "") + "_rock";
        ModelBuilder brazier = ((BlockModelBuilder)((BlockModelBuilder)provider.models().withExistingParent(name, MalumMod.malumPath("block/templates/template_ether_brazier"))).texture("brazier", provider.getBlockTexture(textureName))).texture("particle", provider.getBlockTexture(particleName));
        ModelBuilder brazier_hanging = ((BlockModelBuilder)((BlockModelBuilder)provider.models().withExistingParent(name + "_hanging", MalumMod.malumPath("block/templates/template_ether_brazier_hanging"))).texture("brazier", provider.getBlockTexture(textureName))).texture("particle", provider.getBlockTexture(particleName));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)provider.getVariantBuilder(block).partialState().with((Property)EtherBrazierBlock.HANGING, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)brazier).addModel()).partialState().with((Property)EtherBrazierBlock.HANGING, (Comparable)Boolean.valueOf(true)).with((Property)EtherBrazierBlock.ROTATED, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)brazier_hanging).addModel()).partialState().with((Property)EtherBrazierBlock.HANGING, (Comparable)Boolean.valueOf(true)).with((Property)EtherBrazierBlock.ROTATED, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)brazier_hanging).rotationY(90).addModel();
    });
    public static BlockStateSmith<EtherBrazierBlock> IRIDESCENT_BRAZIER_BLOCK = new BlockStateSmith(EtherBrazierBlock.class, MalumItemModelSmithTypes.IRIDESCENT_ETHER_BRAZIER_ITEM, (block, provider) -> {
        String name = provider.getBlockName(block);
        String textureName = name.replaceFirst("_iridescent", "");
        String particleName = textureName.replaceFirst("_ether_brazier", "") + "_rock";
        ModelBuilder brazier = ((BlockModelBuilder)((BlockModelBuilder)provider.models().withExistingParent(name, MalumMod.malumPath("block/templates/template_ether_brazier"))).texture("brazier", provider.getBlockTexture(textureName))).texture("particle", provider.getBlockTexture(particleName));
        ModelBuilder brazier_hanging = ((BlockModelBuilder)((BlockModelBuilder)provider.models().withExistingParent(name + "_hanging", MalumMod.malumPath("block/templates/template_ether_brazier_hanging"))).texture("brazier", provider.getBlockTexture(textureName))).texture("particle", provider.getBlockTexture(particleName));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)provider.getVariantBuilder(block).partialState().with((Property)EtherBrazierBlock.HANGING, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)brazier).addModel()).partialState().with((Property)EtherBrazierBlock.HANGING, (Comparable)Boolean.valueOf(true)).with((Property)EtherBrazierBlock.ROTATED, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)brazier_hanging).addModel()).partialState().with((Property)EtherBrazierBlock.HANGING, (Comparable)Boolean.valueOf(true)).with((Property)EtherBrazierBlock.ROTATED, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)brazier_hanging).rotationY(90).addModel();
    });

    private static /* synthetic */ ConfiguredModel[] lambda$static$4(ModelFile topModel, ModelFile model, BlockState s) {
        return ConfiguredModel.builder().modelFile((Boolean)s.m_61143_((Property)PrimordialSoupBlock.TOP) != false ? topModel : model).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$static$2(ModelFile topModel, ModelFile model, BlockState s) {
        return ConfiguredModel.builder().modelFile((Boolean)s.m_61143_((Property)RepairPylonComponentBlock.TOP) != false ? topModel : model).build();
    }
}

