/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.data.recipe.builder;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sammy.malum.MalumMod;
import com.sammy.malum.core.systems.recipe.SpiritWithCount;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.recipe.RecipeSerializerRegistry;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import team.lodestar.lodestone.systems.recipe.IngredientWithCount;

public class SpiritInfusionRecipeBuilder {
    private final IngredientWithCount input;
    private final ItemStack output;
    private final List<SpiritWithCount> spirits = Lists.newArrayList();
    private final List<IngredientWithCount> extraItems = Lists.newArrayList();

    public SpiritInfusionRecipeBuilder(Ingredient input, int inputCount, ItemStack output) {
        this.input = new IngredientWithCount(input, inputCount);
        this.output = output;
    }

    public SpiritInfusionRecipeBuilder(Ingredient input, int inputCount, ItemLike output, int outputCount) {
        this(input, inputCount, new ItemStack(output, outputCount));
    }

    public SpiritInfusionRecipeBuilder(ItemLike input, int inputCount, ItemStack output) {
        this(Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), inputCount, output);
    }

    public SpiritInfusionRecipeBuilder(ItemLike input, int inputCount, ItemLike output, int outputCount) {
        this(Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), inputCount, new ItemStack(output, outputCount));
    }

    public SpiritInfusionRecipeBuilder addExtraItem(Ingredient ingredient, int count) {
        this.extraItems.add(new IngredientWithCount(ingredient, count));
        return this;
    }

    public SpiritInfusionRecipeBuilder addExtraItem(Item input, int count) {
        this.extraItems.add(new IngredientWithCount(Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), count));
        return this;
    }

    public SpiritInfusionRecipeBuilder addSpirit(MalumSpiritType type, int count) {
        this.spirits.add(new SpiritWithCount(type, count));
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumerIn) {
        this.build(consumerIn, ForgeRegistries.ITEMS.getKey((Object)this.output.m_41720_()).m_135815_());
    }

    public void build(Consumer<FinishedRecipe> consumerIn, String recipeName) {
        this.build(consumerIn, MalumMod.malumPath("spirit_infusion/" + recipeName));
    }

    public void build(Consumer<FinishedRecipe> consumerIn, ResourceLocation id) {
        consumerIn.accept(new Result(id));
    }

    public class Result
    implements FinishedRecipe {
        private final ResourceLocation id;

        public Result(ResourceLocation id) {
            this.id = id;
        }

        public void m_7917_(JsonObject json) {
            JsonObject inputObject = SpiritInfusionRecipeBuilder.this.input.serialize();
            JsonElement outputObject = Ingredient.m_43927_((ItemStack[])new ItemStack[]{SpiritInfusionRecipeBuilder.this.output}).m_43942_();
            if (SpiritInfusionRecipeBuilder.this.output.m_41613_() != 1) {
                outputObject.getAsJsonObject().addProperty("count", (Number)SpiritInfusionRecipeBuilder.this.output.m_41613_());
            }
            JsonArray extraItemsJson = new JsonArray();
            for (IngredientWithCount extraItem : SpiritInfusionRecipeBuilder.this.extraItems) {
                extraItemsJson.add((JsonElement)extraItem.serialize());
            }
            JsonArray spiritsJson = new JsonArray();
            for (SpiritWithCount spirit : SpiritInfusionRecipeBuilder.this.spirits) {
                spiritsJson.add((JsonElement)spirit.serialize());
            }
            json.add("input", (JsonElement)inputObject);
            json.add("output", outputObject);
            json.add("extra_items", (JsonElement)extraItemsJson);
            json.add("spirits", (JsonElement)spiritsJson);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)RecipeSerializerRegistry.INFUSION_RECIPE_SERIALIZER.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

