/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.data.recipe.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sammy.malum.MalumMod;
import com.sammy.malum.core.systems.recipe.SpiritWithCount;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.recipe.RecipeSerializerRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import team.lodestar.lodestone.systems.recipe.IngredientWithCount;

public class SpiritRepairRecipeBuilder {
    public final String itemIdRegex;
    public final String modIdRegex;
    public final float durabilityPercentage;
    public final List<Item> inputs = new ArrayList<Item>();
    public final IngredientWithCount repairMaterial;
    public final List<SpiritWithCount> spirits = new ArrayList<SpiritWithCount>();

    public SpiritRepairRecipeBuilder(String itemIdRegex, String modIdRegex, float durabilityPercentage, IngredientWithCount repairMaterial) {
        this.itemIdRegex = itemIdRegex;
        this.modIdRegex = modIdRegex;
        this.durabilityPercentage = durabilityPercentage;
        this.repairMaterial = repairMaterial;
    }

    public SpiritRepairRecipeBuilder(String itemIdRegex, float durabilityPercentage, Ingredient repairMaterial, int repairMaterialCount) {
        this(itemIdRegex, "", durabilityPercentage, new IngredientWithCount(repairMaterial, repairMaterialCount));
    }

    public SpiritRepairRecipeBuilder(float durabilityPercentage, Ingredient repairMaterial, int repairMaterialCount) {
        this("", "", durabilityPercentage, new IngredientWithCount(repairMaterial, repairMaterialCount));
    }

    public SpiritRepairRecipeBuilder addItem(Item item) {
        this.inputs.add(item);
        return this;
    }

    public SpiritRepairRecipeBuilder addSpirit(MalumSpiritType type, int count) {
        this.spirits.add(new SpiritWithCount(type, count));
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumerIn, String recipeName) {
        this.build(consumerIn, MalumMod.malumPath("spirit_crucible/repair/" + recipeName));
    }

    public void build(Consumer<FinishedRecipe> consumerIn, ResourceLocation id) {
        consumerIn.accept(new Result(id));
    }

    public void build(Consumer<FinishedRecipe> consumerIn) {
        this.build(consumerIn, ForgeRegistries.ITEMS.getKey((Object)this.inputs.get(0)).m_135815_());
    }

    public class Result
    implements FinishedRecipe {
        private final ResourceLocation id;

        public Result(ResourceLocation id) {
            this.id = id;
        }

        public void m_7917_(JsonObject json) {
            JsonArray inputsJson = new JsonArray();
            for (Item item : SpiritRepairRecipeBuilder.this.inputs) {
                inputsJson.add(ForgeRegistries.ITEMS.getKey((Object)item).toString());
            }
            JsonArray spiritsJson = new JsonArray();
            for (SpiritWithCount spirit : SpiritRepairRecipeBuilder.this.spirits) {
                spiritsJson.add((JsonElement)spirit.serialize());
            }
            json.addProperty("itemIdRegex", SpiritRepairRecipeBuilder.this.itemIdRegex);
            json.addProperty("modIdRegex", SpiritRepairRecipeBuilder.this.modIdRegex);
            json.addProperty("durabilityPercentage", (Number)Float.valueOf(SpiritRepairRecipeBuilder.this.durabilityPercentage));
            json.add("inputs", (JsonElement)inputsJson);
            json.add("repairMaterial", (JsonElement)SpiritRepairRecipeBuilder.this.repairMaterial.serialize());
            json.add("spirits", (JsonElement)spiritsJson);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)RecipeSerializerRegistry.REPAIR_RECIPE_SERIALIZER.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

