/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.registry.client;

import com.google.common.collect.Sets;
import com.sammy.malum.MalumMod;
import com.sammy.malum.client.VoidRevelationHandler;
import com.sammy.malum.core.handlers.hiding.HiddenTagHandler;
import com.sammy.malum.core.handlers.hiding.flags.FeatureFlagCacher;
import com.sammy.malum.core.handlers.hiding.flags.FeatureFlagExpandedUniverseSet;
import com.sammy.malum.registry.common.item.ItemTagRegistry;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.game.ClientboundUpdateEnabledFeaturesPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="malum", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class HiddenTagRegistry {
    public static final ResourceLocation HIDDEN_ITEM_FLAG_SPACE = MalumMod.malumPath("hiding");
    private static boolean blankFeatureSet = false;

    public static void attachFeatureFlags(FeatureFlagSet set) {
        ((FeatureFlagExpandedUniverseSet)set).malum$attachFeatureSet(blankFeatureSet ? HiddenTagHandler.createAllEnabledFlagSet() : HiddenTagHandler.createFeatureFlagSet());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void hideItems(BuildCreativeModeTabContentsEvent event) {
        List<TagKey<Item>> disabledTags = HiddenTagHandler.tagsToHide();
        Iterator iterator = event.getEntries().iterator();
        block0: while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            for (TagKey<Item> disabledTag : disabledTags) {
                if (!((ItemStack)entry.getKey()).m_204117_(disabledTag)) continue;
                iterator.remove();
                continue block0;
            }
        }
    }

    public static void registerHiddenTags() {
        HiddenTagHandler.hideTagWhen(ItemTagRegistry.HIDDEN_ALWAYS, () -> true);
        HiddenTagHandler.hideTagWhen(ItemTagRegistry.HIDDEN_UNTIL_VOID, () -> !VoidRevelationHandler.hasSeenTheRevelation(VoidRevelationHandler.RevelationType.VOID_READER));
        HiddenTagHandler.hideTagWhen(ItemTagRegistry.HIDDEN_UNTIL_BLACK_CRYSTAL, () -> !VoidRevelationHandler.hasSeenTheRevelation(VoidRevelationHandler.RevelationType.BLACK_CRYSTAL));
        HiddenTagHandler.buildFeatureFlagSet(HIDDEN_ITEM_FLAG_SPACE);
        HiddenTagHandler.registerHiddenItemListener(HiddenTagRegistry::rebuildHidingTags);
    }

    public static void blankOutHidingTags() {
        Minecraft.m_91087_().m_18707_(() -> {
            blankFeatureSet = true;
            HiddenTagRegistry.rebuildTags();
            blankFeatureSet = false;
        });
    }

    public static void rebuildHidingTags() {
        Minecraft.m_91087_().m_18707_(HiddenTagRegistry::rebuildTags);
    }

    private static void rebuildTags() {
        Iterable<ResourceLocation> cachedFlags;
        ClientPacketListener connection = Minecraft.m_91087_().m_91403_();
        if (connection != null && (cachedFlags = ((FeatureFlagCacher)connection).malum$cachedFeatureFlags()) != null) {
            connection.m_241155_(new ClientboundUpdateEnabledFeaturesPacket((Set)Sets.newHashSet(cachedFlags)));
        }
    }
}

