/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.registry.common.block;

import com.sammy.malum.client.renderer.block.MalumItemHolderRenderer;
import com.sammy.malum.client.renderer.block.MoteOfManaRenderer;
import com.sammy.malum.client.renderer.block.RepairPylonRenderer;
import com.sammy.malum.client.renderer.block.RitualPlinthRenderer;
import com.sammy.malum.client.renderer.block.SpiritAltarRenderer;
import com.sammy.malum.client.renderer.block.SpiritCatalyzerRenderer;
import com.sammy.malum.client.renderer.block.SpiritCrucibleRenderer;
import com.sammy.malum.client.renderer.block.SpiritJarRenderer;
import com.sammy.malum.client.renderer.block.TotemBaseRenderer;
import com.sammy.malum.client.renderer.block.TotemPoleRenderer;
import com.sammy.malum.client.renderer.block.VoidConduitRenderer;
import com.sammy.malum.client.renderer.block.VoidDepotRenderer;
import com.sammy.malum.common.block.curiosities.mana_mote.MoteOfManaBlockEntity;
import com.sammy.malum.common.block.curiosities.mana_mote.SpiritMoteBlock;
import com.sammy.malum.common.block.curiosities.obelisk.brilliant.BrilliantObeliskBlockEntity;
import com.sammy.malum.common.block.curiosities.obelisk.runewood.RunewoodObeliskBlockEntity;
import com.sammy.malum.common.block.curiosities.repair_pylon.RepairPylonCoreBlockEntity;
import com.sammy.malum.common.block.curiosities.ritual_plinth.RitualPlinthBlockEntity;
import com.sammy.malum.common.block.curiosities.runic_workbench.RunicWorkbenchBlockEntity;
import com.sammy.malum.common.block.curiosities.spirit_altar.SpiritAltarBlockEntity;
import com.sammy.malum.common.block.curiosities.spirit_crucible.SpiritCrucibleCoreBlockEntity;
import com.sammy.malum.common.block.curiosities.spirit_crucible.catalyzer.SpiritCatalyzerCoreBlockEntity;
import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlock;
import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.common.block.curiosities.totem.TotemPoleBlock;
import com.sammy.malum.common.block.curiosities.totem.TotemPoleBlockEntity;
import com.sammy.malum.common.block.curiosities.void_depot.VoidDepotBlockEntity;
import com.sammy.malum.common.block.curiosities.weavers_workbench.WeaversWorkbenchBlockEntity;
import com.sammy.malum.common.block.curiosities.weeping_well.VoidConduitBlockEntity;
import com.sammy.malum.common.block.ether.EtherBlock;
import com.sammy.malum.common.block.ether.EtherBlockEntity;
import com.sammy.malum.common.block.storage.jar.SpiritJarBlockEntity;
import com.sammy.malum.common.block.storage.pedestal.ItemPedestalBlock;
import com.sammy.malum.common.block.storage.pedestal.ItemPedestalBlockEntity;
import com.sammy.malum.common.block.storage.stand.ItemStandBlock;
import com.sammy.malum.common.block.storage.stand.ItemStandBlockEntity;
import com.sammy.malum.registry.common.block.BlockRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class BlockEntityRegistry {
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"malum");
    public static final RegistryObject<BlockEntityType<VoidConduitBlockEntity>> VOID_CONDUIT = BLOCK_ENTITY_TYPES.register("void_conduit", () -> BlockEntityType.Builder.m_155273_(VoidConduitBlockEntity::new, (Block[])new Block[]{(Block)BlockRegistry.VOID_CONDUIT.get()}).m_58966_(null));
    public static final RegistryObject<BlockEntityType<VoidDepotBlockEntity>> VOID_DEPOT = BLOCK_ENTITY_TYPES.register("void_depot", () -> BlockEntityType.Builder.m_155273_(VoidDepotBlockEntity::new, (Block[])new Block[]{(Block)BlockRegistry.VOID_DEPOT.get()}).m_58966_(null));
    public static final RegistryObject<BlockEntityType<SpiritAltarBlockEntity>> SPIRIT_ALTAR = BLOCK_ENTITY_TYPES.register("spirit_altar", () -> BlockEntityType.Builder.m_155273_(SpiritAltarBlockEntity::new, (Block[])new Block[]{(Block)BlockRegistry.SPIRIT_ALTAR.get()}).m_58966_(null));
    public static final RegistryObject<BlockEntityType<SpiritJarBlockEntity>> SPIRIT_JAR = BLOCK_ENTITY_TYPES.register("spirit_jar", () -> BlockEntityType.Builder.m_155273_(SpiritJarBlockEntity::new, (Block[])new Block[]{(Block)BlockRegistry.SPIRIT_JAR.get()}).m_58966_(null));
    public static final RegistryObject<BlockEntityType<RitualPlinthBlockEntity>> RITUAL_PLINTH = BLOCK_ENTITY_TYPES.register("ritual_plinth", () -> BlockEntityType.Builder.m_155273_(RitualPlinthBlockEntity::new, (Block[])new Block[]{(Block)BlockRegistry.RITUAL_PLINTH.get()}).m_58966_(null));
    public static final RegistryObject<BlockEntityType<WeaversWorkbenchBlockEntity>> WEAVERS_WORKBENCH = BLOCK_ENTITY_TYPES.register("weavers_workbench", () -> BlockEntityType.Builder.m_155273_(WeaversWorkbenchBlockEntity::new, (Block[])new Block[]{(Block)BlockRegistry.WEAVERS_WORKBENCH.get()}).m_58966_(null));
    public static final RegistryObject<BlockEntityType<RunicWorkbenchBlockEntity>> RUNIC_WORKBENCH = BLOCK_ENTITY_TYPES.register("runic_workbench", () -> BlockEntityType.Builder.m_155273_(RunicWorkbenchBlockEntity::new, (Block[])new Block[]{(Block)BlockRegistry.RUNIC_WORKBENCH.get()}).m_58966_(null));
    public static final RegistryObject<BlockEntityType<SpiritCrucibleCoreBlockEntity>> SPIRIT_CRUCIBLE = BLOCK_ENTITY_TYPES.register("spirit_crucible", () -> BlockEntityType.Builder.m_155273_(SpiritCrucibleCoreBlockEntity::new, (Block[])new Block[]{(Block)BlockRegistry.SPIRIT_CRUCIBLE.get()}).m_58966_(null));
    public static final RegistryObject<BlockEntityType<SpiritCatalyzerCoreBlockEntity>> SPIRIT_CATALYZER = BLOCK_ENTITY_TYPES.register("spirit_catalyzer", () -> BlockEntityType.Builder.m_155273_(SpiritCatalyzerCoreBlockEntity::new, (Block[])new Block[]{(Block)BlockRegistry.SPIRIT_CATALYZER.get()}).m_58966_(null));
    public static final RegistryObject<BlockEntityType<RepairPylonCoreBlockEntity>> REPAIR_PYLON = BLOCK_ENTITY_TYPES.register("repair_pylon", () -> BlockEntityType.Builder.m_155273_(RepairPylonCoreBlockEntity::new, (Block[])new Block[]{(Block)BlockRegistry.REPAIR_PYLON.get()}).m_58966_(null));
    public static final RegistryObject<BlockEntityType<RunewoodObeliskBlockEntity>> RUNEWOOD_OBELISK = BLOCK_ENTITY_TYPES.register("runewood_obelisk", () -> BlockEntityType.Builder.m_155273_(RunewoodObeliskBlockEntity::new, (Block[])new Block[]{(Block)BlockRegistry.RUNEWOOD_OBELISK.get()}).m_58966_(null));
    public static final RegistryObject<BlockEntityType<BrilliantObeliskBlockEntity>> BRILLIANT_OBELISK = BLOCK_ENTITY_TYPES.register("brilliant_obelisk", () -> BlockEntityType.Builder.m_155273_(BrilliantObeliskBlockEntity::new, (Block[])new Block[]{(Block)BlockRegistry.BRILLIANT_OBELISK.get()}).m_58966_(null));
    public static final RegistryObject<BlockEntityType<EtherBlockEntity>> ETHER = BLOCK_ENTITY_TYPES.register("ether", () -> BlockEntityType.Builder.m_155273_(EtherBlockEntity::new, (Block[])BlockEntityRegistry.getBlocks(EtherBlock.class)).m_58966_(null));
    public static final RegistryObject<BlockEntityType<ItemStandBlockEntity>> ITEM_STAND = BLOCK_ENTITY_TYPES.register("item_stand", () -> BlockEntityType.Builder.m_155273_(ItemStandBlockEntity::new, (Block[])BlockEntityRegistry.getBlocks(ItemStandBlock.class)).m_58966_(null));
    public static final RegistryObject<BlockEntityType<ItemPedestalBlockEntity>> ITEM_PEDESTAL = BLOCK_ENTITY_TYPES.register("item_pedestal", () -> BlockEntityType.Builder.m_155273_(ItemPedestalBlockEntity::new, (Block[])BlockEntityRegistry.getBlocks(ItemPedestalBlock.class)).m_58966_(null));
    public static final RegistryObject<BlockEntityType<TotemBaseBlockEntity>> TOTEM_BASE = BLOCK_ENTITY_TYPES.register("totem_base", () -> BlockEntityType.Builder.m_155273_(TotemBaseBlockEntity::new, (Block[])BlockEntityRegistry.getBlocks(TotemBaseBlock.class)).m_58966_(null));
    public static final RegistryObject<BlockEntityType<TotemPoleBlockEntity>> TOTEM_POLE = BLOCK_ENTITY_TYPES.register("totem_pole", () -> BlockEntityType.Builder.m_155273_(TotemPoleBlockEntity::new, (Block[])BlockEntityRegistry.getBlocks(TotemPoleBlock.class)).m_58966_(null));
    public static final RegistryObject<BlockEntityType<MoteOfManaBlockEntity>> SPIRIT_MOTE = BLOCK_ENTITY_TYPES.register("mote_of_mana", () -> BlockEntityType.Builder.m_155273_(MoteOfManaBlockEntity::new, (Block[])BlockEntityRegistry.getBlocks(SpiritMoteBlock.class)).m_58966_(null));

    public static Block[] getBlocks(Class<?> ... blockClasses) {
        Collection blocks = BlockRegistry.BLOCKS.getEntries();
        ArrayList<Block> matchingBlocks = new ArrayList<Block>();
        for (RegistryObject registryObject : blocks) {
            if (!registryObject.isPresent() || !Arrays.stream(blockClasses).anyMatch(b -> b.isInstance(registryObject.get()))) continue;
            matchingBlocks.add((Block)registryObject.get());
        }
        return matchingBlocks.toArray(new Block[0]);
    }

    public static Block[] getBlocksExact(Class<?> clazz) {
        Collection blocks = BlockRegistry.BLOCKS.getEntries();
        ArrayList<Block> matchingBlocks = new ArrayList<Block>();
        for (RegistryObject registryObject : blocks) {
            if (!clazz.equals(((Block)registryObject.get()).getClass())) continue;
            matchingBlocks.add((Block)registryObject.get());
        }
        return matchingBlocks.toArray(new Block[0]);
    }

    @Mod.EventBusSubscriber(modid="malum", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientOnly {
        @SubscribeEvent
        public static void registerRenderer(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer((BlockEntityType)VOID_CONDUIT.get(), VoidConduitRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)VOID_DEPOT.get(), VoidDepotRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)SPIRIT_ALTAR.get(), SpiritAltarRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RUNIC_WORKBENCH.get(), MalumItemHolderRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)SPIRIT_CRUCIBLE.get(), SpiritCrucibleRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)SPIRIT_CATALYZER.get(), SpiritCatalyzerRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)REPAIR_PYLON.get(), RepairPylonRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)TOTEM_BASE.get(), TotemBaseRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)TOTEM_POLE.get(), TotemPoleRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RITUAL_PLINTH.get(), RitualPlinthRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)ITEM_STAND.get(), MalumItemHolderRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)ITEM_PEDESTAL.get(), MalumItemHolderRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)SPIRIT_JAR.get(), SpiritJarRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)SPIRIT_MOTE.get(), MoteOfManaRenderer::new);
        }
    }
}

