/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import com.sammy.malum.common.block.curiosities.weeping_well.VoidConduitBlockEntity;
import com.sammy.malum.visual_effects.WeepingWellParticleEffects;
import com.sammy.malum.visual_effects.networked.data.PositionEffectData;
import java.awt.Color;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;
import team.lodestar.lodestone.helpers.DataHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.AbstractParticleBuilder;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;

public class RadiantParticleEffects {
    public static final List<Color> RADIANT_COLORS = List.of(new Color(179, 35, 218), new Color(224, 210, 68), new Color(42, 146, 218));

    public static void spitOutWeepingWellRadiance(Level level, PositionEffectData positionEffectData) {
        int i;
        double posX = positionEffectData.posX;
        double posY = positionEffectData.posY;
        double posZ = positionEffectData.posZ;
        Vec3 pos = new Vec3(posX, posY, posZ);
        RandomSource rand = level.f_46441_;
        Consumer<LodestoneWorldParticle> spawnBehavior = p -> p.tick(2);
        for (int i2 = 0; i2 < 64; ++i2) {
            Color color = RADIANT_COLORS.get(i2 % 12 / 4);
            ColorParticleData colorData = ColorParticleData.create((Color)color.brighter(), (Color)color).setCoefficient(0.5f).build();
            float xVelocity = RandomHelper.randomBetween((RandomSource)rand, (float)0.0f, (float)0.15f) * (float)(rand.m_188499_() ? 1 : -1);
            float yVelocity = RandomHelper.randomBetween((RandomSource)rand, (float)0.5f, (float)1.0f);
            float zVelocity = RandomHelper.randomBetween((RandomSource)rand, (float)0.0f, (float)0.15f) * (float)(rand.m_188499_() ? 1 : -1);
            float gravityStrength = RandomHelper.randomBetween((RandomSource)rand, (float)0.75f, (float)1.0f);
            if (rand.m_188501_() < 0.85f) {
                ParticleEffectSpawner sparkParticles = WeepingWellParticleEffects.weepingWellSparks(level, pos, colorData, LodestoneWorldParticleRenderType.ADDITIVE);
                sparkParticles.getBuilder().addSpawnActor(spawnBehavior).disableNoClip().setGravityStrength(gravityStrength / 2.0f).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(2.0f)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.5f));
                sparkParticles.getBloomBuilder().addSpawnActor(spawnBehavior).disableNoClip().setGravityStrength(gravityStrength / 2.0f).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(1.25f));
                sparkParticles.spawnParticles();
            }
            if (!(rand.m_188501_() < 0.85f)) continue;
            ParticleEffectSpawner lightSpecs = WeepingWellParticleEffects.weepingWellSpecs(level, pos, colorData, LodestoneWorldParticleRenderType.ADDITIVE);
            lightSpecs.getBuilder().addSpawnActor(spawnBehavior).disableNoClip().setGravityStrength(gravityStrength).setMotion((double)(xVelocity *= 1.25f), (double)(yVelocity *= 0.75f), (double)(zVelocity *= 1.25f)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.5f));
            lightSpecs.getBloomBuilder().addSpawnActor(spawnBehavior).disableNoClip().setGravityStrength(gravityStrength).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(1.25f));
            lightSpecs.spawnParticles();
        }
        int spinOffset = rand.m_188503_(360);
        for (i = 0; i < 3; ++i) {
            int lifeDelay = 4 * i;
            Color color = RADIANT_COLORS.get((int)((level.m_46467_() % 3L + (long)i) % 3L));
            ColorParticleData colorData = ColorParticleData.create((Color)color.brighter(), (Color)color).setCoefficient(0.5f).build();
            int spinDirection = rand.m_188499_() ? 1 : -1;
            WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.SPARKLE_PARTICLE).setTransparencyData(GenericParticleData.create((float)0.1f, (float)0.4f, (float)0.0f).setEasing(Easing.QUAD_IN, Easing.CIRC_IN).build()).setSpinData(SpinParticleData.create((float)((0.05f + rand.m_188501_() * 0.025f) * (float)spinDirection)).setSpinOffset((float)spinOffset).build()).setScaleData(GenericParticleData.create((float)3.0f, (float)5.0f, (float)0.6f).setEasing(Easing.QUARTIC_OUT, Easing.SINE_IN).build()).setColorData(colorData).setLifeDelay(lifeDelay).setLifetime(25 + lifeDelay).setRandomOffset((double)0.6f).enableNoClip().setRandomMotion((double)0.02f, (double)0.02f).setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE).repeat(level, posX, posY + 0.25, posZ, 5);
        }
        for (i = 0; i < 27; ++i) {
            int finalI = 4 + i;
            Color color = RADIANT_COLORS.get((int)(level.m_46467_() - 27L + (long)i) % 27 / 9);
            ColorParticleData colorData = ColorParticleData.create((Color)color.brighter(), (Color)color).setCoefficient(0.5f).build();
            ParticleEffectSpawner squares = WeepingWellParticleEffects.weepingWellSquare(level, pos, colorData);
            squares.getBuilder().addSpawnActor(p -> p.tick(finalI));
            squares.spawnParticles();
        }
    }

    public static void radiantWeepingWellParticles(VoidConduitBlockEntity voidConduit) {
        Level level = voidConduit.m_58904_();
        RandomSource rand = level.f_46441_;
        Color color = RADIANT_COLORS.get((int)level.m_46467_() % 27 / 9);
        BlockPos blockPos = voidConduit.m_58899_();
        ColorParticleData colorData = ColorParticleData.create((Color)color.brighter(), (Color)color).setCoefficient(0.5f).build();
        if (level.m_46467_() % 3L == 0L) {
            WeepingWellParticleEffects.weepingWellSquare(level, new Vec3((double)((float)blockPos.m_123341_() + 0.5f), (double)((float)blockPos.m_123342_() + 0.75f), (double)((float)blockPos.m_123343_() + 0.5f)), colorData).spawnParticles();
        }
        float acceleration = RandomHelper.randomBetween((RandomSource)rand, (float)0.002f, (float)0.02f);
        long gameTime = level.m_46467_();
        Consumer<LodestoneWorldParticle> behavior = p -> {
            if (level.m_46467_() < gameTime + 5L) {
                p.setParticleSpeed(p.getParticleSpeed().m_82520_(0.0, (double)acceleration, 0.0));
            }
        };
        if (level.m_46467_() % 2L == 0L) {
            int rotation = (int)((float)level.m_46467_() / 2.0f % 16.0f);
            Vec3 offsetPosition = DataHelper.rotatingRadialOffset((Vec3)new Vec3((double)((float)blockPos.m_123341_() + 0.5f), (double)((float)blockPos.m_123342_() + 0.75f), (double)((float)blockPos.m_123343_() + 0.5f)), (float)1.1f, (float)rotation, (float)16.0f, (long)voidConduit.m_58904_().m_46467_(), (float)640.0f);
            ParticleEffectSpawner lightSpecs = WeepingWellParticleEffects.weepingWellSpecs(level, offsetPosition, colorData, LodestoneWorldParticleRenderType.ADDITIVE);
            lightSpecs.getBuilder().addTickActor(behavior);
            lightSpecs.getBloomBuilder().addTickActor(behavior);
            lightSpecs.spawnParticles();
        }
    }
}

