/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import com.sammy.malum.client.SpiritBasedParticleBuilder;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.client.ParticleRegistry;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.LodestoneBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.SparkBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.options.WorldParticleOptions;

public class SparkParticleEffects {
    public static ParticleEffectSpawner spiritMotionSparks(Level level, Vec3 pos, MalumSpiritType spiritType) {
        return SparkParticleEffects.spiritMotionSparks(level, pos, spiritType, new WorldParticleOptions(ParticleRegistry.ROUND_SPARK));
    }

    public static ParticleEffectSpawner spiritMotionSparks(Level level, Vec3 pos, ColorParticleData colorData) {
        return SparkParticleEffects.spiritMotionSparks(level, pos, colorData, new WorldParticleOptions(ParticleRegistry.ROUND_SPARK));
    }

    public static ParticleEffectSpawner spiritMotionSparks(Level level, Vec3 pos, MalumSpiritType spiritType, WorldParticleOptions options) {
        return SparkParticleEffects.spiritMotionSparks(level, pos, options, (WorldParticleOptions o) -> SpiritBasedParticleBuilder.createSpirit(o).setSpirit(spiritType));
    }

    public static ParticleEffectSpawner spiritMotionSparks(Level level, Vec3 pos, ColorParticleData colorData, WorldParticleOptions options) {
        return SparkParticleEffects.spiritMotionSparks(level, pos, options, (WorldParticleOptions o) -> WorldParticleBuilder.create((WorldParticleOptions)o).setColorData(colorData));
    }

    public static ParticleEffectSpawner spiritMotionSparks(Level level, Vec3 pos, WorldParticleOptions options, Function<WorldParticleOptions, WorldParticleBuilder> builderSupplier) {
        GenericParticleData lengthData = GenericParticleData.create((float)0.1f, (float)0.2f, (float)0.0f).setEasing(Easing.SINE_IN, Easing.SINE_IN_OUT).build();
        WorldParticleBuilder builder = builderSupplier.apply(options.setBehaviorIfDefault((LodestoneBehaviorComponent)new SparkBehaviorComponent(lengthData)));
        WorldParticleBuilder bloomBuilder = builderSupplier.apply(new WorldParticleOptions(LodestoneParticleRegistry.WISP_PARTICLE));
        return SparkParticleEffects.spiritMotionSparks(level, pos, builder, bloomBuilder);
    }

    public static ParticleEffectSpawner spiritMotionSparks(Level level, Vec3 pos, WorldParticleBuilder builder, WorldParticleBuilder bloomBuilder) {
        RandomSource rand = level.m_213780_();
        SpinParticleData spinData = SpinParticleData.createRandomDirection((RandomSource)rand, (float)Mth.m_216267_((RandomSource)rand, (float)0.05f, (float)0.1f)).randomSpinOffset(rand).build();
        Consumer<LodestoneWorldParticle> slowDown = p -> p.setParticleSpeed(p.getParticleSpeed().m_82490_((double)0.95f));
        int lifetime = RandomHelper.randomBetween((RandomSource)rand, (int)10, (int)20);
        WorldParticleBuilder sparkParticleBuilder = builder.setTransparencyData(GenericParticleData.create((float)0.8f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)0.1f, (float)RandomHelper.randomBetween((RandomSource)rand, (float)0.2f, (float)0.3f), (float)0.0f).build()).setLifetime(lifetime).enableNoClip().addTickActor(slowDown);
        WorldParticleBuilder bloomParticleBuilder = SpiritLightSpecs.spiritBloom(level, bloomBuilder, lifetime).setSpinData(spinData).addTickActor(slowDown);
        return new ParticleEffectSpawner(level, pos, sparkParticleBuilder, bloomParticleBuilder);
    }
}

