/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import com.sammy.malum.common.block.curiosities.obelisk.runewood.RunewoodObeliskBlockEntity;
import com.sammy.malum.common.block.curiosities.spirit_altar.IAltarAccelerator;
import com.sammy.malum.common.block.curiosities.spirit_altar.SpiritAltarBlockEntity;
import com.sammy.malum.common.block.storage.IMalumSpecialItemAccessPoint;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.common.recipe.SpiritInfusionRecipe;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.visual_effects.ItemCrumbleParticleEffects;
import com.sammy.malum.visual_effects.SparkParticleEffects;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.data.ColorEffectData;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.DataHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntityInventory;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.builder.AbstractParticleBuilder;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;

public class SpiritAltarParticleEffects {
    public static MalumSpiritType getCentralSpiritType(SpiritAltarBlockEntity altar) {
        LodestoneBlockEntityInventory spiritInventory = altar.spiritInventory;
        int spiritCount = spiritInventory.nonEmptyItemAmount;
        Item currentItem = spiritInventory.getStackInSlot(0).m_41720_();
        if (spiritCount > 1) {
            float duration = 30.0f * (float)spiritCount;
            float gameTime = (float)altar.m_58904_().m_46467_() % duration / 30.0f;
            currentItem = spiritInventory.getStackInSlot(Mth.m_14143_((float)gameTime)).m_41720_();
        }
        if (!(currentItem instanceof SpiritShardItem)) {
            return null;
        }
        SpiritShardItem spiritItem = (SpiritShardItem)currentItem;
        return spiritItem.type;
    }

    public static void passiveSpiritAltarParticles(SpiritAltarBlockEntity altar) {
        MalumSpiritType activeSpiritType = SpiritAltarParticleEffects.getCentralSpiritType(altar);
        if (activeSpiritType == null) {
            return;
        }
        Level level = altar.m_58904_();
        RandomSource random = level.f_46441_;
        Vec3 itemPos = altar.getItemPos();
        LodestoneBlockEntityInventory spiritInventory = altar.spiritInventory;
        SpiritInfusionRecipe recipe = altar.recipe;
        if (recipe != null) {
            for (IAltarAccelerator accelerator : altar.accelerators) {
                if (accelerator == null) continue;
                accelerator.addParticles(altar, activeSpiritType);
            }
            SpiritLightSpecs.rotatingLightSpecs(level, itemPos, activeSpiritType, 0.5f, 3, b -> b.multiplyLifetime(1.2f).modifyData(() -> ((WorldParticleBuilder)b).getScaleData(), d -> d.multiplyValue(1.2f)));
        }
        int spiritsRendered = 0;
        for (int i = 0; i < spiritInventory.slotCount; ++i) {
            ItemStack item = spiritInventory.getStackInSlot(i);
            Item item2 = item.m_41720_();
            if (!(item2 instanceof SpiritShardItem)) continue;
            SpiritShardItem spiritSplinterItem = (SpiritShardItem)item2;
            Vec3 offset = altar.getSpiritItemOffset(spiritsRendered++, 0.0f);
            activeSpiritType = spiritSplinterItem.type;
            BlockPos blockPos = altar.m_58899_();
            Vec3 spiritPosition = new Vec3((double)blockPos.m_123341_() + offset.f_82479_, (double)blockPos.m_123342_() + offset.f_82480_, (double)blockPos.m_123343_() + offset.f_82481_);
            SpiritLightSpecs.spiritLightSpecs(level, spiritPosition, activeSpiritType).spawnParticles();
            if (recipe == null) continue;
            Vec3 velocity = itemPos.m_82546_(spiritPosition).m_82541_().m_82490_((double)RandomHelper.randomBetween((RandomSource)random, (float)0.03f, (float)0.06f));
            if (random.m_188501_() < 0.85f) {
                ParticleEffectSpawner sparkParticles = SparkParticleEffects.spiritMotionSparks(level, spiritPosition, activeSpiritType);
                sparkParticles.getBuilder().setMotion(velocity).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.2f));
                sparkParticles.getBloomBuilder().setMotion(velocity);
                sparkParticles.spawnParticles();
            }
            if (!(random.m_188501_() < 0.85f)) continue;
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, spiritPosition, activeSpiritType);
            lightSpecs.getBuilder().multiplyLifetime(0.8f).setMotion(velocity.m_82490_(1.5)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.6f));
            lightSpecs.getBloomBuilder().setMotion(velocity);
            lightSpecs.spawnParticles();
        }
    }

    public static void eatItemParticles(SpiritAltarBlockEntity altar, IMalumSpecialItemAccessPoint holder, ColorEffectData colorData, ItemStack stack) {
        int i;
        MalumSpiritType activeSpiritType = SpiritAltarParticleEffects.getCentralSpiritType(altar);
        if (activeSpiritType == null) {
            return;
        }
        Level level = altar.m_58904_();
        long gameTime = level.m_46467_();
        RandomSource random = level.f_46441_;
        Vec3 altarTargetPos = altar.getItemPos();
        Vec3 holderTargetPos = holder.getItemPos();
        for (i = 0; i < 2; ++i) {
            SpiritLightSpecs.coolLookingShinyThing(level, holderTargetPos, activeSpiritType);
        }
        for (i = 0; i < 16; ++i) {
            MalumSpiritType cyclingSpiritType = colorData.getCyclingColorRecord().spiritType();
            Vec3 velocity = altarTargetPos.m_82546_(holderTargetPos).m_82541_().m_82490_((double)0.025f);
            int finalI = i;
            Vec3 offsetPosition = DataHelper.rotatingRadialOffset((Vec3)holderTargetPos, (float)0.5f, (float)i, (float)16.0f, (long)gameTime, (float)160.0f);
            Consumer<LodestoneWorldParticle> behavior = p -> {
                if (level.m_46467_() > gameTime + (long)(finalI * 2) && level.m_46467_() < gameTime + (long)((finalI + 4) * 2)) {
                    p.setParticleSpeed(p.getParticleSpeed().m_82549_(velocity));
                }
            };
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, cyclingSpiritType);
            lightSpecs.getBuilder().act(b -> b.addTickActor(behavior).multiplyLifetime(2.5f).modifyData(() -> ((WorldParticleBuilder)b).getScaleData(), d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)1.0f, (float)2.0f))));
            lightSpecs.getBloomBuilder().act(b -> b.addTickActor(behavior).multiplyLifetime(2.0f).modifyData(() -> ((WorldParticleBuilder)b).getScaleData(), d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)0.6f, (float)1.5f))));
            lightSpecs.spawnParticles();
            ParticleEffectSpawner crumbles = ItemCrumbleParticleEffects.spawnItemCrumbs(level, holderTargetPos, stack);
            crumbles.getBuilder().setLifeDelay(i).addTickActor(behavior);
            crumbles.spawnParticles();
            crumbles.getBuilder().setRandomOffset((double)0.2f);
            crumbles.spawnParticles();
        }
    }

    public static void craftItemParticles(SpiritAltarBlockEntity altar, ColorEffectData colorData) {
        int i;
        MalumSpiritType activeSpiritType = SpiritAltarParticleEffects.getCentralSpiritType(altar);
        if (activeSpiritType == null) {
            return;
        }
        Level level = altar.m_58904_();
        long gameTime = level.m_46467_();
        RandomSource random = level.f_46441_;
        BlockPos altarPos = altar.m_58899_();
        Vec3 targetPos = altar.getCentralItemOffset().m_82520_((double)altarPos.m_123341_(), (double)altarPos.m_123342_(), (double)altarPos.m_123343_());
        for (i = 0; i < 2; ++i) {
            SpiritLightSpecs.coolLookingShinyThing(level, targetPos, activeSpiritType);
        }
        for (i = 0; i < 24; ++i) {
            int lifeDelay = i / 8;
            MalumSpiritType cyclingSpiritType = colorData.getCyclingColorRecord().spiritType();
            float xVelocity = RandomHelper.randomBetween((RandomSource)random, (Easing)Easing.CUBIC_OUT, (float)-0.075f, (float)0.075f);
            float yVelocity = RandomHelper.randomBetween((RandomSource)random, (float)0.2f, (float)0.5f);
            float zVelocity = RandomHelper.randomBetween((RandomSource)random, (Easing)Easing.CUBIC_OUT, (float)-0.075f, (float)0.075f);
            float gravityStrength = RandomHelper.randomBetween((RandomSource)random, (float)0.75f, (float)1.0f);
            if (random.m_188501_() < 0.85f) {
                ParticleEffectSpawner sparkParticles = SparkParticleEffects.spiritMotionSparks(level, targetPos, cyclingSpiritType);
                sparkParticles.getBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(2.0f).setGravityStrength(gravityStrength).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(2.0f));
                sparkParticles.getBloomBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(2.0f).setGravityStrength(gravityStrength).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(1.25f));
                sparkParticles.spawnParticles();
            }
            if (!(random.m_188501_() < 0.85f)) continue;
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, targetPos, cyclingSpiritType);
            lightSpecs.getBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(4.0f).setGravityStrength(gravityStrength).setMotion((double)(xVelocity *= 1.25f), (double)(yVelocity *= 0.75f), (double)(zVelocity *= 1.25f)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(2.5f));
            lightSpecs.getBloomBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(4.0f).setGravityStrength(gravityStrength).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(1.25f));
            lightSpecs.spawnParticles();
        }
        for (i = 0; i < 8; ++i) {
            int finalI = i;
            Vec3 offsetPosition = DataHelper.rotatingRadialOffset((Vec3)targetPos, (float)0.6f, (float)i, (float)8.0f, (long)gameTime, (float)160.0f);
            Consumer<WorldParticleBuilder> behavior = b -> b.addTickActor(p -> {
                if (level.m_46467_() > gameTime + (long)(finalI * 4) && level.m_46467_() < gameTime + (long)((finalI + 4) * 4)) {
                    p.setParticleSpeed(p.getParticleSpeed().m_82520_(0.0, (double)0.015f, 0.0));
                }
            });
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, activeSpiritType);
            lightSpecs.getBuilder().act(b -> b.act(behavior).modifyColorData(d -> d.multiplyCoefficient(0.35f)).modifyData(() -> ((WorldParticleBuilder)b).getScaleData(), d -> d.multiplyValue(2.0f).multiplyCoefficient(0.9f)).modifyData(() -> ((WorldParticleBuilder)b).getTransparencyData(), d -> d.multiplyCoefficient(0.9f)).multiplyLifetime(1.5f).setLifetime((Integer)b.getParticleOptions().lifetimeSupplier.get() + finalI * 2));
            lightSpecs.getBloomBuilder().act(b -> b.act(behavior).modifyColorData(d -> d.multiplyCoefficient(0.35f)).modifyData(() -> ((WorldParticleBuilder)b).getScaleData(), d -> d.multiplyValue(1.6f).multiplyCoefficient(0.9f)).modifyData(() -> ((WorldParticleBuilder)b).getTransparencyData(), d -> d.multiplyCoefficient(0.9f)).setLifetime((int)((float)((Integer)b.getParticleOptions().lifetimeSupplier.get()).intValue() + (float)finalI * 2.5f)));
            lightSpecs.spawnParticles();
        }
    }

    public static void runewoodObeliskParticles(RunewoodObeliskBlockEntity obelisk, SpiritAltarBlockEntity altar, MalumSpiritType spiritType) {
        Level level = obelisk.m_58904_();
        BlockPos obeliskPos = obelisk.m_58899_();
        Vec3 startPos = obelisk.getParticleOffset().m_82520_((double)obeliskPos.m_123341_(), (double)obeliskPos.m_123342_(), (double)obeliskPos.m_123343_());
        SpiritLightSpecs.spiritLightSpecs(level, startPos, spiritType).spawnParticles();
        if (level.m_46467_() % 2L == 0L) {
            RandomSource random = level.f_46441_;
            long gameTime = level.m_46467_();
            BlockPos altarPos = altar.m_58899_();
            Vec3 targetPos = altar.getCentralItemOffset().m_82520_((double)altarPos.m_123341_(), (double)altarPos.m_123342_(), (double)altarPos.m_123343_());
            Vec3 velocity = targetPos.m_82546_(startPos).m_82541_().m_82490_((double)RandomHelper.randomBetween((RandomSource)random, (float)0.01f, (float)0.02f));
            double yOffset = Math.sin((float)(gameTime % 360L) / 30.0f) * (double)0.1f;
            Vec3 offsetPosition = DataHelper.rotatingRadialOffset((Vec3)startPos.m_82520_(0.0, yOffset, 0.0), (float)0.45f, (float)0.0f, (float)1.0f, (long)gameTime, (float)30.0f);
            Consumer<WorldParticleBuilder> behavior = b -> b.addTickActor(p -> {
                if (gameTime % 6L == 0L) {
                    p.setParticleSpeed(p.getParticleSpeed().m_82490_((double)1.05f));
                }
            });
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, spiritType);
            lightSpecs.getBuilder().act(b -> b.act(behavior).setMotion(velocity).multiplyLifetime(2.0f).modifyData(() -> ((WorldParticleBuilder)b).getScaleData(), d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)1.0f, (float)2.0f))));
            lightSpecs.getBloomBuilder().act(b -> b.act(behavior).setMotion(velocity).multiplyLifetime(1.5f).modifyData(() -> ((WorldParticleBuilder)b).getScaleData(), d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)0.6f, (float)1.5f))));
            lightSpecs.spawnParticles();
        }
    }
}

