/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects.networked;

import com.sammy.malum.common.packets.ParticleEffectPacket;
import com.sammy.malum.registry.common.PacketRegistry;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.visual_effects.networked.data.ColorEffectData;
import com.sammy.malum.visual_effects.networked.data.NBTEffectData;
import com.sammy.malum.visual_effects.networked.data.PositionEffectData;
import java.util.function.Supplier;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

public abstract class ParticleEffectType {
    public final String id;

    public ParticleEffectType(String id) {
        this.id = id;
        ParticleEffectTypeRegistry.EFFECT_TYPES.put(id, this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract Supplier<ParticleEffectActor> get();

    public void createEntityEffect(Entity entity) {
        this.createEntityEffect(entity, null);
    }

    public void createEntityEffect(Entity entity, ColorEffectData colorData) {
        this.createEntityEffect(entity, colorData, null);
    }

    public void createEntityEffect(Entity entity, ColorEffectData colorData, NBTEffectData nbtData) {
        this.createEffect(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), new PositionEffectData(entity), colorData, nbtData);
    }

    public void createPositionedEffect(Level level, PositionEffectData positionData) {
        this.createPositionedEffect(level, positionData, null, null);
    }

    public void createPositionedEffect(Level level, PositionEffectData positionData, NBTEffectData nbtData) {
        this.createPositionedEffect(level, positionData, null, nbtData);
    }

    public void createPositionedEffect(Level level, PositionEffectData positionData, ColorEffectData colorData) {
        this.createPositionedEffect(level, positionData, colorData, null);
    }

    public void createPositionedEffect(Level level, PositionEffectData positionData, ColorEffectData colorData, NBTEffectData nbtData) {
        this.createEffect(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(positionData.getAsBlockPos())), positionData, colorData, nbtData);
    }

    public void createEffect(PacketDistributor.PacketTarget target, PositionEffectData positionData, ColorEffectData colorData, NBTEffectData nbtData) {
        PacketRegistry.MALUM_CHANNEL.send(target, (Object)new ParticleEffectPacket(this.id, positionData, colorData, nbtData));
    }

    public static interface ParticleEffectActor {
        public void act(Level var1, RandomSource var2, PositionEffectData var3, ColorEffectData var4, NBTEffectData var5);
    }
}

