/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects.networked.generic;

import com.sammy.malum.visual_effects.networked.ParticleEffectType;
import com.sammy.malum.visual_effects.networked.data.ColorEffectData;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.RegistryObject;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;

public class HexingSmokeParticleEffect
extends ParticleEffectType {
    public final float intensity;

    public HexingSmokeParticleEffect(String id, float intensity) {
        super(id);
        this.intensity = intensity;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Supplier<ParticleEffectType.ParticleEffectActor> get() {
        return () -> (level, random, positionData, colorData, nbtData) -> {
            ColorEffectData.ColorRecord colorRecord = colorData.getDefaultColorRecord();
            Color primaryColor = colorData.getPrimaryColor(colorRecord);
            Color secondaryColor = colorData.getSecondaryColor(colorRecord);
            double posX = positionData.posX;
            double posY = positionData.posY;
            double posZ = positionData.posZ;
            int adjustedLifespan = (int)(20.0f * this.intensity * 0.6f);
            for (int i = 0; i <= 3; ++i) {
                int spinDirection = random.m_188499_() ? 1 : -1;
                WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.WISP_PARTICLE).setTransparencyData(GenericParticleData.create((float)0.05f, (float)0.1f, (float)0.0f).build()).setSpinData(SpinParticleData.create((float)(0.025f * (float)spinDirection), (float)((0.2f + random.m_188501_() * 0.05f) * (float)spinDirection), (float)0.0f).setEasing(Easing.QUINTIC_OUT, Easing.SINE_IN).build()).setScaleData(GenericParticleData.create((float)0.025f, (float)(0.1f + random.m_188501_() * 0.075f), (float)0.35f).setEasing(Easing.QUINTIC_OUT, Easing.SINE_IN).build()).setColorData(ColorParticleData.create((Color)primaryColor, (Color)secondaryColor).build()).setLifetime((int)((float)adjustedLifespan * Mth.m_216267_((RandomSource)random, (float)0.9f, (float)1.2f))).enableNoClip().setRandomOffset((double)0.2f, (double)0.2f).setRandomMotion((double)0.02f).addTickActor(p -> p.setParticleSpeed(p.getParticleSpeed().m_82490_((double)0.95f))).repeat(level, posX, posY, posZ, (int)(4.0f * this.intensity));
            }
            WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.WISP_PARTICLE).setTransparencyData(GenericParticleData.create((float)0.02f, (float)0.05f, (float)0.0f).build()).setSpinData(SpinParticleData.create((float)0.1f, (float)0.4f, (float)0.0f).setEasing(Easing.QUINTIC_OUT, Easing.SINE_IN).build()).setScaleData(GenericParticleData.create((float)0.15f, (float)0.4f, (float)0.35f).setEasing(Easing.QUINTIC_OUT, Easing.SINE_IN).build()).setColorData(ColorParticleData.create((Color)primaryColor, (Color)secondaryColor).build()).setLifetime((int)((float)adjustedLifespan * Mth.m_216267_((RandomSource)random, (float)0.65f, (float)0.85f))).enableNoClip().setRandomOffset((double)0.05f, (double)0.05f).setRandomMotion((double)0.05f).addTickActor(p -> p.setParticleSpeed(p.getParticleSpeed().m_82490_(0.5))).repeat(level, posX, posY, posZ, (int)(6.0f * this.intensity));
            WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.SMOKE_PARTICLE).setTransparencyData(GenericParticleData.create((float)0.0f, (float)0.05f, (float)0.0f).build()).setSpinData(SpinParticleData.create((float)0.1f, (float)0.25f, (float)0.0f).setEasing(Easing.QUINTIC_OUT, Easing.SINE_IN).build()).setScaleData(GenericParticleData.create((float)0.15f, (float)0.45f, (float)0.35f).setEasing(Easing.QUINTIC_OUT, Easing.SINE_IN).build()).setColorData(ColorParticleData.create((Color)primaryColor.darker(), (Color)ColorHelper.darker((Color)secondaryColor, (int)3)).build()).setLifetime((int)((float)adjustedLifespan * Mth.m_216267_((RandomSource)random, (float)0.9f, (float)1.2f))).enableNoClip().setRandomOffset((double)0.15f, (double)0.15f).setRandomMotion((double)0.015f, (double)0.015f).addTickActor(p -> p.setParticleSpeed(p.getParticleSpeed().m_82490_((double)0.92f))).repeat(level, posX, posY, posZ, (int)(10.0f * this.intensity));
        };
    }
}

