/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects.networked.slash;

import com.sammy.malum.client.PointyDirectionalBehaviorComponent;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.SpiritTypeRegistry;
import com.sammy.malum.visual_effects.SlashParticleEffects;
import com.sammy.malum.visual_effects.networked.ParticleEffectType;
import com.sammy.malum.visual_effects.networked.data.NBTEffectData;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.LodestoneBehaviorComponent;

public class SlashAttackParticleEffect
extends ParticleEffectType {
    public SlashAttackParticleEffect(String id) {
        super(id);
    }

    public static NBTEffectData createData(Vec3 direction, boolean mirror, float angle) {
        return SlashAttackParticleEffect.createData(direction, mirror, angle, null);
    }

    public static NBTEffectData createData(Vec3 direction, boolean mirror, float angle, MalumSpiritType spiritType) {
        CompoundTag tag = new CompoundTag();
        CompoundTag directionTag = new CompoundTag();
        directionTag.m_128347_("x", direction.f_82479_);
        directionTag.m_128347_("y", direction.f_82480_);
        directionTag.m_128347_("z", direction.f_82481_);
        tag.m_128350_("angle", angle);
        tag.m_128379_("mirror", mirror);
        if (spiritType != null) {
            tag.m_128359_("spiritType", spiritType.identifier);
        }
        tag.m_128365_("direction", (Tag)directionTag);
        return new NBTEffectData(tag);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Supplier<ParticleEffectType.ParticleEffectActor> get() {
        return () -> (level, random, positionData, colorData, nbtData) -> {
            if (!nbtData.compoundTag.m_128441_("direction")) {
                return;
            }
            CompoundTag directionData = nbtData.compoundTag.m_128469_("direction");
            double dirX = directionData.m_128459_("x");
            double dirY = directionData.m_128459_("y");
            double dirZ = directionData.m_128459_("z");
            Vec3 direction = new Vec3(dirX, dirY, dirZ);
            float angle = nbtData.compoundTag.m_128457_("angle");
            boolean mirror = nbtData.compoundTag.m_128471_("mirror");
            MalumSpiritType spirit = this.getSpiritType(nbtData);
            float spinOffset = angle + RandomHelper.randomBetween((RandomSource)random, (float)-0.5f, (float)0.5f) + (mirror ? 3.14f : 0.0f);
            ParticleEffectSpawner slash = SlashParticleEffects.spawnSlashParticle(level, positionData.getAsVector(), spirit);
            slash.getBuilder().setSpinData(SpinParticleData.create((float)0.0f).setSpinOffset(spinOffset).build()).setScaleData(GenericParticleData.create((float)RandomHelper.randomBetween((RandomSource)random, (float)2.0f, (float)3.0f)).build()).setMotion(direction.m_82490_((double)RandomHelper.randomBetween((RandomSource)random, (float)0.3f, (float)0.4f))).setBehavior((LodestoneBehaviorComponent)new PointyDirectionalBehaviorComponent(direction));
            slash.spawnParticles();
        };
    }

    public MalumSpiritType getSpiritType(NBTEffectData data) {
        return SpiritTypeRegistry.SPIRITS.get(data.compoundTag.m_128461_("spiritType"));
    }
}

