/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects.networked.slash;

import com.sammy.malum.client.PointyDirectionalBehaviorComponent;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.visual_effects.SlashParticleEffects;
import com.sammy.malum.visual_effects.networked.ParticleEffectType;
import com.sammy.malum.visual_effects.networked.slash.SlashAttackParticleEffect;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.LodestoneBehaviorComponent;

public class WeightOfWorldsCritParticleEffect
extends SlashAttackParticleEffect {
    public WeightOfWorldsCritParticleEffect(String id) {
        super(id);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Supplier<ParticleEffectType.ParticleEffectActor> get() {
        return () -> (level, random, positionData, colorData, nbtData) -> {
            if (!nbtData.compoundTag.m_128441_("direction")) {
                return;
            }
            CompoundTag directionData = nbtData.compoundTag.m_128469_("direction");
            double dirX = directionData.m_128459_("x");
            double dirY = directionData.m_128459_("y");
            double dirZ = directionData.m_128459_("z");
            Vec3 direction = new Vec3(dirX, dirY, dirZ);
            float angle = nbtData.compoundTag.m_128457_("angle");
            boolean mirror = nbtData.compoundTag.m_128471_("mirror");
            MalumSpiritType spirit = this.getSpiritType(nbtData);
            float spinOffset = 0.0f;
            for (int i = 0; i < 8; ++i) {
                if (i % 2 == 0) {
                    spinOffset = angle + RandomHelper.randomBetween((RandomSource)random, (float)-0.5f, (float)0.5f) + (mirror ? 3.14f : 0.0f);
                }
                ParticleEffectSpawner slash = SlashParticleEffects.spawnSlashParticle(level, positionData.getAsVector(), spirit);
                slash.getBuilder().setSpinData(SpinParticleData.create((float)0.0f).setSpinOffset(spinOffset).build()).setScaleData(GenericParticleData.create((float)RandomHelper.randomBetween((RandomSource)random, (float)3.0f, (float)4.0f)).build()).setMotion(direction.m_82490_((double)RandomHelper.randomBetween((RandomSource)random, (float)0.3f, (float)0.4f))).setBehavior((LodestoneBehaviorComponent)new PointyDirectionalBehaviorComponent(direction));
                slash.spawnParticles();
            }
        };
    }
}

