/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects.networked.staff;

import com.sammy.malum.common.item.curiosities.weapons.staff.AuricFlameStaffItem;
import com.sammy.malum.visual_effects.SparkParticleEffects;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.ParticleEffectType;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.builder.AbstractParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.SparkBehaviorComponent;

public class AuricBoltImpactParticleEffect
extends ParticleEffectType {
    public AuricBoltImpactParticleEffect(String id) {
        super(id);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Supplier<ParticleEffectType.ParticleEffectActor> get() {
        return () -> (level, random, positionData, colorData, nbtData) -> {
            if (!nbtData.compoundTag.m_128441_("direction")) {
                return;
            }
            ColorParticleData colorParticleData = AuricFlameStaffItem.AURIC_COLOR_DATA;
            CompoundTag directionData = nbtData.compoundTag.m_128469_("direction");
            double dirX = directionData.m_128459_("x");
            double dirY = directionData.m_128459_("y");
            double dirZ = directionData.m_128459_("z");
            Vec3 projectileDirection = new Vec3(dirX, dirY, dirZ);
            float yRot = (float)(Mth.m_14136_((double)projectileDirection.f_82479_, (double)projectileDirection.f_82481_) * 57.2957763671875);
            float yaw = (float)Math.toRadians(yRot);
            Vec3 left = new Vec3(-Math.cos(yaw), 0.0, Math.sin(yaw));
            Vec3 up = left.m_82537_(projectileDirection);
            double posX = positionData.posX;
            double posY = positionData.posY;
            double posZ = positionData.posZ;
            Vec3 pos = new Vec3(posX, posY, posZ);
            for (int i = 0; i < 32; ++i) {
                float spread = RandomHelper.randomBetween((RandomSource)random, (float)0.05f, (float)0.075f);
                float speed = RandomHelper.randomBetween((RandomSource)random, (float)0.4f, (float)0.6f);
                float distance = RandomHelper.randomBetween((RandomSource)random, (float)4.0f, (float)12.0f);
                float angle = (float)i / 32.0f * (float)Math.PI * 2.0f;
                Vec3 direction = projectileDirection.m_82549_(left.m_82490_(Math.sin(angle) * (double)spread)).m_82549_(up.m_82490_(Math.cos(angle) * (double)spread)).m_82541_().m_82490_((double)speed);
                Vec3 spawnPosition = pos.m_82549_(direction.m_82490_((double)distance));
                direction = direction.m_82548_();
                float lifetimeMultiplier = 0.7f;
                if (random.m_188501_() < 0.8f) {
                    ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, spawnPosition, colorParticleData);
                    lightSpecs.getBuilder().multiplyLifetime(lifetimeMultiplier).enableForcedSpawn().modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.25f)).setMotion(direction);
                    lightSpecs.getBloomBuilder().multiplyLifetime(lifetimeMultiplier).setMotion(direction);
                    lightSpecs.spawnParticles();
                }
                if (!(random.m_188501_() < 0.8f)) continue;
                ParticleEffectSpawner sparks = SparkParticleEffects.spiritMotionSparks(level, spawnPosition, colorParticleData);
                sparks.getBuilder().multiplyLifetime(lifetimeMultiplier).enableForcedSpawn().setMotion(direction.m_82490_(1.5)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.25f)).modifyOptionalData(b -> b.getBehaviorData(SparkBehaviorComponent.class, SparkBehaviorComponent::getLengthData), d -> d.multiplyValue(2.0f));
                sparks.getBloomBuilder().multiplyLifetime(lifetimeMultiplier).setMotion(direction.m_82490_(1.5));
                sparks.spawnParticles();
            }
        };
    }
}

