/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.moonlight.api.client.util.VertexUtil;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.common.block.tiles.FlagBlockTile;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BannerPattern;
import org.joml.Quaternionf;

public class FlagBlockTileRenderer
implements BlockEntityRenderer<FlagBlockTile> {
    private final Minecraft minecraft = Minecraft.m_91087_();
    private final ModelPart flagModel;

    public FlagBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelpart = context.m_173582_(ModelLayers.f_171264_);
        this.flagModel = modelpart.m_171324_("flag");
    }

    public int m_142163_() {
        return 128;
    }

    public static void renderBanner(ModelPart flagModel, float ang, PoseStack matrixStack, MultiBufferSource bufferSource, int light, int pPackedOverlay, List<Pair<Holder<BannerPattern>, DyeColor>> list) {
        matrixStack.m_85836_();
        matrixStack.m_85841_(0.6666667f, -0.6666667f, -0.6666667f);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(0.05f * ang));
        flagModel.f_104203_ = 1.5707964f;
        flagModel.f_104204_ = (float)Math.PI;
        flagModel.f_104205_ = 1.5707964f;
        flagModel.f_104201_ = -12.0f;
        flagModel.f_104200_ = 1.5f;
        BannerRenderer.m_112065_((PoseStack)matrixStack, (MultiBufferSource)bufferSource, (int)light, (int)pPackedOverlay, (ModelPart)flagModel, (Material)ModelBakery.f_119224_, (boolean)true, list);
        matrixStack.m_85849_();
    }

    public void render(FlagBlockTile tile, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        List<Pair<Holder<BannerPattern>, DyeColor>> list = tile.getPatterns();
        if (list != null) {
            int lu = combinedLightIn & 0xFFFF;
            int lv = combinedLightIn >> 16 & 0xFFFF;
            int w = 24;
            int h = 16;
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.0, 0.5);
            poseStack.m_252781_(RotHlpr.rot((Direction)tile.getDirection().m_122424_()));
            poseStack.m_252880_(0.0f, 0.0f, 0.0625f);
            long time = tile.m_58904_().m_46467_();
            double l = ClientConfigs.Blocks.FLAG_WAVELENGTH.get();
            long period = ClientConfigs.Blocks.FLAG_PERIOD.get().intValue();
            double wavyness = ClientConfigs.Blocks.FLAG_AMPLITUDE.get();
            double invdamping = ClientConfigs.Blocks.FLAG_AMPLITUDE_INCREMENT.get();
            BlockPos bp = tile.m_58899_();
            float t = ((float)Math.floorMod((long)bp.m_123341_() * 7L + (long)bp.m_123343_() * 13L + time, period) + partialTicks) / (float)period;
            if (ClientConfigs.Blocks.FLAG_BANNER.get().booleanValue()) {
                float ang = (float)((wavyness + invdamping * (double)w) * (double)Mth.m_14031_((float)((float)((double)w / l - (double)(t * 2.0f * (float)Math.PI)))));
                FlagBlockTileRenderer.renderBanner(this.flagModel, ang, poseStack, bufferIn, combinedLightIn, combinedOverlayIn, list);
            } else {
                int segmentLen = ((GraphicsStatus)this.minecraft.f_91066_.m_232060_().m_231551_()).m_35965_() >= ClientConfigs.Blocks.FLAG_FANCINESS.get().ordinal() ? 1 : w;
                float oldAng = 0.0f;
                for (int dX = 0; dX < w; dX += segmentLen) {
                    float ang = (float)((wavyness + invdamping * (double)dX) * (double)Mth.m_14031_((float)((float)((double)dX / l - (double)(t * 2.0f * (float)Math.PI)))));
                    FlagBlockTileRenderer.renderPatterns(bufferIn, poseStack, list, lu, lv, dX, w, h, segmentLen, ang, oldAng);
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(ang));
                    poseStack.m_252880_(0.0f, 0.0f, (float)segmentLen / 16.0f);
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(-ang));
                    oldAng = ang;
                }
            }
            poseStack.m_85849_();
        }
    }

    public static void renderPatterns(PoseStack matrixStackIn, MultiBufferSource bufferIn, List<Pair<Holder<BannerPattern>, DyeColor>> list, int combinedLightIn) {
        int lu = combinedLightIn & 0xFFFF;
        int lv = combinedLightIn >> 16 & 0xFFFF;
        FlagBlockTileRenderer.renderPatterns(bufferIn, matrixStackIn, list, lu, lv, 0, 24, 16, 24, 0.0f, 0.0f);
    }

    private static void renderPatterns(MultiBufferSource bufferIn, PoseStack matrixStackIn, List<Pair<Holder<BannerPattern>, DyeColor>> list, int lu, int lv, int dX, int w, int h, int segmentlen, float ang, float oldAng) {
        for (int p = 0; p < list.size(); ++p) {
            Material material = ModMaterials.FLAG_MATERIALS.get().get(((Holder)list.get(p).getFirst()).m_203334_());
            if (material == null) continue;
            VertexConsumer builder = material.m_119194_(bufferIn, p == 0 ? RenderType::m_110446_ : RenderType::m_110482_);
            matrixStackIn.m_85836_();
            float[] color = ((DyeColor)list.get(p).getSecond()).m_41068_();
            float b = color[2];
            float g = color[1];
            float r = color[0];
            FlagBlockTileRenderer.renderCurvedSegment(builder, matrixStackIn, ang, oldAng, dX, segmentlen, h, lu, lv, dX + segmentlen >= w, r, g, b);
            matrixStackIn.m_85849_();
        }
    }

    private static void renderCurvedSegment(VertexConsumer builder, PoseStack matrixStack, float angle, float oldAng, int dX, int length, int height, int lu, int lv, boolean end, float r, float g, float b) {
        float textW = 32.0f;
        float textH = 16.0f;
        float u = (float)dX / textW;
        float v = 0.0f;
        float maxV = v + (float)height / textH;
        float maxU = u + (float)length / textW;
        float w = 0.0625f;
        float hw = w / 2.0f;
        float l = (float)length / 16.0f;
        float h = (float)height / 16.0f;
        float pU = maxU - 1.0f / textW;
        float pV = maxV - w;
        float pV2 = w;
        Quaternionf rot = Axis.f_252436_.m_252977_(angle);
        Quaternionf oldRot = Axis.f_252436_.m_252977_(oldAng);
        Quaternionf rotInc = Axis.f_252436_.m_252977_(angle - oldAng);
        Quaternionf rotInv = Axis.f_252436_.m_252977_(-angle);
        int nx = 1;
        boolean nz = false;
        boolean ny = false;
        matrixStack.m_85836_();
        matrixStack.m_252880_(hw, 0.0f, 0.0f);
        matrixStack.m_252781_(oldRot);
        VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)0.0f, (float)0.0f, (float)u, (float)maxV, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)nx, (float)((float)ny), (float)((float)nz));
        VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)h, (float)0.0f, (float)u, (float)v, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)nx, (float)((float)ny), (float)((float)nz));
        matrixStack.m_252781_(rotInc);
        matrixStack.m_252880_(0.0f, 0.0f, l);
        VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)h, (float)0.0f, (float)maxU, (float)v, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)nx, (float)((float)ny), (float)((float)nz));
        VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)0.0f, (float)0.0f, (float)maxU, (float)maxV, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)nx, (float)((float)ny), (float)((float)nz));
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_252880_(-hw, 0.0f, 0.0f);
        matrixStack.m_252781_(oldRot);
        VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)h, (float)0.0f, (float)u, (float)v, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)(-nx), (float)((float)ny), (float)((float)nz));
        VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)0.0f, (float)0.0f, (float)u, (float)maxV, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)(-nx), (float)((float)ny), (float)((float)nz));
        matrixStack.m_252781_(rotInc);
        matrixStack.m_252880_(0.0f, 0.0f, l);
        VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)0.0f, (float)0.0f, (float)maxU, (float)maxV, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)(-nx), (float)((float)ny), (float)((float)nz));
        VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)h, (float)0.0f, (float)maxU, (float)v, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)(-nx), (float)((float)ny), (float)((float)nz));
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_252880_(hw, 0.0f, 0.0f);
        VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)h, (float)0.0f, (float)u, (float)v, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)0.0f, (float)1.0f, (float)0.0f);
        matrixStack.m_252880_(-w, 0.0f, 0.0f);
        VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)h, (float)0.0f, (float)u, (float)pV2, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)0.0f, (float)1.0f, (float)0.0f);
        matrixStack.m_252781_(rot);
        matrixStack.m_252880_(0.0f, 0.0f, l);
        VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)h, (float)0.0f, (float)maxU, (float)pV2, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)0.0f, (float)1.0f, (float)0.0f);
        matrixStack.m_252781_(rotInv);
        matrixStack.m_252880_(w, 0.0f, 0.0f);
        VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)h, (float)0.0f, (float)maxU, (float)v, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)0.0f, (float)1.0f, (float)0.0f);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_252880_(-hw, 0.0f, 0.0f);
        VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)0.0f, (float)0.0f, (float)u, (float)pV, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)0.0f, (float)-1.0f, (float)0.0f);
        matrixStack.m_252880_(w, 0.0f, 0.0f);
        VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)0.0f, (float)0.0f, (float)u, (float)maxV, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)0.0f, (float)-1.0f, (float)0.0f);
        matrixStack.m_252781_(rot);
        matrixStack.m_252880_(0.0f, 0.0f, l);
        VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)0.0f, (float)0.0f, (float)maxU, (float)maxV, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)0.0f, (float)-1.0f, (float)0.0f);
        matrixStack.m_252781_(rotInv);
        matrixStack.m_252880_(-w, 0.0f, 0.0f);
        VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)0.0f, (float)0.0f, (float)maxU, (float)pV, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)0.0f, (float)-1.0f, (float)0.0f);
        matrixStack.m_85849_();
        if (end) {
            matrixStack.m_85836_();
            matrixStack.m_252781_(rot);
            matrixStack.m_252880_(0.0f, 0.0f, l);
            matrixStack.m_252781_(rotInv);
            matrixStack.m_252880_(-hw, 0.0f, 0.0f);
            VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)h, (float)0.0f, (float)pU, (float)v, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)0.0f, (float)0.0f, (float)1.0f);
            VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)0.0f, (float)0.0f, (float)pU, (float)maxV, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)0.0f, (float)0.0f, (float)1.0f);
            matrixStack.m_252880_(w, 0.0f, 0.0f);
            VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)0.0f, (float)0.0f, (float)maxU, (float)maxV, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)0.0f, (float)0.0f, (float)1.0f);
            VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)h, (float)0.0f, (float)maxU, (float)v, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)0.0f, (float)0.0f, (float)1.0f);
            matrixStack.m_85849_();
        }
    }
}

