/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.orcinus.galosphere.init.GCriteriaTriggers;

public class LumiereComposterBlock
extends ComposterBlock {
    public LumiereComposterBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)Items.f_42726_);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        int i = (Integer)state.m_61143_((Property)f_51913_);
        ItemStack itemstack = player.m_21120_(hand);
        if (i < 8 && f_51914_.containsKey((Object)itemstack.m_41720_())) {
            if (i < 7 && !world.f_46443_) {
                BlockState blockstate = LumiereComposterBlock.addItem(state, (LevelAccessor)world, pos, itemstack);
                world.m_46796_(1500, pos, state != blockstate ? 1 : 0);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)itemstack.m_41720_()));
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        if (i == 8) {
            LumiereComposterBlock.extractGlowstoneDust(state, world, pos);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                GCriteriaTriggers.LUMIERE_COMPOST.trigger(serverPlayer);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public static BlockState extractGlowstoneDust(BlockState state, Level world, BlockPos pos) {
        if (!world.f_46443_) {
            double d0 = (double)(world.f_46441_.m_188501_() * 0.7f) + (double)0.15f;
            double d1 = (double)(world.f_46441_.m_188501_() * 0.7f) + 0.06000000238418579 + 0.6;
            double d2 = (double)(world.f_46441_.m_188501_() * 0.7f) + (double)0.15f;
            ItemEntity itementity = new ItemEntity(world, (double)pos.m_123341_() + d0, (double)pos.m_123342_() + d1, (double)pos.m_123343_() + d2, new ItemStack((ItemLike)Items.f_42525_));
            itementity.m_32060_();
            world.m_7967_((Entity)itementity);
        }
        BlockState blockstate = LumiereComposterBlock.empty(state, (LevelAccessor)world, pos);
        world.m_5594_(null, pos, SoundEvents.f_11763_, SoundSource.BLOCKS, 1.0f, 1.0f);
        return blockstate;
    }

    public static BlockState empty(BlockState state, LevelAccessor world, BlockPos pos) {
        BlockState blockstate = (BlockState)Blocks.f_50715_.m_49966_().m_61124_((Property)ComposterBlock.f_51913_, (Comparable)Integer.valueOf(0));
        world.m_7731_(pos, blockstate, 3);
        return blockstate;
    }

    public static BlockState addItem(BlockState state, LevelAccessor world, BlockPos pos, ItemStack stack) {
        int i = (Integer)state.m_61143_((Property)f_51913_);
        float f = f_51914_.getFloat((Object)stack.m_41720_());
        if (!(i == 0 && f > 0.0f || world.m_213780_().m_188500_() < (double)f)) {
            return state;
        }
        int j = i + 1;
        BlockState blockstate = (BlockState)state.m_61124_((Property)f_51913_, (Comparable)Integer.valueOf(j));
        world.m_7731_(pos, blockstate, 3);
        if (j == 7) {
            world.m_186460_(pos, state.m_60734_(), 20);
        }
        return blockstate;
    }

    public WorldlyContainer m_5840_(BlockState state, LevelAccessor world, BlockPos pos) {
        int i = (Integer)state.m_61143_((Property)f_51913_);
        if (i == 8) {
            return new OutputContainer(state, world, pos, new ItemStack((ItemLike)Items.f_42525_));
        }
        return i < 7 ? new InputContainer(state, world, pos) : new EmptyContainer();
    }

    static class OutputContainer
    extends SimpleContainer
    implements WorldlyContainer {
        private final BlockState state;
        private final LevelAccessor level;
        private final BlockPos pos;
        private boolean changed;

        public OutputContainer(BlockState state, LevelAccessor world, BlockPos pos, ItemStack stack) {
            super(new ItemStack[]{stack});
            this.state = state;
            this.level = world;
            this.pos = pos;
        }

        public int m_6893_() {
            return 1;
        }

        public int[] m_7071_(Direction direction) {
            int[] nArray;
            if (direction == Direction.DOWN) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                nArray = new int[]{};
            }
            return nArray;
        }

        public boolean m_7155_(int p_52049_, ItemStack p_52050_, @Nullable Direction p_52051_) {
            return false;
        }

        public boolean m_7157_(int p_52055_, ItemStack p_52056_, Direction direection) {
            return !this.changed && direection == Direction.DOWN && p_52056_.m_150930_(Items.f_42525_);
        }

        public void m_6596_() {
            LumiereComposterBlock.empty(this.state, this.level, this.pos);
            this.changed = true;
        }
    }

    static class InputContainer
    extends SimpleContainer
    implements WorldlyContainer {
        private final BlockState state;
        private final LevelAccessor level;
        private final BlockPos pos;
        private boolean changed;

        public InputContainer(BlockState p_52022_, LevelAccessor p_52023_, BlockPos p_52024_) {
            super(1);
            this.state = p_52022_;
            this.level = p_52023_;
            this.pos = p_52024_;
        }

        public int m_6893_() {
            return 1;
        }

        public int[] m_7071_(Direction p_52032_) {
            int[] nArray;
            if (p_52032_ == Direction.UP) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                nArray = new int[]{};
            }
            return nArray;
        }

        public boolean m_7155_(int p_52028_, ItemStack p_52029_, @Nullable Direction p_52030_) {
            return !this.changed && p_52030_ == Direction.UP && ComposterBlock.f_51914_.containsKey((Object)p_52029_.m_41720_());
        }

        public boolean m_7157_(int p_52034_, ItemStack p_52035_, Direction p_52036_) {
            return false;
        }

        public void m_6596_() {
            ItemStack itemstack = this.m_8020_(0);
            if (!itemstack.m_41619_()) {
                this.changed = true;
                BlockState blockstate = LumiereComposterBlock.addItem(this.state, this.level, this.pos, itemstack);
                this.level.m_46796_(1500, this.pos, blockstate != this.state ? 1 : 0);
                this.m_8016_(0);
            }
        }
    }

    static class EmptyContainer
    extends SimpleContainer
    implements WorldlyContainer {
        public EmptyContainer() {
            super(0);
        }

        public int[] m_7071_(Direction direction) {
            return new int[0];
        }

        public boolean m_7155_(int p_52008_, ItemStack stack, @Nullable Direction direction) {
            return false;
        }

        public boolean m_7157_(int p_52014_, ItemStack stack, Direction direction) {
            return false;
        }
    }
}

