/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks.blockentities;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.orcinus.galosphere.blocks.MonstrometerBlock;
import net.orcinus.galosphere.init.GBlockEntityTypes;
import net.orcinus.galosphere.init.GParticleTypes;

public class MonstrometerBlockEntity
extends BlockEntity {
    private int monsterCount;
    public int activeTicks = 0;

    public MonstrometerBlockEntity(BlockPos worldPosition, BlockState state) {
        super((BlockEntityType)GBlockEntityTypes.MONSTROMETER.get(), worldPosition, state);
    }

    public static void createParticles(Level world, BlockPos origin) {
        Predicate<BlockPos> predicate = pos -> world.m_46859_(pos) && NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)world, (BlockPos)pos, (EntityType)EntityType.f_20501_);
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            MonstrometerBlock.getIndicatedBlocks(origin, predicate).forEach(pos -> {
                double x = (double)pos.m_123341_() + 0.5;
                double y = (float)pos.m_123342_() + 0.01f;
                double z = (double)pos.m_123343_() + 0.5;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)GParticleTypes.AURA_RINGER_INDICATOR.get()), x, y, z, 1, 0.0, 0.0, 0.0, 0.5);
            });
        }
    }

    public static void applyGlowing(Level world, BlockPos origin) {
        List<LivingEntity> mobs = MonstrometerBlockEntity.getNearbyMonsters(world, origin);
        mobs.forEach(mob -> mob.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 60)));
    }

    private static List<LivingEntity> getNearbyMonsters(Level world, BlockPos origin) {
        return world.m_6443_(LivingEntity.class, new AABB(origin).m_82377_(16.0, 6.0, 16.0), livingEntity -> livingEntity instanceof Monster && !livingEntity.m_6095_().m_204039_(EntityTypeTags.f_13121_));
    }

    public static void tick(Level world, BlockPos origin, BlockState state, MonstrometerBlockEntity entity) {
        int size = MonstrometerBlockEntity.getNearbyMonsters(world, origin).size();
        if (size > 0 && size != entity.monsterCount) {
            entity.monsterCount = size;
            world.m_46672_(origin, state.m_60734_());
        }
        if (MonstrometerBlock.isActive(state)) {
            if (entity.activeTicks % 34 == 0) {
                MonstrometerBlockEntity.applyGlowing(world, origin);
                MonstrometerBlockEntity.createParticles(world, origin);
            }
            ++entity.activeTicks;
        } else {
            entity.activeTicks = 0;
        }
    }

    public int getRedstoneSignal() {
        return Math.max(Math.min(this.monsterCount, 15), 0);
    }
}

