/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.orcinus.galosphere.entities.Sparkle;

@OnlyIn(value=Dist.CLIENT)
public class SparkleModel<T extends Sparkle>
extends AgeableListModel<T> {
    private final ModelPart body;
    private final ModelPart tail;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart head;

    public SparkleModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.tail = root.m_171324_("tail");
        this.leftLeg = root.m_171324_("leftLeg");
        this.rightLeg = root.m_171324_("rightLeg");
        this.rightArm = root.m_171324_("rightArm");
        this.leftArm = root.m_171324_("leftArm");
        this.head = root.m_171324_("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.5f, -2.0f, -4.0f, 5.0f, 4.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)21.0f, (float)-1.0f));
        PartDefinition tail = partdefinition.m_171599_("tail", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)23.0f, (float)1.0f));
        PartDefinition crystal1 = tail.m_171599_("crystal1", CubeListBuilder.m_171558_().m_171514_(24, 4).m_171488_(0.0f, -3.0f, 0.0f, 0.0f, 6.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition crystal2 = tail.m_171599_("crystal2", CubeListBuilder.m_171558_().m_171514_(24, 4).m_171488_(0.0f, -3.0f, 0.0f, 0.0f, 6.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)2.3562f));
        PartDefinition leftLeg = partdefinition.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(-3, 5).m_171488_(0.0f, 0.0f, -1.5f, 5.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.5f, (float)22.0f, (float)4.5f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition rightLeg = partdefinition.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(-3, 5).m_171480_().m_171488_(-5.0f, 0.0f, -1.5f, 5.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-2.5f, (float)22.0f, (float)4.5f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition rightArm = partdefinition.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(-3, 5).m_171480_().m_171488_(-5.0f, 0.0f, -1.5f, 5.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-2.5f, (float)22.0f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition leftArm = partdefinition.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(-3, 5).m_171488_(0.0f, 0.0f, -1.5f, 5.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.5f, (float)22.0f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171488_(-3.0f, -2.0f, -6.0f, 6.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(21, 5).m_171488_(1.0f, -2.0f, 1.0f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(21, 5).m_171480_().m_171488_(-3.0f, -2.0f, 1.0f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)19.0f, (float)-5.0f));
        PartDefinition beard = head.m_171599_("beard", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.0f, (float)-3.5f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition leftWhisker = head.m_171599_("leftWhisker", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.0f, -0.5f, 0.0f, 4.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)0.5f, (float)-6.0f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        PartDefinition rightWhisker = head.m_171599_("rightWhisker", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(-4.0f, -0.5f, 0.0f, 4.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-3.0f, (float)0.5f, (float)-6.0f, (float)0.0f, (float)0.3927f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)48, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.m_20072_()) {
            this.body.f_104204_ = Mth.m_14089_((float)(ageInTicks / 2.0f)) / 8.0f;
            this.tail.f_104204_ = Mth.m_14031_((float)(ageInTicks / 2.0f)) / 3.5f;
        } else {
            this.body.f_104204_ = 0.0f;
            this.leftLeg.f_104203_ = Mth.m_14031_((float)limbSwing) * limbSwingAmount;
            this.leftLeg.f_104204_ = Mth.m_14089_((float)limbSwing) * limbSwingAmount * 2.0f;
            this.rightLeg.f_104203_ = -Mth.m_14031_((float)(limbSwing * 1.5f)) * limbSwingAmount;
            this.rightLeg.f_104204_ = Mth.m_14089_((float)(limbSwing * 1.5f)) * limbSwingAmount * 2.0f;
            this.leftArm.f_104203_ = -Mth.m_14031_((float)(limbSwing * 1.5f)) * limbSwingAmount;
            this.leftArm.f_104204_ = Mth.m_14089_((float)(limbSwing * 1.5f)) * limbSwingAmount * 2.0f;
            this.rightArm.f_104203_ = Mth.m_14031_((float)limbSwing) * limbSwingAmount;
            this.rightArm.f_104204_ = Mth.m_14089_((float)limbSwing) * limbSwingAmount * 2.0f;
            this.tail.f_104204_ = Mth.m_14089_((float)(limbSwing * 1.0f * 2.0f)) * limbSwingAmount;
            this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        }
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.tail, (Object)this.leftLeg, (Object)this.rightLeg, (Object)this.leftArm, (Object)this.rightArm, (Object)this.body);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            poseStack.m_85836_();
            float f1 = 0.5f;
            poseStack.m_85841_(f1, f1, f1);
            poseStack.m_85837_(0.0, 1.5, 0.2083333283662796);
            this.m_5607_().forEach(part -> part.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha));
            poseStack.m_85849_();
            poseStack.m_85836_();
            poseStack.m_85841_(f1, f1, f1);
            poseStack.m_85837_(0.0, 1.5, 0.0);
            this.m_5608_().forEach(part -> part.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha));
            poseStack.m_85849_();
        } else {
            this.m_5607_().forEach(part -> part.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(part -> part.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha));
        }
    }
}

