/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.datagen;

import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.blocks.LichenMossBlock;
import net.orcinus.galosphere.blocks.PinkSaltChamberBlock;
import net.orcinus.galosphere.blocks.PinkSaltStrawBlock;
import net.orcinus.galosphere.blocks.PollinatedClusterBlock;
import net.orcinus.galosphere.blocks.ShadowFrameBlock;
import net.orcinus.galosphere.init.GBlocks;
import org.jetbrains.annotations.NotNull;

public class GBlockstateProvider
extends BlockStateProvider {
    public GBlockstateProvider(PackOutput packOutput, ExistingFileHelper exFileHelper) {
        super(packOutput, "galosphere", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.simpleBlock((Block)GBlocks.ALLURITE_BLOCK.get());
        this.simpleBlock((Block)GBlocks.LUMIERE_BLOCK.get());
        this.simpleBlock((Block)GBlocks.SMOOTH_AMETHYST.get());
        this.simpleBlock((Block)GBlocks.SMOOTH_ALLURITE.get());
        this.simpleBlock((Block)GBlocks.SMOOTH_LUMIERE.get());
        this.simpleBlock((Block)GBlocks.AMETHYST_BRICKS.get());
        this.simpleBlock((Block)GBlocks.ALLURITE_BRICKS.get());
        this.simpleBlock((Block)GBlocks.LUMIERE_BRICKS.get());
        this.simpleBlock((Block)GBlocks.CHISELED_AMETHYST.get());
        this.simpleBlock((Block)GBlocks.CHISELED_ALLURITE.get());
        this.simpleBlock((Block)GBlocks.CHISELED_LUMIERE.get());
        this.simpleBlock((Block)GBlocks.AMETHYST_LAMP.get());
        this.simpleBlock((Block)GBlocks.ALLURITE_LAMP.get());
        this.simpleBlock((Block)GBlocks.LUMIERE_LAMP.get());
        this.simpleBlock((Block)GBlocks.RAW_SILVER_BLOCK.get());
        this.simpleBlock((Block)GBlocks.SILVER_BLOCK.get());
        this.simpleBlock((Block)GBlocks.SILVER_ORE.get());
        this.simpleBlock((Block)GBlocks.DEEPSLATE_SILVER_ORE.get());
        this.simpleBlock((Block)GBlocks.CHARGED_LUMIERE_BLOCK.get());
        this.getVariantBuilder((Block)GBlocks.LICHEN_MOSS.get()).forAllStatesExcept(blockState -> {
            String name = (Boolean)blockState.m_61143_((Property)LichenMossBlock.LIT) != false ? "lichen_moss_lit" : "lichen_moss";
            ModelBuilder modelFile = this.models().cubeAll(name, Galosphere.id("block/" + name));
            return ConfiguredModel.builder().modelFile((ModelFile)modelFile).build();
        }, new Property[0]);
        this.crossBlock(GBlocks.LICHEN_ROOTS);
        this.crossBlock(GBlocks.BOWL_LICHEN);
        this.crossBlock(GBlocks.LICHEN_CORDYCEPS_PLANT);
        this.slabBlock((Block)GBlocks.AMETHYST_SLAB.get(), "amethyst_block", true);
        this.slabBlock((Block)GBlocks.ALLURITE_SLAB.get(), "allurite_block");
        this.slabBlock((Block)GBlocks.LUMIERE_SLAB.get(), "lumiere_block");
        this.slabBlock((Block)GBlocks.SMOOTH_AMETHYST_SLAB.get(), "smooth_amethyst");
        this.slabBlock((Block)GBlocks.SMOOTH_ALLURITE_SLAB.get(), "smooth_allurite");
        this.slabBlock((Block)GBlocks.SMOOTH_LUMIERE_SLAB.get(), "smooth_lumiere");
        this.slabBlock((Block)GBlocks.AMETHYST_BRICK_SLAB.get(), "amethyst_bricks");
        this.slabBlock((Block)GBlocks.ALLURITE_BRICK_SLAB.get(), "allurite_bricks");
        this.slabBlock((Block)GBlocks.LUMIERE_BRICK_SLAB.get(), "lumiere_bricks");
        this.stairsBlock((Block)GBlocks.AMETHYST_STAIRS.get(), "amethyst_block", true);
        this.stairsBlock((Block)GBlocks.ALLURITE_STAIRS.get(), "allurite_block");
        this.stairsBlock((Block)GBlocks.LUMIERE_STAIRS.get(), "lumiere_block");
        this.stairsBlock((Block)GBlocks.SMOOTH_AMETHYST_STAIRS.get(), "smooth_amethyst");
        this.stairsBlock((Block)GBlocks.SMOOTH_ALLURITE_STAIRS.get(), "smooth_allurite");
        this.stairsBlock((Block)GBlocks.SMOOTH_LUMIERE_STAIRS.get(), "smooth_lumiere");
        this.stairsBlock((Block)GBlocks.AMETHYST_BRICK_STAIRS.get(), "amethyst_bricks");
        this.stairsBlock((Block)GBlocks.ALLURITE_BRICK_STAIRS.get(), "allurite_bricks");
        this.stairsBlock((Block)GBlocks.LUMIERE_BRICK_STAIRS.get(), "lumiere_bricks");
        this.getVariantBuilder((Block)GBlocks.COMBUSTION_TABLE.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().cube("combustion_table", Galosphere.id("block/combustion_table_bottom"), Galosphere.id("block/combustion_table_top"), Galosphere.id("block/combustion_table_side2"), Galosphere.id("block/combustion_table_side2"), Galosphere.id("block/combustion_table_side1"), Galosphere.id("block/combustion_table_side0"))).texture("particle", Galosphere.id("block/combustion_table_side2"))).build());
        this.pollinatedCluster((Block)GBlocks.ALLURITE_CLUSTER.get());
        this.pollinatedCluster((Block)GBlocks.LUMIERE_CLUSTER.get());
        this.pollinatedCluster((Block)GBlocks.GLINTED_ALLURITE_CLUSTER.get());
        this.pollinatedCluster((Block)GBlocks.GLINTED_LUMIERE_CLUSTER.get());
        this.pollinatedCluster((Block)GBlocks.GLINTED_AMETHYST_CLUSTER.get());
        this.simpleBlock((Block)GBlocks.SILVER_TILES.get());
        this.slabBlock((Block)GBlocks.SILVER_TILES_SLAB.get(), "silver_tiles");
        this.stairsBlock((Block)GBlocks.SILVER_TILES_STAIRS.get(), "silver_tiles");
        this.simpleBlock((Block)GBlocks.SILVER_PANEL.get());
        this.slabBlock((Block)GBlocks.SILVER_PANEL_SLAB.get(), "silver_panel");
        this.stairsBlock((Block)GBlocks.SILVER_PANEL_STAIRS.get(), "silver_panel");
        this.simpleBlock((Block)GBlocks.PINK_SALT.get());
        this.simpleBlock((Block)GBlocks.ROSE_PINK_SALT.get());
        this.simpleBlock((Block)GBlocks.PASTEL_PINK_SALT.get());
        this.slabBlock((Block)GBlocks.PINK_SALT_SLAB.get(), "pink_salt");
        this.slabBlock((Block)GBlocks.ROSE_PINK_SALT_SLAB.get(), "rose_pink_salt");
        this.slabBlock((Block)GBlocks.PASTEL_PINK_SALT_SLAB.get(), "pastel_pink_salt");
        this.stairsBlock((Block)GBlocks.PINK_SALT_STAIRS.get(), "pink_salt");
        this.stairsBlock((Block)GBlocks.ROSE_PINK_SALT_STAIRS.get(), "rose_pink_salt");
        this.stairsBlock((Block)GBlocks.PASTEL_PINK_SALT_STAIRS.get(), "pastel_pink_salt");
        this.simpleBlock((Block)GBlocks.POLISHED_PINK_SALT.get());
        this.simpleBlock((Block)GBlocks.POLISHED_ROSE_PINK_SALT.get());
        this.simpleBlock((Block)GBlocks.POLISHED_PASTEL_PINK_SALT.get());
        this.slabBlock((Block)GBlocks.POLISHED_PINK_SALT_SLAB.get(), "polished_pink_salt");
        this.slabBlock((Block)GBlocks.POLISHED_ROSE_PINK_SALT_SLAB.get(), "polished_rose_pink_salt");
        this.slabBlock((Block)GBlocks.POLISHED_PASTEL_PINK_SALT_SLAB.get(), "polished_pastel_pink_salt");
        this.stairsBlock((Block)GBlocks.POLISHED_PINK_SALT_STAIRS.get(), "polished_pink_salt");
        this.stairsBlock((Block)GBlocks.POLISHED_ROSE_PINK_SALT_STAIRS.get(), "polished_rose_pink_salt");
        this.stairsBlock((Block)GBlocks.POLISHED_PASTEL_PINK_SALT_STAIRS.get(), "polished_pastel_pink_salt");
        this.simpleBlock((Block)GBlocks.PINK_SALT_BRICKS.get());
        this.simpleBlock((Block)GBlocks.ROSE_PINK_SALT_BRICKS.get());
        this.simpleBlock((Block)GBlocks.PASTEL_PINK_SALT_BRICKS.get());
        this.slabBlock((Block)GBlocks.PINK_SALT_BRICK_SLAB.get(), "pink_salt_bricks");
        this.slabBlock((Block)GBlocks.ROSE_PINK_SALT_BRICK_SLAB.get(), "rose_pink_salt_bricks");
        this.slabBlock((Block)GBlocks.PASTEL_PINK_SALT_BRICK_SLAB.get(), "pastel_pink_salt_bricks");
        this.stairsBlock((Block)GBlocks.PINK_SALT_BRICK_STAIRS.get(), "pink_salt_bricks");
        this.stairsBlock((Block)GBlocks.ROSE_PINK_SALT_BRICK_STAIRS.get(), "rose_pink_salt_bricks");
        this.stairsBlock((Block)GBlocks.PASTEL_PINK_SALT_BRICK_STAIRS.get(), "pastel_pink_salt_bricks");
        this.simpleBlock((Block)GBlocks.CURED_MEMBRANE_BLOCK.get());
        this.getVariantBuilder((Block)GBlocks.SHADOW_FRAME.get()).forAllStatesExcept(state -> {
            String name = (Boolean)state.m_61143_((Property)ShadowFrameBlock.POWERED) != false ? "shadow_frame_filled" : "shadow_frame";
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().cubeAll(name, Galosphere.id("block/" + name))).renderType("cutout")).build();
        }, new Property[]{BlockStateProperties.f_61362_, BlockStateProperties.f_61422_, ShadowFrameBlock.FILLED});
        this.getVariantBuilder((Block)GBlocks.STRANDED_MEMBRANE_BLOCK.get()).forAllStatesExcept(blockState -> {
            int x = 0;
            int y = 0;
            Direction direction = (Direction)blockState.m_61143_((Property)DirectionalBlock.f_52588_);
            if (direction == Direction.DOWN) {
                x = 180;
            } else if (direction == Direction.EAST) {
                x = 90;
                y = 90;
            } else if (direction == Direction.SOUTH) {
                x = 90;
                y = 180;
            } else if (direction == Direction.NORTH) {
                x = 90;
            } else if (direction == Direction.WEST) {
                x = 90;
                y = 270;
            }
            return ConfiguredModel.builder().rotationX(x).rotationY(y).modelFile((ModelFile)((BlockModelBuilder)this.models().cubeBottomTop("stranded_membrane_block", Galosphere.id("block/stranded_membrane_block_side"), Galosphere.id("block/stranded_membrane_block_bottom"), Galosphere.id("block/stranded_membrane_block_top"))).renderType("translucent")).build();
        }, new Property[]{BlockStateProperties.f_61362_});
        this.getVariantBuilder((Block)GBlocks.PINK_SALT_CHAMBER.get()).forAllStates(state -> {
            String name = ((PinkSaltChamberBlock.ChamberPhase)((Object)((Object)state.m_61143_(PinkSaltChamberBlock.PHASE)))).m_7912_() + "_pink_salt_chamber";
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().cubeAll(name, Galosphere.id("block/" + name))).build();
        });
        this.wallBlock((Block)GBlocks.PINK_SALT_WALL.get(), "pink_salt");
        this.wallBlock((Block)GBlocks.ROSE_PINK_SALT_WALL.get(), "rose_pink_salt");
        this.wallBlock((Block)GBlocks.PASTEL_PINK_SALT_WALL.get(), "pastel_pink_salt");
        this.wallBlock((Block)GBlocks.POLISHED_PINK_SALT_WALL.get(), "polished_pink_salt");
        this.wallBlock((Block)GBlocks.POLISHED_ROSE_PINK_SALT_WALL.get(), "polished_rose_pink_salt");
        this.wallBlock((Block)GBlocks.POLISHED_PASTEL_PINK_SALT_WALL.get(), "polished_pastel_pink_salt");
        this.wallBlock((Block)GBlocks.PINK_SALT_BRICK_WALL.get(), "pink_salt_bricks");
        this.wallBlock((Block)GBlocks.ROSE_PINK_SALT_BRICK_WALL.get(), "rose_pink_salt_bricks");
        this.wallBlock((Block)GBlocks.PASTEL_PINK_SALT_BRICK_WALL.get(), "pastel_pink_salt_bricks");
        this.getVariantBuilder((Block)GBlocks.GILDED_BEADS.get()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)this.models().sign("gilded_beads", new ResourceLocation("block/gold_block"))).build(), new Property[]{BlockStateProperties.f_61390_, BlockStateProperties.f_61362_, BlockStateProperties.f_61427_});
        this.getVariantBuilder((Block)GBlocks.SILVER_BALANCE.get()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(Galosphere.id("block/silver_balance"))).build(), new Property[]{BlockStateProperties.f_61362_});
        this.getVariantBuilder((Block)GBlocks.PINK_SALT_STRAW.get()).forAllStatesExcept(state -> {
            String name = "pink_salt_straw_" + ((Direction)state.m_61143_((Property)PinkSaltStrawBlock.TIP_DIRECTION)).m_122433_() + "_" + state.m_61143_(PinkSaltStrawBlock.STRAW_SHAPE);
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, "block/pointed_dripstone")).renderType("cutout")).texture("cross", "block/" + name)).build();
        }, new Property[]{BlockStateProperties.f_61362_, PinkSaltStrawBlock.FALLABLE});
        this.getVariantBuilder((Block)GBlocks.PINK_SALT_CLUSTER.get()).forAllStatesExcept(state -> {
            Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            int rotationX = 90;
            int rotationY = 90;
            if (facing == Direction.UP) {
                rotationX = 0;
                rotationY = 0;
            } else if (facing == Direction.DOWN) {
                rotationX = 180;
                rotationY = 0;
            } else if (facing == Direction.WEST) {
                rotationY *= 3;
            } else if (facing == Direction.NORTH) {
                rotationY = 0;
            } else if (facing == Direction.SOUTH) {
                rotationY *= 2;
            }
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(Galosphere.id("block/pink_salt_cluster"))).rotationX(rotationX).rotationY(rotationY).build();
        }, new Property[]{BlockStateProperties.f_61362_});
        this.getVariantBuilder((Block)GBlocks.PINK_SALT_LAMP.get()).forAllStatesExcept(state -> {
            Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            int rotationX = 90;
            int rotationY = 90;
            if (facing == Direction.UP) {
                rotationX = 0;
                rotationY = 0;
            } else if (facing == Direction.DOWN) {
                rotationX = 180;
                rotationY = 0;
            } else if (facing == Direction.WEST) {
                rotationY *= 3;
            } else if (facing == Direction.NORTH) {
                rotationY = 0;
            } else if (facing == Direction.SOUTH) {
                rotationY *= 2;
            }
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(Galosphere.id("block/pink_salt_lamp"))).rotationX(rotationX).rotationY(rotationY).build();
        }, new Property[]{BlockStateProperties.f_61362_});
    }

    private void wallBlock(Block block, String name) {
        String path = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        this.wallBlock((WallBlock)block, Galosphere.id("block/" + name));
        ((ItemModelBuilder)this.itemModels().getBuilder(path)).parent((ModelFile)this.models().wallInventory(path + "_inventory", this.blockTexture((Block)ForgeRegistries.BLOCKS.getValue(this.modLoc(name)))));
    }

    private void pollinatedCluster(@NotNull Block block) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            Direction facing = (Direction)state.m_61143_((Property)AmethystClusterBlock.f_152006_);
            int rotationX = 90;
            int rotationY = 90;
            if (facing == Direction.UP) {
                rotationX = 0;
                rotationY = 0;
            } else if (facing == Direction.DOWN) {
                rotationX = 180;
                rotationY = 0;
            } else if (facing == Direction.WEST) {
                rotationY *= 3;
            } else if (facing == Direction.NORTH) {
                rotationY = 0;
            } else if (facing == Direction.SOUTH) {
                rotationY *= 2;
            }
            Object path = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
            if (state.m_61138_((Property)PollinatedClusterBlock.POLLINATED) && ((Boolean)state.m_61143_((Property)PollinatedClusterBlock.POLLINATED)).booleanValue()) {
                path = "glinted_" + (String)path;
            }
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().cross((String)path, Galosphere.id("block/" + (String)path))).renderType("cutout")).rotationX(rotationX).rotationY(rotationY).build();
        }, new Property[]{BlockStateProperties.f_61362_});
    }

    private void crossBlock(RegistryObject<Block> block) {
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().cross(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get()))).m_135815_(), Galosphere.id("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_()))).renderType("cutout")).build());
    }

    private void stairsBlock(Block block, String blockMaterial) {
        this.stairsBlock(block, blockMaterial, false);
    }

    private void stairsBlock(Block block, String blockMaterial, boolean flag) {
        String id = flag ? "minecraft" : "galosphere";
        ResourceLocation resourceLocation = new ResourceLocation(id, "block/" + blockMaterial);
        this.stairsBlock((StairBlock)block, resourceLocation);
    }

    private void slabBlock(Block block, String blockMaterial) {
        this.slabBlock(block, blockMaterial, false);
    }

    private void slabBlock(Block block, String blockMaterial, boolean flag) {
        String id = flag ? "minecraft" : "galosphere";
        ResourceLocation resourceLocation = new ResourceLocation(id, "block/" + blockMaterial);
        this.slabBlock((SlabBlock)block, resourceLocation, resourceLocation);
    }
}

