/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities;

import java.util.List;
import java.util.UUID;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.orcinus.galosphere.entities.Berserker;
import net.orcinus.galosphere.entities.PinkSaltShard;
import net.orcinus.galosphere.entities.Preserved;
import net.orcinus.galosphere.init.GEnchantments;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GSoundEvents;
import org.jetbrains.annotations.Nullable;

public class PinkSaltPillar
extends Entity
implements TraceableEntity {
    private static final EntityDataAccessor<ItemStack> ITEM = SynchedEntityData.m_135353_(PinkSaltPillar.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Boolean> ACTIVE = SynchedEntityData.m_135353_(PinkSaltPillar.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;
    private int warmupDelayTicks;
    private boolean sentSpikeEvent;
    private int lifeTicks = 22;
    public static final float DEFAULT_DAMAGE = 3.0f;
    private float damage = 3.0f;
    public AnimationState emergeAnimationState = new AnimationState();
    public AnimationState retractAnimationState = new AnimationState();

    public PinkSaltPillar(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public PinkSaltPillar(Level level, double d, double e, double f, float g, int warmupDelayTicks, float damage, LivingEntity livingEntity) {
        this((EntityType)GEntityTypes.PINK_SALT_PILLAR.get(), level);
        this.warmupDelayTicks = warmupDelayTicks;
        this.damage = damage;
        this.setOwner(livingEntity);
        this.m_146922_(g * 57.295776f);
        this.m_6034_(d, e, f);
    }

    public PinkSaltPillar(Level level, double d, double e, double f, float g, int warmupDelayTicks, float damage, LivingEntity livingEntity, ItemStack itemStack) {
        this((EntityType)GEntityTypes.PINK_SALT_PILLAR.get(), level);
        this.warmupDelayTicks = warmupDelayTicks;
        this.damage = damage;
        this.setOwner(livingEntity);
        this.m_146922_(g * 57.295776f);
        this.m_6034_(d, e, f);
        this.f_19804_.m_135381_(ITEM, (Object)itemStack.m_41777_());
        this.lifeTicks = 22 * (EnchantmentHelper.m_44843_((Enchantment)((Enchantment)GEnchantments.SUSTAIN.get()), (ItemStack)itemStack) / 2 + 1);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ACTIVE, (Object)false);
        this.f_19804_.m_135372_(ITEM, (Object)ItemStack.f_41583_);
    }

    public void setOwner(@Nullable LivingEntity livingEntity) {
        this.owner = livingEntity;
        this.ownerUUID = livingEntity == null ? null : livingEntity.m_20148_();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    protected void m_7378_(CompoundTag compoundTag) {
        this.warmupDelayTicks = compoundTag.m_128451_("Warmup");
        this.lifeTicks = compoundTag.m_128451_("LifeTicks");
        this.damage = compoundTag.m_128457_("Damage");
        this.setActive(compoundTag.m_128471_("Active"));
        ItemStack itemStack = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("TabletItem"));
        if (!itemStack.m_41619_()) {
            this.f_19804_.m_135381_(ITEM, (Object)itemStack);
        }
        if (compoundTag.m_128403_("Owner")) {
            this.ownerUUID = compoundTag.m_128342_("Owner");
        }
    }

    protected void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128405_("Warmup", this.warmupDelayTicks);
        compoundTag.m_128405_("LifeTicks", this.lifeTicks);
        compoundTag.m_128350_("Damage", this.damage);
        compoundTag.m_128379_("Active", this.isActive());
        ItemStack itemStack = (ItemStack)this.f_19804_.m_135370_(ITEM);
        if (!itemStack.m_41619_()) {
            compoundTag.m_128365_("TabletItem", (Tag)itemStack.m_41739_(new CompoundTag()));
        }
        if (this.ownerUUID != null) {
            compoundTag.m_128362_("Owner", this.ownerUUID);
        }
    }

    private void setActive(boolean active) {
        this.f_19804_.m_135381_(ACTIVE, (Object)active);
    }

    public boolean isActive() {
        return (Boolean)this.f_19804_.m_135370_(ACTIVE);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            Level stack;
            List arrows = this.m_9236_().m_45976_(Arrow.class, this.m_20191_().m_82400_(1.2));
            for (Object arrow : arrows) {
                Vec3 selfPos = this.m_20182_().m_82520_(0.0, (double)1.6f, 0.0);
                Vec3 enemyPos = arrow.m_146892_().m_82546_(selfPos);
                Vec3 normalizedDirection = enemyPos.m_82541_();
                double knockbackX = 0.15;
                double knockbackY = 0.15;
                arrow.m_20256_(arrow.m_20184_().m_82520_(normalizedDirection.m_7096_() * knockbackY, normalizedDirection.m_7098_() * knockbackX, normalizedDirection.m_7094_() * knockbackY));
            }
            if (--this.warmupDelayTicks < 0) {
                boolean fracture;
                List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(0.2, 0.0, 0.2));
                for (LivingEntity livingEntity : list) {
                    if (this.getOwner() instanceof Berserker && livingEntity instanceof Preserved) continue;
                    this.dealDamageTo(livingEntity);
                }
                if (!this.sentSpikeEvent) {
                    this.setActive(true);
                    this.m_9236_().m_7605_((Entity)this, (byte)4);
                    this.sentSpikeEvent = true;
                }
                stack = (ItemStack)this.f_19804_.m_135370_(ITEM);
                int ruptureLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)GEnchantments.RUPTURE.get()), (ItemStack)stack);
                boolean bl = fracture = ruptureLevel > 0;
                if (!fracture) {
                    if (this.lifeTicks == 4) {
                        this.m_9236_().m_7605_((Entity)this, (byte)6);
                    }
                    if (--this.lifeTicks < 0) {
                        this.m_146870_();
                    }
                } else if (--this.lifeTicks < 0) {
                    for (int i = 0; i < ruptureLevel + 2; ++i) {
                        PinkSaltShard pinkSaltShard = new PinkSaltShard(this.getOwner(), this.m_9236_());
                        pinkSaltShard.m_20219_(Vec3.m_82512_((Vec3i)this.m_20183_()));
                        Vec3 vec3 = new Vec3(this.f_19796_.m_188583_(), this.f_19796_.m_188583_(), this.f_19796_.m_188583_()).m_82541_();
                        Vec3 vec31 = vec3.m_82490_(0.75);
                        pinkSaltShard.m_20256_(vec31);
                        this.m_9236_().m_7967_((Entity)pinkSaltShard);
                    }
                    this.m_146870_();
                }
            }
            if (this.warmupDelayTicks == 0 && (stack = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)stack;
                Vec3 pos = this.m_20182_();
                server.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, server.m_8055_(this.m_20097_())), pos.f_82479_, pos.f_82480_, pos.f_82481_, 12, 0.4, 0.0, 0.4, 0.1);
                if (this.m_5842_()) {
                    server.m_8767_((ParticleOptions)ParticleTypes.f_123774_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 8, 0.3, 0.0, 0.3, 0.3);
                }
            }
        }
    }

    private void dealDamageTo(LivingEntity livingEntity) {
        LivingEntity livingEntity2 = this.getOwner();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (livingEntity2 != null && player.m_20148_().equals(livingEntity2.m_20148_())) {
                return;
            }
        }
        if (!livingEntity.m_6084_() || livingEntity.m_20147_() || livingEntity == livingEntity2) {
            return;
        }
        if (livingEntity2 == null) {
            livingEntity.m_6469_(this.m_269291_().m_269425_(), this.damage);
        } else {
            boolean slowness;
            if (livingEntity2.m_7307_((Entity)livingEntity)) {
                return;
            }
            livingEntity.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)livingEntity2), this.damage);
            ItemStack stack = (ItemStack)this.f_19804_.m_135370_(ITEM);
            boolean bl = slowness = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)GEnchantments.ENFEEBLE.get()), (ItemStack)stack) > 0;
            if (slowness) {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100));
            }
        }
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        if (damageSource.m_7639_() instanceof Arrow) {
            return false;
        }
        return super.m_6469_(damageSource, f);
    }

    public void m_7822_(byte b) {
        super.m_7822_(b);
        if (b == 4) {
            this.emergeAnimationState.m_216977_(this.f_19797_);
            if (!this.m_20067_()) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)GSoundEvents.PINK_SALT_PILLAR_EMERGE.get(), this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.2f + 0.85f, false);
            }
        } else if (b == 6) {
            this.retractAnimationState.m_216977_(this.f_19797_);
        }
    }
}

