/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.events;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.orcinus.galosphere.api.BannerAttachable;
import net.orcinus.galosphere.api.GoldenBreath;
import net.orcinus.galosphere.api.SpectreBoundSpyglass;
import net.orcinus.galosphere.blocks.WarpedAnchorBlock;
import net.orcinus.galosphere.config.GalosphereConfig;
import net.orcinus.galosphere.entities.Berserker;
import net.orcinus.galosphere.entities.Preserved;
import net.orcinus.galosphere.entities.Sparkle;
import net.orcinus.galosphere.entities.SpectatorVision;
import net.orcinus.galosphere.entities.Specterpillar;
import net.orcinus.galosphere.entities.Spectre;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GCriteriaTriggers;
import net.orcinus.galosphere.init.GEntityTypeTags;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GMobEffects;
import net.orcinus.galosphere.items.SterlingArmorItem;
import net.orcinus.galosphere.util.BannerRendererUtil;
import net.orcinus.galosphere.util.PreservedShulkerBox;

@Mod.EventBusSubscriber(modid="galosphere", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MobEvents {
    @SubscribeEvent
    public static void registerEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)GEntityTypes.SPARKLE.get(), Sparkle.createAttributes().m_22265_());
        event.put((EntityType)GEntityTypes.SPECTRE.get(), Spectre.createAttributes().m_22265_());
        event.put((EntityType)GEntityTypes.SPECTERPILLAR.get(), Specterpillar.createAttributes().m_22265_());
        event.put((EntityType)GEntityTypes.SPECTATOR_VISION.get(), SpectatorVision.createAttributes().m_22265_());
        event.put((EntityType)GEntityTypes.BERSERKER.get(), Berserker.createAttributes().m_22265_());
        event.put((EntityType)GEntityTypes.PRESERVED.get(), Preserved.createAttributes().m_22265_());
    }

    @SubscribeEvent
    public static void registerSpawnPlacements(SpawnPlacementRegisterEvent event) {
        event.register((EntityType)GEntityTypes.SPARKLE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Sparkle::checkSparkleSpawnRules, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)GEntityTypes.SPECTRE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_, SpawnPlacementRegisterEvent.Operation.AND);
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        ItemStack itemStack = event.getItemStack();
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null && tag.m_128441_("Preserved")) {
            event.getToolTip().add(Component.m_237115_((String)"item.galosphere.preserved").m_130940_(ChatFormatting.DARK_PURPLE));
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        Predicate<CompoundTag> predicate = compoundTag -> compoundTag != null && compoundTag.m_128441_("Preserved");
        event.getOriginal().m_150109_().f_35974_.stream().filter(itemStack -> predicate.test(itemStack.m_41783_())).forEach(arg_0 -> ((Inventory)serverPlayer.m_150109_()).m_36054_(arg_0));
    }

    @SubscribeEvent
    public void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        BlockEntity blockEntity = entity.m_9236_().m_7702_(event.getPos());
        if (entity instanceof Player) {
            Player player = (Player)entity;
            CompoundTag tag = player.m_21205_().m_41783_();
            if (tag != null && tag.m_128441_("Preserved") && blockEntity instanceof ShulkerBoxBlockEntity) {
                ShulkerBoxBlockEntity shulkerBoxBlock = (ShulkerBoxBlockEntity)blockEntity;
                ((PreservedShulkerBox)shulkerBoxBlock).setPreserved(true);
            }
            if (player.m_21023_((MobEffect)GMobEffects.BLOCK_BANE.get()) && !player.m_150110_().f_35937_) {
                player.m_6469_(player.m_9236_().m_269111_().m_269425_(), 3.0f);
                player.m_36335_().m_41524_(player.m_21120_(player.m_7655_()).m_41720_(), 100);
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        ShulkerBoxBlockEntity shulkerBoxBlockEntity;
        LevelAccessor world = event.getLevel();
        BlockPos pos = event.getPos();
        BlockEntity blockEntity = world.m_7702_(pos);
        Player player = event.getPlayer();
        BlockState state = event.getState();
        if (blockEntity instanceof ShulkerBoxBlockEntity && ((PreservedShulkerBox)(shulkerBoxBlockEntity = (ShulkerBoxBlockEntity)blockEntity)).isPreserved()) {
            ItemStack stack = new ItemStack((ItemLike)ShulkerBoxBlock.m_56190_((DyeColor)((ShulkerBoxBlock)state.m_60734_()).m_56261_()));
            shulkerBoxBlockEntity.m_187476_(stack);
            if (shulkerBoxBlockEntity.m_8077_()) {
                stack.m_41714_(shulkerBoxBlockEntity.m_7770_());
            }
            stack.m_41784_().m_128379_("Preserved", true);
            ItemEntity itementity = new ItemEntity(player.m_9236_(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack);
            itementity.m_32060_();
            world.m_7967_((Entity)itementity);
            world.m_7471_(pos, false);
            state.m_60734_().m_5707_(player.m_9236_(), pos, state, player);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onBreakSpeedChanged(PlayerEvent.BreakSpeed event) {
        BlockState state = event.getState();
        if (state.m_60734_() == Blocks.f_152491_ && ((Boolean)GalosphereConfig.SLOWED_BUDDING_AMETHYST_MINING_SPEED.get()).booleanValue()) {
            event.setNewSpeed(2.0f);
        }
    }

    @SubscribeEvent
    public void onItemExpire(ItemExpireEvent event) {
        BlockState blockState;
        ItemEntity entity = event.getEntity();
        if (!entity.m_9236_().f_46443_ && (blockState = entity.m_9236_().m_8055_(BlockPos.m_274561_((double)entity.m_146892_().f_82479_, (double)entity.m_146892_().f_82480_, (double)entity.m_146892_().f_82481_))).m_60713_((Block)GBlocks.STRANDED_MEMBRANE_BLOCK.get())) {
            event.setExtraLife(6000);
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        BannerAttachable bannerAttachable;
        Horse horse;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Horse && (horse = (Horse)livingEntity) instanceof BannerAttachable && !(bannerAttachable = (BannerAttachable)horse).getBanner().m_41619_() && horse.m_30722_().m_150930_((Item)GItems.STERLING_HORSE_ARMOR.get())) {
            ItemStack copy = bannerAttachable.getBanner();
            horse.m_19983_(copy);
            bannerAttachable.setBanner(ItemStack.f_41583_);
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingHurtEvent event) {
        Mob mob;
        boolean flag;
        LivingEntity entity = event.getEntity();
        DamageSource source = event.getSource();
        float originalAmount = event.getAmount();
        EquipmentSlot[] equipmentSlotArray = source.m_7639_();
        boolean bl = flag = equipmentSlotArray instanceof Mob && ((mob = (Mob)equipmentSlotArray).m_6336_() == MobType.f_21643_ || mob.m_6095_().m_204039_(GEntityTypeTags.STERLING_IMMUNE_ENTITY_TYPES));
        if (flag) {
            Horse horse;
            if (entity instanceof Horse && (horse = (Horse)entity).m_30722_().m_150930_((Item)GItems.STERLING_HORSE_ARMOR.get())) {
                event.setAmount(originalAmount - 4.0f);
            }
            float illagerReduction = 0.0f;
            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                Item item = entity.m_6844_(equipmentSlot).m_41720_();
                if (!(item instanceof SterlingArmorItem)) continue;
                SterlingArmorItem sterlingArmorItem = (SterlingArmorItem)item;
                if (equipmentSlot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
                illagerReduction += sterlingArmorItem.getInsurgentResistance(equipmentSlot);
            }
            if (illagerReduction > 0.0f) {
                float value = 4.0f * (originalAmount / illagerReduction);
                event.setAmount(value);
            }
        }
    }

    @SubscribeEvent
    public void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        Horse horse;
        ItemStack stack = event.getItemStack();
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        Entity target = event.getTarget();
        BannerRendererUtil util = new BannerRendererUtil();
        if (target instanceof Horse && (horse = (Horse)target).m_30722_().m_150930_((Item)GItems.STERLING_HORSE_ARMOR.get())) {
            if (((BannerAttachable)horse).getBanner().m_41619_()) {
                if ((util.isTapestryStack(stack) || stack.m_41720_() instanceof BannerItem) && !horse.m_9236_().m_5776_()) {
                    event.setCanceled(true);
                    ItemStack copy = stack.m_41777_();
                    if (!player.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                    copy.m_41764_(1);
                    horse.m_9236_().m_6269_(null, (Entity)horse, SoundEvents.f_11973_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    horse.m_146852_(GameEvent.f_223708_, (Entity)player);
                    ((BannerAttachable)horse).setBanner(copy);
                    player.m_6674_(hand);
                }
            } else if (player.m_6144_() && stack.m_41619_() && !horse.m_9236_().m_5776_()) {
                event.setCanceled(true);
                ItemStack copy = ((BannerAttachable)horse).getBanner();
                player.m_21008_(hand, copy);
                horse.m_9236_().m_6269_(null, (Entity)horse, SoundEvents.f_11973_, SoundSource.PLAYERS, 1.0f, 1.0f);
                horse.m_146852_(GameEvent.f_223708_, (Entity)player);
                ((BannerAttachable)horse).setBanner(ItemStack.f_41583_);
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        GoldenBreath goldenBreath;
        BannerAttachable bannerEntity;
        LivingEntity entity = event.getEntity();
        ItemStack useItem = entity.m_21211_();
        if (entity instanceof BannerAttachable && !(bannerEntity = (BannerAttachable)entity).getBanner().m_41619_()) {
            if (entity instanceof Horse) {
                Horse horse = (Horse)entity;
                if (!((BannerAttachable)horse).getBanner().m_41619_() && !horse.m_30722_().m_150930_((Item)GItems.STERLING_HORSE_ARMOR.get())) {
                    ItemStack copy = ((BannerAttachable)horse).getBanner();
                    horse.m_19983_(copy);
                    ((BannerAttachable)horse).setBanner(ItemStack.f_41583_);
                }
            } else if (!entity.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)GItems.STERLING_HELMET.get())) {
                ItemStack copy = bannerEntity.getBanner();
                entity.m_19983_(copy);
                bannerEntity.setBanner(ItemStack.f_41583_);
            }
        }
        if (entity.m_6084_() && entity instanceof GoldenBreath && (goldenBreath = (GoldenBreath)entity).getGoldenAirSupply() > 0.0f) {
            goldenBreath.setGoldenAirSupply(goldenBreath.decreaseGoldenAirSupply(entity, (int)goldenBreath.getGoldenAirSupply()));
        }
        if (SpectreBoundSpyglass.canUseSpectreBoundedSpyglass(useItem) && useItem.m_41783_() != null && !entity.m_9236_().f_46443_) {
            Entity spectreBound = ((ServerLevel)entity.m_9236_()).m_8791_(useItem.m_41783_().m_128342_("SpectreBoundUUID"));
            Optional.ofNullable(spectreBound).filter(Spectre.class::isInstance).map(Spectre.class::cast).filter(LivingEntity::m_6084_).ifPresent(spectre -> {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (spectre.getManipulatorUUID() != player.m_20148_()) {
                        boolean withinDistance;
                        boolean bl = withinDistance = Math.sqrt(Math.pow(player.m_20185_() - spectre.m_20185_(), 2.0) + Math.pow(player.m_20189_() - spectre.m_20189_(), 2.0)) < 110.0;
                        if (withinDistance) {
                            spectre.setCamera(player);
                        }
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public void onTeleportEvent(EntityTeleportEvent.EnderPearl event) {
        block4: {
            ThrownEnderpearl pearl = event.getPearlEntity();
            ArrayList poses = Lists.newArrayList();
            ServerPlayer player = event.getPlayer();
            Level world = player.m_9236_();
            BlockPos pearlPos = pearl.m_20183_();
            int radius = 16;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    for (int y = -radius; y <= radius; ++y) {
                        BlockPos blockPos = BlockPos.m_274561_((double)(pearl.m_20185_() + (double)x), (double)(pearl.m_20186_() + (double)y), (double)(pearl.m_20189_() + (double)z));
                        BlockState blockState = world.m_8055_(blockPos);
                        if (!blockState.m_60713_((Block)GBlocks.WARPED_ANCHOR.get()) || (Integer)blockState.m_61143_((Property)WarpedAnchorBlock.WARPED_CHARGE) <= 0) continue;
                        poses.add(blockPos);
                    }
                }
            }
            if (poses.isEmpty()) break block4;
            poses.sort(Comparator.comparingDouble(arg_0 -> ((BlockPos)pearlPos).m_123331_(arg_0)));
            Iterator iterator = poses.iterator();
            if (iterator.hasNext()) {
                BlockPos blockPos = (BlockPos)iterator.next();
                event.setCanceled(true);
                GCriteriaTriggers.WARPED_TELEPORT.trigger(player);
                pearl.m_9236_().m_142346_((Entity)player, GameEvent.f_157792_, blockPos);
                pearl.m_9236_().m_5594_(null, blockPos, SoundEvents.f_12326_, SoundSource.BLOCKS, 1.0f, 1.0f);
                player.m_6021_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5);
                player.m_183634_();
                pearl.m_9236_().m_7731_(blockPos, (BlockState)pearl.m_9236_().m_8055_(blockPos).m_61124_((Property)WarpedAnchorBlock.WARPED_CHARGE, (Comparable)Integer.valueOf((Integer)pearl.m_9236_().m_8055_(blockPos).m_61143_((Property)WarpedAnchorBlock.WARPED_CHARGE) - 1)), 2);
                pearl.m_146870_();
            }
        }
    }
}

