/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.world.gen.features;

import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.orcinus.galosphere.blocks.PinkSaltLampBlock;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.world.gen.PinkSaltUtil;
import net.orcinus.galosphere.world.gen.features.config.NoisePatchConfig;

public class NoisePatchFeature
extends Feature<NoisePatchConfig> {
    public NoisePatchFeature(Codec<NoisePatchConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoisePatchConfig> context) {
        WorldGenLevel worldgenlevel = context.m_159774_();
        RandomSource randomsource = context.m_225041_();
        BlockPos blockpos = context.m_159777_();
        Predicate<BlockState> predicate = state -> state.m_204336_(BlockTags.f_13061_);
        int i = UniformInt.m_146622_((int)4, (int)7).m_214085_(randomsource) + 1;
        int j = UniformInt.m_146622_((int)4, (int)7).m_214085_(randomsource) + 1;
        Set<BlockPos> set = this.placeGroundPatch(((NoisePatchConfig)context.m_159778_()).caveSurface(), worldgenlevel, randomsource, blockpos, predicate, i, j);
        return !set.isEmpty();
    }

    protected Set<BlockPos> placeGroundPatch(CaveSurface caveSurface, WorldGenLevel world, RandomSource random, BlockPos blockPos, Predicate<BlockState> predicate, int xRadius, int zRadius) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = blockPos.m_122032_();
        BlockPos.MutableBlockPos blockpos$mutableblockpos1 = blockpos$mutableblockpos.m_122032_();
        Direction direction = caveSurface.m_162107_();
        Direction direction1 = direction.m_122424_();
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        for (int i = -xRadius; i <= xRadius; ++i) {
            boolean flag = i == -xRadius || i == xRadius;
            for (int j = -zRadius; j <= zRadius; ++j) {
                boolean flag4;
                boolean flag1 = j == -zRadius || j == zRadius;
                boolean flag2 = flag || flag1;
                boolean flag3 = flag && flag1;
                boolean bl = flag4 = flag2 && !flag3;
                if (flag3 || flag4 && random.m_188501_() > 0.3f) continue;
                blockpos$mutableblockpos.m_122154_((Vec3i)blockPos, i, 0, j);
                for (int k = 0; world.m_7433_((BlockPos)blockpos$mutableblockpos, DripstoneUtils::m_159664_) && k < 5; ++k) {
                    blockpos$mutableblockpos.m_122173_(direction);
                }
                for (int i1 = 0; world.m_7433_((BlockPos)blockpos$mutableblockpos, state -> !state.m_60795_() && !state.m_60713_(Blocks.f_49990_)) && i1 < 5; ++i1) {
                    blockpos$mutableblockpos.m_122173_(direction1);
                }
                blockpos$mutableblockpos1.m_122159_((Vec3i)blockpos$mutableblockpos, caveSurface.m_162107_());
                BlockState blockstate = world.m_8055_((BlockPos)blockpos$mutableblockpos1);
                if (!world.m_7433_((BlockPos)blockpos$mutableblockpos, DripstoneUtils::m_159664_) || !blockstate.m_60783_((BlockGetter)world, (BlockPos)blockpos$mutableblockpos1, caveSurface.m_162107_().m_122424_())) continue;
                int l = ConstantInt.m_146483_((int)3).m_214085_(random);
                BlockPos blockpos = blockpos$mutableblockpos1.m_7949_();
                boolean flag5 = this.placeGround(random, caveSurface, world, predicate, blockpos$mutableblockpos1, l);
                if (!flag5) continue;
                set.add(blockpos);
            }
        }
        return set;
    }

    protected boolean placeGround(RandomSource random, CaveSurface caveSurface, WorldGenLevel world, Predicate<BlockState> predicate, BlockPos.MutableBlockPos mutable, int tries) {
        Block block = PinkSaltUtil.getBlock(world.m_7328_(), mutable);
        for (int i = 0; i < tries; ++i) {
            BlockState blockstate1;
            BlockState blockstate = block.m_49966_();
            if (blockstate.m_60713_((blockstate1 = world.m_8055_((BlockPos)mutable)).m_60734_())) continue;
            if (!predicate.test(blockstate1)) {
                return i != 0;
            }
            world.m_7731_((BlockPos)mutable, blockstate, 2);
            if (random.m_188503_(30) == 0) {
                for (Direction direction : Direction.values()) {
                    BlockPos clusterPos = mutable.m_121945_(direction);
                    if (random.m_188503_(10) != 0 || !world.m_7433_(clusterPos, DripstoneUtils::m_159664_)) continue;
                    world.m_7731_(clusterPos, (BlockState)((BlockState)((Block)GBlocks.PINK_SALT_CLUSTER.get()).m_49966_().m_61124_((Property)PinkSaltLampBlock.FACING, (Comparable)direction)).m_61124_((Property)PinkSaltLampBlock.WATERLOGGED, (Comparable)Boolean.valueOf(world.m_8055_(clusterPos).m_60713_(Blocks.f_49990_))), 2);
                }
            }
            mutable.m_122173_(caveSurface.m_162107_());
        }
        return true;
    }
}

