/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.world.gen.features;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.mixin.WorldGenRegionAccessor;
import net.orcinus.galosphere.world.gen.FastNoise;
import net.orcinus.galosphere.world.gen.PinkSaltUtil;

public class OasisFeature
extends Feature<NoneFeatureConfiguration> {
    public OasisFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel world = featurePlaceContext.m_159774_();
        BlockPos blockPos = featurePlaceContext.m_159777_();
        RandomSource random = featurePlaceContext.m_225041_();
        int worldSeed = (int)world.m_7328_();
        FastNoise fastNoise = new FastNoise(worldSeed);
        fastNoise.SetNoiseType(FastNoise.NoiseType.Simplex);
        fastNoise.SetFrequency(0.8f);
        FastNoise ceilingNoise = new FastNoise(worldSeed);
        ceilingNoise.SetNoiseType(FastNoise.NoiseType.Simplex);
        ceilingNoise.SetFrequency(0.3f);
        ceilingNoise.SetFractalOctaves(3);
        int xRadius = this.getRandomRadius(random) / 2;
        int yRadius = UniformInt.m_146622_((int)15, (int)20).m_214085_(random);
        int zRadius = this.getRandomRadius(random) / 2;
        ArrayList positions = Lists.newArrayList();
        for (int x = -xRadius; x <= xRadius; ++x) {
            for (int z = -zRadius; z <= zRadius; ++z) {
                for (int y = -yRadius; y <= 0; ++y) {
                    BlockPos pos = new BlockPos(blockPos.m_123341_() + x, blockPos.m_123342_() + y, blockPos.m_123343_() + z);
                    StructureManager structureManager = ((WorldGenRegionAccessor)featurePlaceContext.m_159774_()).getStructureManager();
                    Structure structure = (Structure)structureManager.m_220521_().m_175515_(Registries.f_256944_).m_7745_(Galosphere.id("pink_salt_shrine"));
                    if (structure != null && structureManager.m_220524_(pos, structure).m_73603_()) {
                        return false;
                    }
                    double xSquared = x * x;
                    double ySquared = y * y;
                    double zSquared = z * z;
                    double threshold = 1.0f + 3.0f * fastNoise.GetNoise(blockPos.m_123341_() + x, blockPos.m_123342_() + y, blockPos.m_123343_() + z);
                    if (!(xSquared / (double)(xRadius * 2) + ySquared / (double)(yRadius * 2) + zSquared / (double)(zRadius * 2) < threshold) || !(xSquared + ySquared + zSquared <= (double)(xRadius * zRadius)) || y >= 0) continue;
                    positions.add(pos);
                }
            }
        }
        int waterLevel = blockPos.m_123342_() - 1;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (BlockPos position : positions) {
            BlockPos.MutableBlockPos mutable3 = mutableBlockPos.m_122178_(position.m_123341_(), Math.min(position.m_123342_(), waterLevel), position.m_123343_());
            for (int i = mutable3.m_123342_(); i <= waterLevel; ++i) {
                this.generateMiniAquifer(world, (BlockPos)mutable3);
                mutable3.m_122173_(Direction.UP);
            }
        }
        return true;
    }

    private int getRandomRadius(RandomSource random) {
        return UniformInt.m_146622_((int)15, (int)21).m_214085_(random);
    }

    private void generateMiniAquifer(WorldGenLevel world, BlockPos mutable2) {
        if (world.m_8055_(mutable2.m_7494_()).m_60795_()) {
            world.m_7731_(mutable2, Blocks.f_49990_.m_49966_(), 2);
            world.m_186469_(mutable2, (Fluid)Fluids.f_76193_, 0);
        }
        BlockPos.MutableBlockPos mutable3 = new BlockPos.MutableBlockPos();
        for (Direction value : Direction.values()) {
            if (value == Direction.UP) continue;
            mutable3.m_122159_((Vec3i)mutable2, value);
            if (world.m_8055_((BlockPos)mutable3).m_60713_(Blocks.f_49990_)) continue;
            world.m_7731_((BlockPos)mutable3, PinkSaltUtil.getBlock(world.m_7328_(), mutable3).m_49966_(), 2);
        }
    }
}

