/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.twilight_construct.modules.fluid;

import dev.xkmc.twilight_construct.modules.fluid.TCFluids;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.recipe.data.ICommonRecipeHelper;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.registration.object.FlowingFluidObject;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.data.recipe.IByproduct;
import slimeknights.tconstruct.library.data.recipe.ISmelteryRecipeHelper;
import slimeknights.tconstruct.library.recipe.alloying.AlloyRecipeBuilder;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuelBuilder;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipeBuilder;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFItems;

public class TCFluidRecipeProvider
extends RecipeProvider
implements ISmelteryRecipeHelper,
ICommonRecipeHelper {
    public TCFluidRecipeProvider(PackOutput packOutput) {
        super(packOutput);
    }

    public String getModId() {
        return "twilight_construct";
    }

    public String m_6055_() {
        return "Twilight Construct Recipes";
    }

    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
        RecipeStruct fiery = new RecipeStruct("twilightforest", "fiery", TCFluids.MOLTEN_FIERY).genRecipe(this, consumer);
        RecipeStruct knight = new RecipeStruct("twilightforest", "knightmetal", TCFluids.MOLTEN_KNIGHTMETAL).genRecipe(this, consumer);
        RecipeStruct steeleaf = new RecipeStruct("twilightforest", "steeleaf", TCFluids.MOLTEN_STEELEAF).genRecipe(this, consumer);
        RecipeStruct ironwood = new RecipeStruct("twilightforest", "ironwood", TCFluids.MOLTEN_IRONWOOD).genRecipe(this, consumer);
        RecipeStruct phantom = new RecipeStruct("twilightforest", "phantom", TCFluids.MOLTEN_PHANTOM);
        RecipeStruct carminite = new RecipeStruct("twilightforest", "carminite", TCFluids.MOLTEN_CARMINITE);
        carminite.genMeltItem(this, consumer, "/block", 810, ((Block)TFBlocks.CARMINITE_BLOCK.get()).m_5456_());
        carminite.genMeltItem(this, consumer, "/gem", 90, (Item)TFItems.CARMINITE.get());
        carminite.genMeltItem(this, consumer, "/machines", 360, ((Block)TFBlocks.CARMINITE_BUILDER.get()).m_5456_(), ((Block)TFBlocks.CARMINITE_REACTOR.get()).m_5456_());
        carminite.genMeltItem(this, consumer, "/reappearing", 40, ((Block)TFBlocks.REAPPEARING_BLOCK.get()).m_5456_());
        carminite.genMeltItem(this, consumer, "/vanishing", 10, ((Block)TFBlocks.VANISHING_BLOCK.get()).m_5456_());
        phantom.genMeltTool(this, consumer, "/helmet", 450, (Item)TFItems.PHANTOM_HELMET.get());
        phantom.genMeltTool(this, consumer, "/chestplate", 720, (Item)TFItems.PHANTOM_CHESTPLATE.get());
        ironwood.genMeltItem(this, consumer, "/raw", 120, (Item)TFItems.RAW_IRONWOOD.get());
        knight.genMeltItem(this, consumer, "/shard", 10, (Item)TFItems.ARMOR_SHARD.get());
        knight.genMeltItem(this, consumer, "/cluster", 90, (Item)TFItems.ARMOR_SHARD_CLUSTER.get());
        knight.genMeltItem(this, consumer, "/loop", 360, (Item)TFItems.KNIGHTMETAL_RING.get());
        knight.genMeltItem(this, consumer, "/maze_breaker", 450, (Item)TFItems.MAZEBREAKER_PICKAXE.get());
        knight.genMeltTool(this, consumer, "/shield", 630, (Item)TFItems.KNIGHTMETAL_SHIELD.get());
        knight.genMeltTool(this, consumer, "/block_and_chain", 1440, (Item)TFItems.BLOCK_AND_CHAIN.get());
        String folder = "smeltery/melting/";
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.IRON_LADDER.get()}), (FluidObject)TinkerFluids.moltenIron, (int)30).save(consumer, this.location(folder + "metal/iron/ladder"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TFItems.GOLDEN_MINOTAUR_AXE.get()}), (FluidObject)TinkerFluids.moltenGold, (int)450).save(consumer, this.location(folder + "metal/gold/minotaur_axe"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TFItems.DIAMOND_MINOTAUR_AXE.get()}), (FluidObject)TinkerFluids.moltenDiamond, (int)500).save(consumer, this.location(folder + "gems/diamond/minotaur_axe"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.GIANT_OBSIDIAN.get()}), (FluidObject)TinkerFluids.moltenObsidian, (int)64000).save(consumer, this.location(folder + "obsidian/giant_block"));
        String folder2 = "smeltery/casting/";
        ItemCastingRecipeBuilder.tableRecipe((ItemOutput)ItemOutput.fromItem((ItemLike)((ItemLike)TFItems.EXPERIMENT_115.get()))).setFluidAndTime(TCFluids.MOLTEN_CARMINITE, 90).setCast((ItemLike)Items.f_42502_, true).save(consumer, this.location(folder2 + "misc/exp_115"));
        ItemCastingRecipeBuilder.tableRecipe((ItemOutput)ItemOutput.fromItem((ItemLike)((ItemLike)TFBlocks.RED_THREAD.get()))).setFluidAndTime(TCFluids.FIERY_BLOOD, 50).setCast((ItemLike)Items.f_42401_, true).save(consumer, this.location(folder2 + "misc/red_thread"));
        folder2 = "smeltery/alloying/";
        AlloyRecipeBuilder.alloy(TCFluids.MOLTEN_FIERY, (int)120).addInput(TCFluids.FIERY_BLOOD.ingredient(250)).addInput(TinkerFluids.moltenIron.ingredient(90)).save(consumer, this.location(folder2 + "molten_fiery"));
        AlloyRecipeBuilder.alloy(TCFluids.FIERY_BLOOD, (int)50).addInput(TCFluids.MOLTEN_CARMINITE.ingredient(90)).addInput(TinkerFluids.blazingBlood.ingredient(100)).addInput(TinkerFluids.moltenDebris.ingredient(30)).save(consumer, this.location(folder2 + "fiery_essence"));
        MeltingFuelBuilder.fuel((FluidStack)new FluidStack(TCFluids.FIERY_BLOOD.get(), 10), (int)400).save(consumer, this.location("smeltery/fuel/fiery"));
    }

    public record RecipeStruct(String mod, String id, FlowingFluidObject<ForgeFlowingFluid> fluid) {
        public RecipeStruct genRecipe(TCFluidRecipeProvider pvd, Consumer<FinishedRecipe> consumer) {
            String meltingFolder = "smeltery/melting/metal/";
            pvd.metalMelting(consumer, (FluidObject)this.fluid, this.id, false, false, meltingFolder, true, new IByproduct[0]);
            MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.get("helmet")}), this.fluid, (int)450).setDamagable(new int[]{10}).save(consumer, pvd.location(meltingFolder + this.id + "/helmet"));
            MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.get("chestplate")}), this.fluid, (int)720).setDamagable(new int[]{10}).save(consumer, pvd.location(meltingFolder + this.id + "/chestplate"));
            MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.get("leggings")}), this.fluid, (int)630).setDamagable(new int[]{10}).save(consumer, pvd.location(meltingFolder + this.id + "/leggings"));
            MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.get("boots")}), this.fluid, (int)360).setDamagable(new int[]{10}).save(consumer, pvd.location(meltingFolder + this.id + "/boots"));
            this.genMeltTool(pvd, consumer, "/axes", 270, this.get("axe"), this.get("pickaxe"));
            this.genMeltTool(pvd, consumer, "/weapon", 180, this.get("sword"), this.get("hoe"));
            this.genMeltTool(pvd, consumer, "/small", 90, this.get("shovel"));
            String castingFolder = "smeltery/casting/metal/";
            pvd.metalTagCasting(consumer, (FluidObject)this.fluid, this.id, castingFolder, false);
            return this;
        }

        private RecipeStruct genMeltItem(TCFluidRecipeProvider pvd, Consumer<FinishedRecipe> consumer, String loc, int amount, Item ... items) {
            String meltingFolder = "smeltery/melting/metal/" + this.id + loc;
            Ingredient ing = Ingredient.m_43921_(Stream.of(items).filter(Objects::nonNull).map(ItemStack::new));
            if (ing.m_43947_()) {
                return this;
            }
            MeltingRecipeBuilder.melting((Ingredient)ing, this.fluid, (int)amount).save(consumer, pvd.location(meltingFolder));
            return this;
        }

        private RecipeStruct genMeltTool(TCFluidRecipeProvider pvd, Consumer<FinishedRecipe> consumer, String loc, int amount, Item ... items) {
            String meltingFolder = "smeltery/melting/metal/" + this.id + loc;
            Ingredient ing = Ingredient.m_43921_(Stream.of(items).filter(Objects::nonNull).map(ItemStack::new));
            if (ing.m_43947_()) {
                return this;
            }
            MeltingRecipeBuilder.melting((Ingredient)ing, this.fluid, (int)amount).setDamagable(new int[]{10}).save(consumer, pvd.location(meltingFolder));
            return this;
        }

        @Nullable
        private Item get(String name) {
            Item ans = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.mod, this.id + "_" + name));
            if (ans == null || ans == Items.f_41852_) {
                return null;
            }
            return ans;
        }
    }
}

