/*
 * Decompiled with CFR 0.152.
 */
package io.github.bluesheep2804.jaopcaextras.modules;

import io.github.bluesheep2804.jaopcaextras.recipes.ShapedRecipeSerializer;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.forms.IFormRequest;
import thelm.jaopca.api.forms.IFormType;
import thelm.jaopca.api.helpers.IMiscHelper;
import thelm.jaopca.api.items.IItemInfo;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.api.recipes.IRecipeSerializer;

@JAOPCAModule
public class GearsModule
implements IModule {
    private final JAOPCAApi api = JAOPCAApi.instance();
    private final IForm gearForm = this.api.newForm((IModule)this, "gears", (IFormType)this.api.itemFormType()).setMaterialTypes(MaterialType.INGOTS);

    public String getName() {
        return "extras_gears";
    }

    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.allOf(MaterialType.class);
    }

    public List<IFormRequest> getFormRequests() {
        return Collections.singletonList(this.api.newFormRequest((IModule)this, new IForm[]{this.gearForm}));
    }

    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        IMiscHelper miscHelper = this.api.miscHelper();
        for (IMaterial material : this.gearForm.getMaterials()) {
            ResourceLocation materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
            IItemInfo gearInfo = this.api.itemFormType().getMaterialFormInfo(this.gearForm, material);
            this.api.registerRecipe(new ResourceLocation("jaopcaextras", "gears.from_material." + material.getName()), (IRecipeSerializer)new ShapedRecipeSerializer(new String[]{" M ", "M M", " M "}, Map.of("M", materialLocation), gearInfo, 1));
        }
    }
}

